/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.model.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.ActConstants;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.ActActivityChangeCommodityInfoQryDO;
import com.tydic.dyc.act.model.bo.ActActivityChangeUserScoresChangeDO;
import com.tydic.dyc.act.model.bo.ActAlertOrderInfo;
import com.tydic.dyc.act.model.bo.ActSkuInfoBO;
import com.tydic.dyc.act.model.bo.ActivityChangeRelaCommodityInfo;
import com.tydic.dyc.act.model.bo.ActivityChangeUserInfo;
import com.tydic.dyc.act.model.bo.ActivityChangeUserInfoQryBO;
import com.tydic.dyc.act.model.bo.ActivityImportChangeCommodityInfo;
import com.tydic.dyc.act.model.bo.DycActActivityRelaCommodityInfo;
import com.tydic.dyc.act.model.bo.DycActDealOrderAlertDO;
import com.tydic.dyc.act.model.bo.DycActFscOrderDO;
import com.tydic.dyc.act.model.bo.DycActImportActivityChangeCommodityModelReqBO;
import com.tydic.dyc.act.model.bo.DycActImportActivityChangeCommodityModelRspBO;
import com.tydic.dyc.act.model.bo.DycActImportActivityChangeUserModelReqBO;
import com.tydic.dyc.act.model.bo.DycActImportActivityChangeUserModelRspBO;
import com.tydic.dyc.act.model.bo.DycActImportActivityCommodityModelBO;
import com.tydic.dyc.act.model.bo.DycActImportActivityInfoModelBO;
import com.tydic.dyc.act.model.bo.DycActSubmitActivityChangeReqDO;
import com.tydic.dyc.act.model.bo.DycActSubmitActivityChangeRspDO;
import com.tydic.dyc.act.model.bo.DycActiveCommodityCatalogInfo;
import com.tydic.dyc.act.model.bo.DycActivityBaseInfo;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.model.bo.DycActivityChangeInfo;
import com.tydic.dyc.act.model.bo.DycActivityChangeRelaCommodityCatalogInfo;
import com.tydic.dyc.act.model.bo.DycActivityChangeRelaCommodityInfo;
import com.tydic.dyc.act.model.bo.DycActivityChangeRelaCommodityPoolInfo;
import com.tydic.dyc.act.model.bo.DycActivityChangeRspDO;
import com.tydic.dyc.act.model.bo.DycActivityChangeSupplierInfo;
import com.tydic.dyc.act.model.bo.DycActivityChangeUserInfo;
import com.tydic.dyc.act.model.bo.DycActivityCommodityPoolInfo;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.model.bo.DycActivityFileInfo;
import com.tydic.dyc.act.model.bo.DycActivityFlowInstanceInfo;
import com.tydic.dyc.act.model.bo.DycActivitySupplierInfo;
import com.tydic.dyc.act.model.bo.DycActivityUserInfo;
import com.tydic.dyc.act.model.bo.DycProcessDO;
import com.tydic.dyc.act.model.bo.DycQueryActivityCommodityPoolPageListReqBO;
import com.tydic.dyc.act.repository.api.ActActivityChangeUserScoresChangeRepository;
import com.tydic.dyc.act.repository.api.DycActActivityChangeCommodityCatalogInComRepository;
import com.tydic.dyc.act.repository.api.DycActActivityChangeCommodityCatalogRepository;
import com.tydic.dyc.act.repository.api.DycActActivityChangeCommodityRepository;
import com.tydic.dyc.act.repository.api.DycActActivityChangeRepository;
import com.tydic.dyc.act.repository.api.DycActActivityChangeSupplierRepository;
import com.tydic.dyc.act.repository.api.DycActActivityChangeUserRepository;
import com.tydic.dyc.act.repository.api.DycActActivityCommodityCatalogInComRepository;
import com.tydic.dyc.act.repository.api.DycActActivityCommodityCatalogRepository;
import com.tydic.dyc.act.repository.api.DycActActivityCommodityRepository;
import com.tydic.dyc.act.repository.api.DycActActivityRepository;
import com.tydic.dyc.act.repository.api.DycActActivitySupplierRepository;
import com.tydic.dyc.act.repository.api.DycActActivityUserRepository;
import com.tydic.dyc.act.repository.api.DycActAlertInfoRepository;
import com.tydic.dyc.act.repository.api.DycActFileRepository;
import com.tydic.dyc.act.repository.api.DycActSkuInfoRepository;
import com.tydic.dyc.act.repository.api.DycActivityFlowInstanceRepository;
import com.tydic.dyc.act.service.bo.DycActDealAppApproveActivityReqBo;
import com.tydic.dyc.act.service.bo.DycActDealAppApproveActivityRspBo;
import com.tydic.dyc.act.service.bo.DycActImportActivityInfoBO;
import com.tydic.dyc.act.service.bo.DycActQuerySyncActivityUserChangeListReqBo;
import com.tydic.dyc.act.service.bo.DycActQuerySyncActivityUserChangeListRspBo;
import com.tydic.dyc.act.service.bo.DycActivityChangeSupplierInfoBO;
import com.tydic.dyc.act.service.bo.SyncUserScoreBoList;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class DycActivityChangeModelImpl
implements DycActivityChangeModel {
    private static final Logger log = LoggerFactory.getLogger(DycActivityChangeModelImpl.class);
    @Autowired
    private DycActActivityChangeRepository dycActActivityChangeRepository;
    @Autowired
    private DycActFileRepository dycActFileRepository;
    @Autowired
    private DycActActivityChangeCommodityRepository dycActActivityChangeCommodityRepository;
    @Autowired
    private DycActSkuInfoRepository dycActSkuInfoRepository;
    @Autowired
    private DycActActivityRepository dycActActivityRepository;
    @Autowired
    private DycActActivitySupplierRepository dycActActivitySupplierRepository;
    @Autowired
    private DycActActivityChangeSupplierRepository dycActActivityChangeSupplierRepository;
    @Autowired
    private DycActActivityCommodityRepository dycActActivityCommodityRepository;
    @Autowired
    private DycActActivityUserRepository dycActActivityUserRepository;
    @Autowired
    private DycActActivityChangeUserRepository dycActActivityChangeUserRepository;
    @Autowired
    private ActActivityChangeUserScoresChangeRepository actActivityChangeUserScoresChangeRepository;
    @Autowired
    private DycActActivityChangeCommodityCatalogRepository dycActActivityChangeCommodityCatalogRepository;
    @Autowired
    private DycActActivityCommodityCatalogRepository dycActActivityCommodityCatalogRepository;
    @Autowired
    private CfcEncodedSerialGetService cfcEncodedSerialGetService;
    @Value(value="${DEAL_ACTIVITY:http://act-task:8080/act/task/activityScoresSyncBySingleId}")
    private String DEAL_ACTIVITY;
    @Autowired
    private DycActivityFlowInstanceRepository dycActivityFlowInstanceRepository;
    @Value(value="${yYLastPayTime:59}")
    private String yYLastPayTime;
    @Autowired
    private DycActAlertInfoRepository dycActAlertInfoRepository;
    @Autowired
    private DycActActivityChangeCommodityCatalogInComRepository dycActActivityChangeCommodityCatalogInComRepository;
    @Autowired
    private DycActActivityCommodityCatalogInComRepository dycActActivityCommodityCatalogInComRepository;

    @Override
    public DycActivityChangeRspDO queryActivityChangeBaseInfo(DycActivityChangeDO reqBo) {
        DycActivityChangeRspDO rspBo = new DycActivityChangeRspDO();
        DycActivityChangeInfo changeInfo = this.dycActActivityChangeRepository.queryActivityChangeBaseInfo(reqBo);
        DycActivityBaseInfo dycActivityBaseInfoModel = new DycActivityBaseInfo();
        dycActivityBaseInfoModel.setActivityId(changeInfo.getOriginalActivityId());
        DycActivityBaseInfo modelByNew = this.dycActActivityRepository.getModelByNew(dycActivityBaseInfoModel);
        changeInfo.setBeforeCreateTime(modelByNew.getCreateTime());
        changeInfo.setBeforeCreateUserId(modelByNew.getCreateUserId());
        changeInfo.setBeforeCreateUserName(modelByNew.getCreateUserName());
        DycActivityDO dycActivityDo = new DycActivityDO();
        dycActivityDo.setObjId(reqBo.getChangeId());
        dycActivityDo.setObjType(2);
        List<DycActivityFileInfo> dycChangeFileInfos = this.dycActFileRepository.queryActivityFileList(dycActivityDo);
        DycActivityDO dycActivityFileDo = new DycActivityDO();
        dycActivityFileDo.setObjId(reqBo.getChangeId());
        dycActivityFileDo.setObjType(4);
        List<DycActivityFileInfo> dycChangeActivityFileInfos = this.dycActFileRepository.queryActivityFileList(dycActivityFileDo);
        DycActivityChangeSupplierInfo dycActivityChangeSupplierInfo = new DycActivityChangeSupplierInfo();
        dycActivityChangeSupplierInfo.setChangeId(reqBo.getChangeId());
        List<DycActivityChangeSupplierInfo> listNew = this.dycActActivityChangeSupplierRepository.getListNew(dycActivityChangeSupplierInfo);
        List dycActivityChangeSupplierInfoBoList = JSONObject.parseArray((String)JSONObject.toJSONString(listNew), DycActivityChangeSupplierInfoBO.class);
        DycProcessDO dycProcessDO = new DycProcessDO();
        dycProcessDO.setObjId(reqBo.getChangeId());
        DycActivityFlowInstanceInfo instanceInfo = this.dycActivityFlowInstanceRepository.queryActivityFlowInstanceSingle(dycProcessDO);
        if (!ObjectUtils.isEmpty((Object)instanceInfo)) {
            rspBo.setFlowInstId(instanceInfo.getFlowInstId());
        }
        rspBo.setDycSaasActivityChangeSupplierInfoBoList(dycActivityChangeSupplierInfoBoList);
        rspBo.setChangeBaseDetail(changeInfo);
        rspBo.setChangeFileList(dycChangeFileInfos);
        rspBo.setChangeActivityFileList(dycChangeActivityFileInfos);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private String getNo(String actNo) {
        CfcEncodedSerialGetServiceReqBO cfcEncodedSerialGetServiceReqBo = new CfcEncodedSerialGetServiceReqBO();
        ArrayList<String> replaceValue = new ArrayList<String>();
        replaceValue.add(actNo);
        cfcEncodedSerialGetServiceReqBo.setCenter("ACT");
        cfcEncodedSerialGetServiceReqBo.setOrgType("1");
        cfcEncodedSerialGetServiceReqBo.setEncodedRuleCode("ACT_ACTIVITY_CHANGE_CODE");
        cfcEncodedSerialGetServiceReqBo.setNum(Integer.valueOf(1));
        cfcEncodedSerialGetServiceReqBo.setReplaceValue(replaceValue);
        CfcEncodedSerialGetServiceRspBO cfcEncodedSerialServiceRspBo = this.cfcEncodedSerialGetService.getEncodedSerial(cfcEncodedSerialGetServiceReqBo);
        return (String)cfcEncodedSerialServiceRspBo.getSerialNoList().get(0);
    }

    @Override
    public BasePageRspBo<DycActivityChangeSupplierInfo> queryActivityChangeSelectedSupplierPageList(DycActivityChangeDO reqBO) {
        return this.dycActActivityChangeSupplierRepository.queryActivityChangeSelectedSupplierPageList(reqBO);
    }

    @Override
    public int batchSelectActivityChangeSupplier(DycActivityChangeDO reqBO) {
        return this.dycActActivityChangeSupplierRepository.batchSelectActivityChangeSupplier(reqBO);
    }

    @Override
    public int batchRemoveActivityChangeSupplier(DycActivityChangeDO reqBO) {
        return this.dycActActivityChangeSupplierRepository.batchRemoveActivityChangeSupplier(reqBO);
    }

    @Override
    public BasePageRspBo<DycActivityChangeRelaCommodityPoolInfo> queryActivityChangeCommodityPoolPageList(DycActivityChangeDO reqBO) {
        return this.dycActActivityChangeCommodityRepository.queryActivityChangeCommodityPoolPageList(reqBO);
    }

    @Override
    public DycActivityChangeRelaCommodityPoolInfo batchSelectActivityChangeCommodityPool(DycActivityChangeDO reqBO) {
        return this.dycActActivityChangeCommodityRepository.batchSelectActivityChangeCommodityPool(reqBO);
    }

    @Override
    public DycActivityChangeRelaCommodityPoolInfo batchRemoveActivityChangeCommodityPool(DycActivityChangeDO reqBO) {
        return this.dycActActivityChangeCommodityRepository.batchRemoveActivityChangeCommodityPool(reqBO);
    }

    @Override
    public DycActivityChangeInfo changeActivity(DycActivityChangeDO reqBo) {
        Map<String, List<DycActivityChangeInfo>> map;
        DycActivityChangeInfo rspBO = new DycActivityChangeInfo();
        List<DycActivityChangeInfo> list = this.getDycActivityChangeInfos(reqBo);
        if (!CollectionUtils.isEmpty(list) && (map = list.stream().collect(Collectors.groupingBy(DycActivityChangeInfo::getChangeState))).containsKey("1")) {
            throw new ZTBusinessException("\u8be5\u6d3b\u52a8\u5b58\u5728\u5ba1\u6279\u4e2d\u7684\u53d8\u66f4\u5355");
        }
        String code = this.getNo(reqBo.getActivityCode());
        DycActivityBaseInfo activityBaseInfo = this.getDycActivityBaseInfos(reqBo);
        Long changeId = this.setDycActivityChangeInfo(activityBaseInfo, code);
        this.extractedSupplier(changeId, reqBo);
        this.setItem(reqBo, activityBaseInfo, changeId);
        this.extractedUser(reqBo, changeId);
        this.extractedFile(changeId, reqBo);
        rspBO.setChangeId(changeId);
        return rspBO;
    }

    private int doHttp(DycActivityChangeDO reqBo) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("activityId", (Object)reqBo.getActivityId());
        String result = HttpUtil.post((String)this.DEAL_ACTIVITY, (String)JSONObject.toJSONString((Object)jsonObject));
        JSONObject resultObj = JSONObject.parseObject((String)result);
        log.debug("http\u8c03\u7528\u79ef\u5206\u83b7\u53d6\u670d\u52a1\u83b7\u53d6\u6700\u65b0\u6570\u636e\u51fa\u53c2\uff1a{}", (Object)resultObj);
        if (!"0000".equals(resultObj.get((Object)"respCode"))) {
            return 1;
        }
        return 0;
    }

    private DycActivityBaseInfo getDycActivityDo(DycActivityChangeDO reqBo) {
        DycActivityBaseInfo dycActivityDo = new DycActivityBaseInfo();
        dycActivityDo.setActivityId(reqBo.getActivityId());
        dycActivityDo.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        DycActivityBaseInfo dycActivityBaseInfo = this.dycActActivityRepository.getModelByNew(dycActivityDo);
        if (dycActivityBaseInfo == null) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u539f\u59cb\u6d3b\u52a8\u5355\u636e\uff01");
        }
        return dycActivityDo;
    }

    private void updateState(DycActivityBaseInfo dycActivityDo, Long changeId) {
        DycActivityChangeDO activityChangeDo = new DycActivityChangeDO();
        activityChangeDo.setChangeId(changeId);
        activityChangeDo.setOriginalActivityState(dycActivityDo.getActivityState());
        this.dycActActivityChangeRepository.updateByCondition(activityChangeDo);
    }

    private void setItem(DycActivityChangeDO reqBo, DycActivityBaseInfo activityBaseInfo, Long changeId) {
        switch (String.valueOf(activityBaseInfo.getCommodityRelaMethod())) {
            case "1": {
                this.extractedCommodityPool(reqBo, changeId);
                break;
            }
            case "2": {
                this.extractedCatalog(reqBo, changeId);
                break;
            }
            case "3": {
                this.extractedCommodity(reqBo, changeId);
                break;
            }
        }
    }

    private Long setDycActivityChangeInfo(DycActivityBaseInfo activityBaseInfo, String code) {
        Long changeId = Sequence.getInstance().nextId();
        DycActivityChangeInfo activityChangeDo = (DycActivityChangeInfo)JSON.parseObject((String)JSON.toJSONString((Object)activityBaseInfo), DycActivityChangeInfo.class);
        activityChangeDo.setOriginalActivityId(activityBaseInfo.getActivityId());
        activityChangeDo.setOriginalActivityCode(activityBaseInfo.getActivityCode());
        activityChangeDo.setOriginalActivityVersion(activityBaseInfo.getActivityVersion());
        activityChangeDo.setNewActivityVersion(activityBaseInfo.getActivityVersion() + 1);
        activityChangeDo.setNewActivityCode(activityBaseInfo.getActivityCode());
        activityChangeDo.setOriginalActivityState(activityBaseInfo.getActivityState());
        activityChangeDo.setUpdateTime(null);
        activityChangeDo.setUpdateUserId(null);
        activityChangeDo.setUpdateUserName("");
        activityChangeDo.setChangeId(changeId);
        activityChangeDo.setChangeCode(code);
        activityChangeDo.setChangeState(String.valueOf(0));
        activityChangeDo.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        this.dycActActivityChangeRepository.insertNew(activityChangeDo);
        return changeId;
    }

    private DycActivityBaseInfo getDycActivityBaseInfos(DycActivityChangeDO reqBO) {
        DycActivityBaseInfo activityDo = new DycActivityBaseInfo();
        activityDo.setActivityId(reqBO.getActivityId());
        activityDo.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        DycActivityBaseInfo activityBaseInfos = this.dycActActivityRepository.getModelByNew(activityDo);
        if (activityBaseInfos == null) {
            throw new ZTBusinessException("\u67e5\u8be2\u539f\u59cb\u6d3b\u52a8\u5355\u636e\u4e3a\u7a7a\uff01");
        }
        return activityBaseInfos;
    }

    private List<DycActivityChangeInfo> getDycActivityChangeInfos(DycActivityChangeDO reqBO) {
        DycActivityChangeInfo dycActivityChangeInfo = new DycActivityChangeInfo();
        dycActivityChangeInfo.setOriginalActivityId(reqBO.getActivityId());
        dycActivityChangeInfo.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        return this.dycActActivityChangeRepository.getListNew(dycActivityChangeInfo);
    }

    public void extractedFile(Long changeId, DycActivityChangeDO reqBo) {
        DycActivityDO dycActivityDo = new DycActivityDO();
        dycActivityDo.setObjId(reqBo.getActivityId());
        List<DycActivityFileInfo> fileInfos = this.dycActFileRepository.queryActivityFileList(dycActivityDo);
        if (!CollectionUtils.isEmpty(fileInfos)) {
            List<DycActivityFileInfo> collect = fileInfos.stream().map(item -> {
                DycActivityFileInfo fileInfo = new DycActivityFileInfo();
                BeanUtils.copyProperties((Object)item, (Object)fileInfo);
                fileInfo.setObjId(changeId);
                fileInfo.setObjType(4);
                fileInfo.setDelFlag(0);
                return fileInfo;
            }).collect(Collectors.toList());
            this.dycActFileRepository.addListActivityFileInfo(collect);
        }
    }

    public void extractedSupplier(Long changeId, DycActivityChangeDO reqBo) {
        DycActivitySupplierInfo activityDo = new DycActivitySupplierInfo();
        activityDo.setActivityId(reqBo.getActivityId());
        List<DycActivitySupplierInfo> supplierInfos = this.dycActActivitySupplierRepository.getListNew(activityDo);
        if (!CollectionUtils.isEmpty(supplierInfos)) {
            List dycActivityChangeSupplierInfos = JSONObject.parseArray((String)JSONObject.toJSONString(supplierInfos), DycActivityChangeSupplierInfo.class);
            dycActivityChangeSupplierInfos.forEach(o -> {
                o.setChangeId(changeId);
                o.setId(Sequence.getInstance().nextId());
            });
            this.dycActActivityChangeSupplierRepository.insertBatchNew(dycActivityChangeSupplierInfos);
        }
    }

    public void extractedUser(DycActivityChangeDO reqBo, Long changeId) {
        DycActivityChangeUserInfo info = new DycActivityChangeUserInfo();
        info.setCreateUserId(reqBo.getUserId());
        info.setCreateUserName(reqBo.getName());
        info.setChangeId(changeId);
        this.dycActActivityChangeUserRepository.insertBatchSelect(info, reqBo.getActivityId());
    }

    public void extractedCatalog(DycActivityChangeDO reqBo, Long changeId) {
        DycActiveCommodityCatalogInfo commodityCatalogInfo = new DycActiveCommodityCatalogInfo();
        commodityCatalogInfo.setActivityId(reqBo.getActivityId());
        commodityCatalogInfo.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        List<DycActiveCommodityCatalogInfo> catalogInfoList = this.dycActActivityCommodityCatalogRepository.getListNew(commodityCatalogInfo);
        if (!CollectionUtils.isEmpty(catalogInfoList)) {
            List dycActivityChangeRelaCommodityInfos = JSONObject.parseArray((String)JSONObject.toJSONString(catalogInfoList), DycActivityChangeRelaCommodityCatalogInfo.class);
            dycActivityChangeRelaCommodityInfos.forEach(o -> {
                o.setCreateUserId(reqBo.getUserId());
                o.setCreateUserName(reqBo.getName());
                o.setCreateTime(new Date());
                o.setRelaId(Sequence.getInstance().nextId());
                o.setChangeId(changeId);
                o.setUpdateTime(null);
                o.setUpdateUserId(null);
                o.setUpdateUserName(null);
            });
            this.dycActActivityChangeCommodityCatalogRepository.insertBatchNew(dycActivityChangeRelaCommodityInfos);
        }
    }

    public void extractedCommodity(DycActivityChangeDO reqBo, Long changeId) {
        DycActivityChangeRelaCommodityInfo info = new DycActivityChangeRelaCommodityInfo();
        info.setCreateUserId(reqBo.getUserId());
        info.setCreateUserName(reqBo.getName());
        info.setChangeId(changeId);
        this.dycActActivityChangeCommodityRepository.insertBatchSelect(info, reqBo.getActivityId());
    }

    public void extractedCommodityPool(DycActivityChangeDO reqBo, Long changeId) {
        DycQueryActivityCommodityPoolPageListReqBO listReqBo = new DycQueryActivityCommodityPoolPageListReqBO();
        listReqBo.setActivityId(reqBo.getActivityId());
        List<DycActivityCommodityPoolInfo> commodityPoolInfos = this.dycActActivityCommodityRepository.queryActivityCommodityPoolList(listReqBo);
        if (!CollectionUtils.isEmpty(commodityPoolInfos)) {
            DycActivityChangeDO changeDo = new DycActivityChangeDO();
            changeDo.setChangeId(changeId);
            changeDo.setCreateUserId(reqBo.getCreateUserId());
            changeDo.setCreateUserName(reqBo.getCreateUserName());
            List<DycActivityChangeRelaCommodityPoolInfo> collect = commodityPoolInfos.stream().map(item -> {
                DycActivityChangeRelaCommodityPoolInfo relaCommodityPoolInfo = new DycActivityChangeRelaCommodityPoolInfo();
                relaCommodityPoolInfo.setCommodityPoolId(item.getCommodityPoolId());
                relaCommodityPoolInfo.setCommodityPoolName(item.getCommodityPoolName());
                relaCommodityPoolInfo.setApplyActivityType(item.getApplyActivityType());
                relaCommodityPoolInfo.setRelaCommodityAmount(item.getRelaCommodityAmount());
                relaCommodityPoolInfo.setRelaCatalogAmount(item.getRelaCatalogAmount());
                return relaCommodityPoolInfo;
            }).collect(Collectors.toList());
            changeDo.setCommodityPoolList(collect);
            this.dycActActivityChangeCommodityRepository.batchSelectActivityChangeCommodityPool(changeDo);
        }
    }

    @Override
    public BasePageRspBo<DycActivityChangeRelaCommodityCatalogInfo> queryActivityChangeSelectedCommodityCatalogPageList(DycActivityChangeDO reqBO) {
        return this.dycActActivityChangeCommodityRepository.queryActivityChangeSelectedCommodityCatalogPageList(reqBO);
    }

    @Override
    public int batchSelectActivityChangeCommodityCatalog(DycActivityChangeDO reqBO) {
        int rspBO = this.dycActActivityChangeCommodityRepository.batchSelectActivityChangeCommodityCatalog(reqBO);
        if (!CollectionUtils.isEmpty(reqBO.getCommodityList())) {
            this.dycActActivityChangeCommodityCatalogInComRepository.batchSelectActivityChangeCommodity(reqBO);
        }
        return rspBO;
    }

    @Override
    public int batchRemoveActivityChangeCommodityCatalog(DycActivityChangeDO reqBO) {
        int i = this.dycActActivityChangeCommodityRepository.batchRemoveActivityChangeCommodityCatalog(reqBO);
        if (!CollectionUtils.isEmpty(reqBO.getThreeCatalogIds())) {
            DycActivityChangeRelaCommodityInfo commodityInfo = new DycActivityChangeRelaCommodityInfo();
            commodityInfo.setChangeId(reqBO.getChangeId());
            commodityInfo.setThreeCatalogIds(reqBO.getThreeCatalogIds());
            this.dycActActivityChangeCommodityCatalogInComRepository.updateByThreeCatalogIds(commodityInfo);
        }
        return i;
    }

    @Override
    public BasePageRspBo<ActivityChangeRelaCommodityInfo> queryActivityChangeCommodityPageList(ActActivityChangeCommodityInfoQryDO qryDO) {
        return this.dycActActivityChangeCommodityRepository.queryActivityChangeCommodityPageList(qryDO);
    }

    @Override
    public BasePageRspBo<ActivityChangeRelaCommodityInfo> queryActivityChangeCommodityCatalogInComPageList(ActActivityChangeCommodityInfoQryDO qryDO) {
        return this.dycActActivityChangeCommodityCatalogInComRepository.queryActivityChangeCommodityPageList(qryDO);
    }

    @Override
    public List<ActivityChangeRelaCommodityInfo> queryActivityChangeCommodityList(ActActivityChangeCommodityInfoQryDO qryDO) {
        return this.dycActActivityChangeCommodityRepository.getList((ActivityChangeRelaCommodityInfo)ActRu.js((Object)((Object)qryDO), ActivityChangeRelaCommodityInfo.class));
    }

    @Override
    public void batchSelectActivityChangeUser(DycActivityChangeDO reqBo) {
        if (ObjectUtils.isEmpty((Object)((Object)reqBo))) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBo.getChangeId()) {
            throw new ZTBusinessException("\u53d8\u66f4\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty(reqBo.getUserList())) {
            throw new ZTBusinessException("\u5165\u53c2\u7528\u6237\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.dycActActivityChangeUserRepository.batchSelectActivityChangeUser(reqBo);
        List<String> collect = reqBo.getUserList().stream().map(DycActivityChangeUserInfo::getActUserName).collect(Collectors.toList());
        this.updateChange(collect, ActConstants.ChangeType.ADD, reqBo.getChangeId());
    }

    @Override
    public void batchRemoveActivityChangeUser(DycActivityChangeDO reqBo) {
        if (ObjectUtils.isEmpty((Object)((Object)reqBo))) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBo.getChangeId()) {
            throw new ZTBusinessException("\u53d8\u66f4\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty(reqBo.getUserIdList())) {
            throw new ZTBusinessException("\u7528\u6237\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.dycActActivityChangeUserRepository.batchRemoveActivityChangeUser(reqBo);
        List<String> collect = this.getUserName(reqBo.getUserIdList(), reqBo.getChangeId());
        this.updateChange(collect, ActConstants.ChangeType.DEL, reqBo.getChangeId());
    }

    private List<String> getUserName(List<Long> userIdList, Long changeId) {
        DycActivityChangeDO dycActivityChangeDo = new DycActivityChangeDO();
        dycActivityChangeDo.setUserIdList(userIdList);
        dycActivityChangeDo.setChangeId(changeId);
        List<ActivityChangeUserInfo> activityChangeUserInfos = this.dycActActivityChangeUserRepository.queryChangeActivityUserListAll(dycActivityChangeDo);
        return activityChangeUserInfos.stream().map(ActivityChangeUserInfo::getUserName).collect(Collectors.toList());
    }

    private void updateChange(List<String> userNameList, Integer changeType, Long changeId) {
        DycActivityChangeDO dycActivityChangeDo = new DycActivityChangeDO();
        dycActivityChangeDo.setUserNameList(userNameList);
        dycActivityChangeDo.setChangeId(changeId);
        List<ActivityChangeUserInfo> activityChangeUserInfos = this.dycActActivityChangeUserRepository.queryChangeActivityUserListAll(dycActivityChangeDo);
        List<Long> collectUserIdList = activityChangeUserInfos.stream().map(ActivityChangeUserInfo::getUserId).collect(Collectors.toList());
        ActActivityChangeUserScoresChangeDO actActivityChangeUserScoresChangeDo = new ActActivityChangeUserScoresChangeDO();
        actActivityChangeUserScoresChangeDo.setUserIdList(collectUserIdList);
        actActivityChangeUserScoresChangeDo.setChangeId(changeId);
        List<ActActivityChangeUserScoresChangeDO> list = this.actActivityChangeUserScoresChangeRepository.getList(actActivityChangeUserScoresChangeDo);
        ArrayList<ActActivityChangeUserScoresChangeDO> actActivityChangeUserScoresChangeDoInsert = new ArrayList<ActActivityChangeUserScoresChangeDO>();
        if (CollectionUtils.isEmpty(list)) {
            activityChangeUserInfos.forEach(o -> {
                ActActivityChangeUserScoresChangeDO actActivityChangeUserScoresChangeDoInsertModel = new ActActivityChangeUserScoresChangeDO();
                actActivityChangeUserScoresChangeDoInsertModel.setId(Sequence.getInstance().nextId());
                actActivityChangeUserScoresChangeDoInsertModel.setUserId(o.getUserId());
                actActivityChangeUserScoresChangeDoInsertModel.setChangeId(o.getChangeId());
                actActivityChangeUserScoresChangeDoInsertModel.setChangeType(changeType);
                if (ActConstants.DelFlag.DEL.equals(o.getDelFlag())) {
                    actActivityChangeUserScoresChangeDoInsertModel.setAfterChangeScores(BigDecimal.ZERO);
                } else {
                    actActivityChangeUserScoresChangeDoInsertModel.setAfterChangeScores(o.getGiveScores());
                }
                actActivityChangeUserScoresChangeDoInsertModel.setOriginalScores(o.getOriginalScores());
                actActivityChangeUserScoresChangeDoInsert.add(actActivityChangeUserScoresChangeDoInsertModel);
            });
        } else {
            Map<Long, ActActivityChangeUserScoresChangeDO> collect = list.stream().collect(Collectors.toMap(ActActivityChangeUserScoresChangeDO::getUserId, o -> o));
            activityChangeUserInfos.forEach(o -> {
                if (collect.get(o.getUserId()) != null) {
                    ActActivityChangeUserScoresChangeDO actActivityChangeUserScoresChangeDoUpdateModelWhere = new ActActivityChangeUserScoresChangeDO();
                    actActivityChangeUserScoresChangeDoUpdateModelWhere.setId(((ActActivityChangeUserScoresChangeDO)collect.get(o.getUserId())).getId());
                    ActActivityChangeUserScoresChangeDO actActivityChangeUserScoresChangeDoUpdateModelSet = new ActActivityChangeUserScoresChangeDO();
                    if (ActConstants.DelFlag.DEL.equals(o.getDelFlag())) {
                        actActivityChangeUserScoresChangeDoUpdateModelSet.setAfterChangeScores(BigDecimal.ZERO);
                    } else {
                        actActivityChangeUserScoresChangeDoUpdateModelSet.setAfterChangeScores(o.getGiveScores());
                    }
                    actActivityChangeUserScoresChangeDoUpdateModelSet.setChangeType(changeType);
                    this.actActivityChangeUserScoresChangeRepository.updateBy(actActivityChangeUserScoresChangeDoUpdateModelSet, actActivityChangeUserScoresChangeDoUpdateModelWhere);
                } else {
                    ActActivityChangeUserScoresChangeDO actActivityChangeUserScoresChangeDoInsertModel = new ActActivityChangeUserScoresChangeDO();
                    actActivityChangeUserScoresChangeDoInsertModel.setId(Sequence.getInstance().nextId());
                    actActivityChangeUserScoresChangeDoInsertModel.setUserId(o.getUserId());
                    actActivityChangeUserScoresChangeDoInsertModel.setChangeId(o.getChangeId());
                    actActivityChangeUserScoresChangeDoInsertModel.setChangeType(changeType);
                    if (ActConstants.DelFlag.DEL.equals(o.getDelFlag())) {
                        actActivityChangeUserScoresChangeDoInsertModel.setAfterChangeScores(BigDecimal.ZERO);
                    } else {
                        actActivityChangeUserScoresChangeDoInsertModel.setAfterChangeScores(o.getGiveScores());
                    }
                    actActivityChangeUserScoresChangeDoInsertModel.setOriginalScores(o.getOriginalScores());
                    actActivityChangeUserScoresChangeDoInsert.add(actActivityChangeUserScoresChangeDoInsertModel);
                }
            });
        }
        if (!CollectionUtils.isEmpty(actActivityChangeUserScoresChangeDoInsert)) {
            this.actActivityChangeUserScoresChangeRepository.insertBatch(actActivityChangeUserScoresChangeDoInsert);
        }
    }

    @Override
    public int batchSelectActivityChangeCommodity(DycActivityChangeDO reqBO) {
        return this.dycActActivityChangeCommodityRepository.batchSelectActivityChangeCommodity(reqBO);
    }

    @Override
    public int batchRemoveActivityChangeCommodity(DycActivityChangeDO reqBO) {
        return this.dycActActivityChangeCommodityRepository.batchRemoveActivityChangeCommodity(reqBO);
    }

    private DycActivityChangeUserInfo getChangeUserInfo(ActivityChangeUserInfo changeUserInfo) {
        DycActivityChangeUserInfo dycActivityChangeUserInfo = (DycActivityChangeUserInfo)ActRu.js((Object)changeUserInfo, DycActivityChangeUserInfo.class);
        dycActivityChangeUserInfo.setActUserId(changeUserInfo.getUserId());
        dycActivityChangeUserInfo.setActUserName(changeUserInfo.getUserName());
        dycActivityChangeUserInfo.setActUserOrgId(changeUserInfo.getUserOrgId());
        dycActivityChangeUserInfo.setActUserCompanyId(changeUserInfo.getUserCompanyId());
        dycActivityChangeUserInfo.setActUserCompanyName(changeUserInfo.getUserCompanyName());
        dycActivityChangeUserInfo.setActName(changeUserInfo.getName());
        dycActivityChangeUserInfo.setActUserOrgName(changeUserInfo.getUserOrgName());
        dycActivityChangeUserInfo.setActWorkNo(changeUserInfo.getWorkNo());
        dycActivityChangeUserInfo.setActUserOrgPath(changeUserInfo.getUserOrgPath());
        dycActivityChangeUserInfo.setBalanceScores(changeUserInfo.getGiveScores());
        return dycActivityChangeUserInfo;
    }

    @Override
    public DycActImportActivityChangeUserModelRspBO importActivityChangeUser(DycActImportActivityChangeUserModelReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBO.getUserInfoList())) {
            throw new ZTBusinessException("\u6ca1\u6709\u9700\u8981\u589e\u52a0\u7684\u7528\u6237");
        }
        Long changeId = reqBO.getChangeId();
        Long userId = reqBO.getUserId();
        String name = reqBO.getName();
        if (changeId == null || userId == null || !org.springframework.util.StringUtils.hasText((String)name)) {
            throw new ZTBusinessException("\u5165\u53c2\u4e3a\u7a7a");
        }
        DycActivityChangeInfo dycActivityChangeInfo = new DycActivityChangeInfo();
        dycActivityChangeInfo.setChangeId(changeId);
        dycActivityChangeInfo.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        DycActivityChangeInfo modelByNew = this.dycActActivityChangeRepository.getModelByNew(dycActivityChangeInfo);
        if (modelByNew == null || modelByNew.getChangeId() == null) {
            throw new ZTBusinessException("\u8be5\u53d8\u66f4\u4e0d\u5b58\u5728");
        }
        DycActImportActivityChangeUserModelRspBO rsp = new DycActImportActivityChangeUserModelRspBO();
        ArrayList<DycActImportActivityInfoBO> failReasonList = new ArrayList<DycActImportActivityInfoBO>(reqBO.getUserInfoList().size());
        List<String> userNameList = reqBO.getUserInfoList().stream().map(ActivityChangeUserInfo::getUserName).collect(Collectors.toList());
        DycActivityChangeUserInfo dycActivityChangeDO = new DycActivityChangeUserInfo();
        dycActivityChangeDO.setChangeId(changeId);
        dycActivityChangeDO.setUserNameList(userNameList);
        List<DycActivityChangeUserInfo> dycActivityChangeUserInfos = this.dycActActivityChangeUserRepository.getListNew(dycActivityChangeDO);
        ArrayList<DycActivityChangeUserInfo> addList = new ArrayList<DycActivityChangeUserInfo>();
        int userNum = 0;
        if (modelByNew.getTotalUser() != null) {
            userNum = modelByNew.getTotalUser();
        }
        BigDecimal totalScores = BigDecimal.ZERO;
        if (modelByNew.getTotalScores() != null) {
            totalScores = modelByNew.getTotalScores();
        }
        if (!CollectionUtils.isEmpty(dycActivityChangeUserInfos)) {
            Map<String, DycActivityChangeUserInfo> changeUserInfoMap = dycActivityChangeUserInfos.stream().collect(Collectors.toMap(DycActivityChangeUserInfo::getUserName, v -> v));
            for (ActivityChangeUserInfo changeUserInfo : reqBO.getUserInfoList()) {
                DycActivityChangeUserInfo dycActivityChangeUserInfo;
                if (changeUserInfoMap.containsKey(changeUserInfo.getUserName())) {
                    dycActivityChangeUserInfo = this.getChangeUserInfo(changeUserInfo);
                    DycActivityChangeUserInfo changeUser = (DycActivityChangeUserInfo)changeUserInfoMap.get(changeUserInfo.getUserName());
                    if (ActConstants.DelFlag.NOT_DEL.equals(changeUser.getDelFlag())) {
                        DycActImportActivityInfoBO dycActImportActivityInfoBO = new DycActImportActivityInfoBO();
                        dycActImportActivityInfoBO.setFailReason("\u7b2c" + changeUserInfo.getGluttonLineNum() + "\u884c\u7528\u6237\u5df2\u5b58\u5728");
                        dycActImportActivityInfoBO.setLineNum(changeUserInfo.getGluttonLineNum());
                        failReasonList.add(dycActImportActivityInfoBO);
                        continue;
                    }
                    addList.add(dycActivityChangeUserInfo);
                    ++userNum;
                    totalScores = totalScores.add(changeUser.getGiveScores());
                    continue;
                }
                dycActivityChangeUserInfo = this.getChangeUserInfo(changeUserInfo);
                addList.add(dycActivityChangeUserInfo);
                ++userNum;
                totalScores = totalScores.add(changeUserInfo.getGiveScores());
            }
        } else {
            for (ActivityChangeUserInfo changeUserInfo : reqBO.getUserInfoList()) {
                DycActivityChangeUserInfo dycActivityChangeUserInfo = this.getChangeUserInfo(changeUserInfo);
                addList.add(dycActivityChangeUserInfo);
                ++userNum;
                totalScores = totalScores.add(changeUserInfo.getGiveScores());
            }
        }
        if (!CollectionUtils.isEmpty(addList)) {
            DycActivityChangeDO add = new DycActivityChangeDO();
            add.setChangeId(reqBO.getChangeId());
            add.setUserList(addList);
            add.setCreateUserId(reqBO.getUserId());
            add.setCreateUserName(reqBO.getName());
            this.dycActActivityChangeUserRepository.batchSelectActivityChangeUser(add);
            List<String> collect = addList.stream().map(DycActivityChangeUserInfo::getUserName).collect(Collectors.toList());
            this.updateChange(collect, ActConstants.ChangeType.ADD, reqBO.getChangeId());
        }
        DycActivityChangeInfo set = new DycActivityChangeInfo();
        set.setUpdateTime(new Date());
        set.setUpdateUserId(userId);
        set.setUpdateUserName(name);
        ActivityChangeUserInfoQryBO qryBO = new ActivityChangeUserInfoQryBO();
        qryBO.setChangeId(reqBO.getChangeId());
        userNum = this.dycActActivityChangeUserRepository.count(qryBO);
        totalScores = this.dycActActivityChangeUserRepository.sumScores(qryBO);
        set.setTotalScores(totalScores);
        set.setTotalUser(userNum);
        DycActivityChangeInfo where = new DycActivityChangeInfo();
        where.setChangeId(changeId);
        this.dycActActivityChangeRepository.updateByNew(set, where);
        rsp.setFailReasonList(failReasonList);
        return rsp;
    }

    @Override
    public DycActImportActivityChangeCommodityModelRspBO importActivityChangeCommodity(DycActImportActivityChangeCommodityModelReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBO.getCommodityItem())) {
            throw new ZTBusinessException("\u6ca1\u6709\u9700\u8981\u589e\u52a0\u7684\u5546\u54c1");
        }
        Long changeId = reqBO.getChangeId();
        Long userId = reqBO.getUserId();
        String name = reqBO.getName();
        if (changeId == null || userId == null || !org.springframework.util.StringUtils.hasText((String)name)) {
            throw new ZTBusinessException("\u5165\u53c2\u4e3a\u7a7a");
        }
        DycActivityChangeInfo dycActivityChangeInfo = new DycActivityChangeInfo();
        dycActivityChangeInfo.setChangeId(changeId);
        dycActivityChangeInfo.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        DycActivityChangeInfo modelByNew = this.dycActActivityChangeRepository.getModelByNew(dycActivityChangeInfo);
        if (modelByNew == null || modelByNew.getChangeId() == null) {
            throw new ZTBusinessException("\u8be5\u53d8\u66f4\u4e0d\u5b58\u5728");
        }
        reqBO.setCommodityItem(reqBO.getCommodityItem().stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ActivityImportChangeCommodityInfo>(Comparator.comparing(ActivityImportChangeCommodityInfo::getSkuCode))), ArrayList::new)));
        ArrayList<DycActImportActivityInfoModelBO> failList = new ArrayList<DycActImportActivityInfoModelBO>();
        DycActImportActivityChangeCommodityModelRspBO rspBO = new DycActImportActivityChangeCommodityModelRspBO();
        DycActImportActivityCommodityModelBO dycActImportActivityCommodityModelBO = new DycActImportActivityCommodityModelBO();
        List<String> extSkuIds = reqBO.getCommodityItem().stream().map(ActivityImportChangeCommodityInfo::getSkuCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(extSkuIds)) {
            for (ActivityImportChangeCommodityInfo info : reqBO.getCommodityItem()) {
                failList.add(this.setFailImport("\u5546\u54c1\u7f16\u7801\u5fc5\u586b", info.getGluttonLineNum()));
            }
            rspBO.setFailReasonList(failList);
            return rspBO;
        }
        ActivityChangeRelaCommodityInfo info = new ActivityChangeRelaCommodityInfo();
        info.setChangeId(changeId);
        info.setSkuCodeList(extSkuIds);
        List<ActivityChangeRelaCommodityInfo> list = this.dycActActivityChangeCommodityRepository.getList(info);
        Map<Object, Object> collect = new HashMap();
        if (!CollectionUtils.isEmpty(list)) {
            collect = list.stream().collect(Collectors.toMap(ActivityChangeRelaCommodityInfo::getSkuCode, o -> o, (k1, k2) -> k1));
        }
        Map<String, ActSkuInfoBO> infoBOMap = this.dycActSkuInfoRepository.queryActSkuInfoByCodeList(new ArrayList<String>(extSkuIds));
        ArrayList<DycActivityChangeRelaCommodityInfo> addList = new ArrayList<DycActivityChangeRelaCommodityInfo>();
        ArrayList<Long> delIdList = new ArrayList<Long>();
        for (ActivityImportChangeCommodityInfo importChangeCommodityInfo : reqBO.getCommodityItem()) {
            if (StringUtils.isBlank((CharSequence)importChangeCommodityInfo.getSkuCode())) {
                failList.add(this.setFailImport("\u5546\u54c1\u7f16\u7801\u5fc5\u586b", importChangeCommodityInfo.getGluttonLineNum()));
                continue;
            }
            ActSkuInfoBO skuInfoBO = infoBOMap.get(importChangeCommodityInfo.getSkuCode());
            if (this.checkSku(failList, importChangeCommodityInfo, skuInfoBO).booleanValue()) continue;
            DycActivityChangeRelaCommodityInfo dycActivityChangeRelaCommodityInfo = this.setCommodityInfo(skuInfoBO, changeId);
            if (!CollectionUtils.isEmpty(collect) && collect.containsKey(importChangeCommodityInfo.getSkuCode())) {
                ActivityChangeRelaCommodityInfo activityChangeRelaCommodityInfo = (ActivityChangeRelaCommodityInfo)collect.get(importChangeCommodityInfo.getSkuCode());
                dycActivityChangeRelaCommodityInfo.setUpdateTime(new Date());
                dycActivityChangeRelaCommodityInfo.setUpdateUserId(userId);
                dycActivityChangeRelaCommodityInfo.setUpdateUserName(name);
                dycActivityChangeRelaCommodityInfo.setCreateUserId(activityChangeRelaCommodityInfo.getCreateUserId());
                dycActivityChangeRelaCommodityInfo.setCreateUserName(activityChangeRelaCommodityInfo.getCreateUserName());
                dycActivityChangeRelaCommodityInfo.setCreateTime(activityChangeRelaCommodityInfo.getCreateTime());
                delIdList.add(activityChangeRelaCommodityInfo.getRelaId());
                addList.add(dycActivityChangeRelaCommodityInfo);
                continue;
            }
            dycActivityChangeRelaCommodityInfo.setCreateUserId(userId);
            dycActivityChangeRelaCommodityInfo.setCreateUserName(name);
            dycActivityChangeRelaCommodityInfo.setCreateTime(new Date());
            addList.add(dycActivityChangeRelaCommodityInfo);
        }
        if (!CollectionUtils.isEmpty(addList)) {
            int totalCommodity = addList.size();
            if (!CollectionUtils.isEmpty(delIdList)) {
                totalCommodity -= delIdList.size();
                ActivityChangeRelaCommodityInfo activityChangeRelaCommodityInfo = new ActivityChangeRelaCommodityInfo();
                activityChangeRelaCommodityInfo.setRelaIdList(delIdList);
                this.dycActActivityChangeCommodityRepository.delete(activityChangeRelaCommodityInfo);
            }
            this.dycActActivityChangeCommodityRepository.insertBatchNew(addList);
            DycActivityChangeInfo set = new DycActivityChangeInfo();
            DycActivityChangeRelaCommodityInfo dycActivityChangeRelaCommodityInfo = new DycActivityChangeRelaCommodityInfo();
            dycActivityChangeRelaCommodityInfo.setChangeId(reqBO.getChangeId());
            totalCommodity = this.dycActActivityChangeCommodityRepository.count(dycActivityChangeRelaCommodityInfo);
            set.setTotalCommodity(totalCommodity);
            set.setUpdateTime(new Date());
            set.setUpdateUserId(userId);
            set.setUpdateUserName(name);
            DycActivityChangeInfo where = new DycActivityChangeInfo();
            where.setChangeId(changeId);
            this.dycActActivityChangeRepository.updateByNew(set, where);
        }
        rspBO.setFailReasonList(failList);
        return rspBO;
    }

    private DycActImportActivityInfoModelBO setFailImport(String string, Long lineNum) {
        DycActImportActivityInfoModelBO dycActImportActivityInfoModelBO = new DycActImportActivityInfoModelBO();
        dycActImportActivityInfoModelBO.setFailReason("\u7b2c" + lineNum + "\u884c" + string);
        dycActImportActivityInfoModelBO.setLineNum(lineNum);
        return dycActImportActivityInfoModelBO;
    }

    private DycActivityChangeRelaCommodityInfo setCommodityInfo(ActSkuInfoBO skuInfoBO, Long changeId) {
        DycActivityChangeRelaCommodityInfo commodityInfo = new DycActivityChangeRelaCommodityInfo();
        commodityInfo.setRelaId(Sequence.getInstance().nextId());
        commodityInfo.setSkuDetails(skuInfoBO.getSkuPcDetailUrl());
        commodityInfo.setSkuId(skuInfoBO.getSkuId());
        commodityInfo.setCommodityPoolName(skuInfoBO.getPoolNames());
        commodityInfo.setSkuCode(skuInfoBO.getExtSkuId());
        commodityInfo.setSkuName(skuInfoBO.getSkuName());
        commodityInfo.setSkuUrl(skuInfoBO.getSkuUrl());
        commodityInfo.setSkuStatus(skuInfoBO.getSkuStatus());
        commodityInfo.setFirstCatalogId(String.valueOf(skuInfoBO.getCatalogId1()));
        commodityInfo.setFirstCatalogName(skuInfoBO.getCatalogName1());
        commodityInfo.setSecondCatalogId(String.valueOf(skuInfoBO.getCatalogId2()));
        commodityInfo.setSecondCatalogName(skuInfoBO.getCatalogName2());
        commodityInfo.setThreeCatalogId(String.valueOf(skuInfoBO.getCatalogId3()));
        commodityInfo.setThreeCatalogName(skuInfoBO.getCatalogName3());
        commodityInfo.setCterminalUrl(skuInfoBO.getJdSkuUrl());
        commodityInfo.setBrand(skuInfoBO.getBrandName());
        commodityInfo.setPrice(skuInfoBO.getAgreementPrice());
        commodityInfo.setChangeId(changeId);
        commodityInfo.setDelFlag(0);
        if (skuInfoBO.getGoodRate() != null) {
            commodityInfo.setFavorableRate(skuInfoBO.getGoodRate().doubleValue());
        }
        return commodityInfo;
    }

    private Boolean checkSku(List<DycActImportActivityInfoModelBO> list, ActivityImportChangeCommodityInfo importChangeCommodityInfo, ActSkuInfoBO skuInfoBO) {
        if (skuInfoBO == null) {
            list.add(this.setFailImport("\u672a\u627e\u5230\u5546\u54c1", importChangeCommodityInfo.getGluttonLineNum()));
            return true;
        }
        if (!DycActivityConstants.SkuStatue.ON_SALE.equals(skuInfoBO.getSkuStatus())) {
            list.add(this.setFailImport("\u5546\u54c1\u72b6\u6001\u4e0d\u4e3a\u5df2\u4e0a\u67b6", importChangeCommodityInfo.getGluttonLineNum()));
            return true;
        }
        if (!DycActivityConstants.CatalogStatus.ENABLE.equals(skuInfoBO.getCatalogId1Status())) {
            list.add(this.setFailImport("\u5546\u54c1\u4e00\u7ea7\u7c7b\u76ee\u5df2\u505c\u7528", importChangeCommodityInfo.getGluttonLineNum()));
            return true;
        }
        if (!DycActivityConstants.CatalogStatus.ENABLE.equals(skuInfoBO.getCatalogId2Status())) {
            list.add(this.setFailImport("\u5546\u54c1\u4e8c\u7ea7\u7c7b\u76ee\u5df2\u505c\u7528", importChangeCommodityInfo.getGluttonLineNum()));
            return true;
        }
        if (!DycActivityConstants.CatalogStatus.ENABLE.equals(skuInfoBO.getCatalogId3Status())) {
            list.add(this.setFailImport("\u5546\u54c1\u4e09\u7ea7\u7ea7\u7c7b\u76ee\u5df2\u505c\u7528", importChangeCommodityInfo.getGluttonLineNum()));
            return true;
        }
        if (DycActivityConstants.IsAnomalousPrice.ABNORMAL.equals(skuInfoBO.getIsAnomalousPrice())) {
            list.add(this.setFailImport("\u5546\u54c1\u4ef7\u683c\u5f02\u5e38", importChangeCommodityInfo.getGluttonLineNum()));
            return true;
        }
        return false;
    }

    @Override
    public void batchModifyActivityChangeUserScores(DycActivityChangeDO dycActivityChangeDO) {
        this.dycActActivityChangeUserRepository.batchModifyActivityChangeUserScores(dycActivityChangeDO);
        List<String> collect = this.getUserName(Collections.singletonList(dycActivityChangeDO.getActUserId()), dycActivityChangeDO.getChangeId());
        this.updateChange(collect, ActConstants.ChangeType.DEL, dycActivityChangeDO.getChangeId());
    }

    @Override
    public void modifyActivityChangeUserScores(DycActivityChangeDO dycActivityChangeDO) {
        this.dycActActivityChangeUserRepository.batchModifyActivityChangeUserScores(dycActivityChangeDO);
        List<String> collect = this.getUserName(Collections.singletonList(dycActivityChangeDO.getActUserId()), dycActivityChangeDO.getChangeId());
        this.updateChange(collect, ActConstants.ChangeType.DEL, dycActivityChangeDO.getChangeId());
    }

    @Override
    public DycActivityChangeInfo changeActivityChangeState(DycActivityChangeDO reqBO) {
        if (ObjectUtils.isEmpty((Object)((Object)reqBO))) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getChangeId()) {
            throw new ZTBusinessException("\u53d8\u66f4\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getChangeState()) {
            throw new ZTBusinessException("\u53d8\u66f4\u5355\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.dycActActivityChangeRepository.changeActivityChangeState(reqBO);
    }

    @Override
    public BasePageRspBo<DycActivityChangeInfo> queryActivityChangePageList(DycActivityChangeDO reqBO) {
        return this.dycActActivityChangeRepository.queryActivityChangePageList(reqBO);
    }

    @Override
    public BasePageRspBo<ActivityChangeUserInfo> queryActivityChangeUserPageList(ActivityChangeUserInfoQryBO reqBo) {
        if (ObjectUtils.isEmpty((Object)((Object)reqBo))) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBo.getChangeId()) {
            throw new ZTBusinessException("\u53d8\u66f4\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBo.getFlag().booleanValue()) {
            DycActivityChangeDO changeDO = new DycActivityChangeDO();
            changeDO.setActivityId(reqBo.getActivityId());
            int i = this.doHttp(changeDO);
            if (i == 1) {
                return null;
            }
            DycActivityChangeUserInfo info = new DycActivityChangeUserInfo();
            info.setChangeId(reqBo.getChangeId());
            this.dycActActivityChangeUserRepository.delete(info);
            DycActivityChangeDO dycActivityChangeDO = new DycActivityChangeDO();
            dycActivityChangeDO.setActivityId(reqBo.getActivityId());
            dycActivityChangeDO.setUserId(reqBo.getUserId());
            dycActivityChangeDO.setName(reqBo.getName());
            this.extractedUser(dycActivityChangeDO, reqBo.getChangeId());
        }
        return this.dycActActivityChangeUserRepository.queryActivityChangeUserPageList(reqBo);
    }

    @Override
    public List<ActivityChangeUserInfo> queryChangeActivityUserList(DycActivityChangeDO reqBo) {
        if (ObjectUtils.isEmpty((Object)((Object)reqBo))) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBo.getChangeId()) {
            throw new ZTBusinessException("\u53d8\u66f4\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.dycActActivityChangeUserRepository.queryChangeActivityUserList(reqBo);
    }

    @Override
    public void batchModifyIntegralZeroClearance(DycActivityChangeDO reqBO) {
        DycActivityChangeUserInfo userInfo = new DycActivityChangeUserInfo();
        userInfo.setChangeId(reqBO.getChangeId());
        userInfo.setUserId(reqBO.getUserIdList().get(0));
        userInfo.setDelFlag(0);
        DycActivityChangeUserInfo modelByNew = this.dycActActivityChangeUserRepository.getModelByNew(userInfo);
        if (!ObjectUtils.isEmpty((Object)modelByNew)) {
            reqBO.setGiveScores(modelByNew.getUsedScores());
        }
        this.dycActActivityChangeUserRepository.batchModifyIntegralZeroClearance(reqBO);
        List<String> userName = this.getUserName(reqBO.getUserIdList(), reqBO.getChangeId());
        this.updateChange(userName, ActConstants.ChangeType.UPDATE, reqBO.getChangeId());
    }

    @Override
    public DycActivityChangeDO qryUserInfoLimitScore(DycActivityChangeDO dycActivityChangeDo) {
        return this.dycActActivityChangeUserRepository.qryUserInfoLimitScore(dycActivityChangeDo);
    }

    @Override
    public DycActSubmitActivityChangeRspDO submitActivityChange(DycActSubmitActivityChangeReqDO reqBo) {
        DycActSubmitActivityChangeRspDO dycActSubmitActivityChangeRspDo = new DycActSubmitActivityChangeRspDO();
        dycActSubmitActivityChangeRspDo.setRespCode("0000");
        dycActSubmitActivityChangeRspDo.setRespDesc("\u6210\u529f");
        Date date = new Date();
        DycActivityChangeInfo dycActivityChangeInfo = this.getDycActivityChangeInfo(reqBo);
        this.updateInfo(reqBo, date, dycActivityChangeInfo);
        this.delFile(reqBo);
        this.updateFile(reqBo);
        this.updateState(dycActivityChangeInfo);
        return dycActSubmitActivityChangeRspDo;
    }

    public int checkUser(DycActSubmitActivityChangeReqDO reqBo) {
        DycActivityChangeUserInfo dycActivityChangeUserInfo = new DycActivityChangeUserInfo();
        dycActivityChangeUserInfo.setChangeId(reqBo.getChangeId());
        return this.dycActActivityChangeUserRepository.getCheckByNewByChangeCheck(dycActivityChangeUserInfo);
    }

    private void delFile(DycActSubmitActivityChangeReqDO reqBo) {
        DycActivityFileInfo dycActivityFileInfoDelete = new DycActivityFileInfo();
        dycActivityFileInfoDelete.setDelFlag(ActConstants.DelFlag.DEL);
        dycActivityFileInfoDelete.setObjId(reqBo.getChangeId());
        this.dycActFileRepository.updateByObjId(dycActivityFileInfoDelete);
    }

    private void updateState(DycActivityChangeInfo dycActivityChangeInfo) {
        DycActivityDO dycActivityDo = new DycActivityDO();
        dycActivityDo.setActivityId(dycActivityChangeInfo.getOriginalActivityId());
        dycActivityDo.setActivityState("8");
        this.dycActActivityRepository.updateActivityState(dycActivityDo);
    }

    private void updateFile(DycActSubmitActivityChangeReqDO reqBo) {
        if (!CollectionUtils.isEmpty(reqBo.getChangeFileList())) {
            ArrayList<DycActivityFileInfo> dycActivityFileInfos = new ArrayList<DycActivityFileInfo>(reqBo.getChangeFileList().size());
            System.out.println(reqBo.getChangeFileList());
            reqBo.getChangeFileList().forEach(o -> {
                DycActivityFileInfo dycActivityFileInfo = new DycActivityFileInfo();
                dycActivityFileInfo.setObjId(reqBo.getChangeId());
                dycActivityFileInfo.setFileId(Sequence.getInstance().nextId());
                dycActivityFileInfo.setFileName(o.getFileName());
                dycActivityFileInfo.setFileType(o.getFileType());
                dycActivityFileInfo.setDelFlag(ActConstants.DelFlag.NOT_DEL);
                dycActivityFileInfo.setObjType(ActConstants.ObjType.ACT_CHANGE);
                dycActivityFileInfo.setFileUrl(o.getFileUrl());
                dycActivityFileInfos.add(dycActivityFileInfo);
            });
            this.dycActFileRepository.addListActivityFileInfo(dycActivityFileInfos);
        }
    }

    private DycActivityChangeInfo getDycActivityChangeInfo(DycActSubmitActivityChangeReqDO reqBo) {
        DycActivityChangeInfo dycActivityChangeDoQry = new DycActivityChangeInfo();
        dycActivityChangeDoQry.setChangeId(reqBo.getChangeId());
        DycActivityChangeInfo dycActivityChangeInfo = this.dycActActivityChangeRepository.getModelByNew(dycActivityChangeDoQry);
        if (dycActivityChangeInfo == null) {
            throw new ZTBusinessException("\u67e5\u8be2\u53d8\u66f4\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        return dycActivityChangeInfo;
    }

    private void updateInfo(DycActSubmitActivityChangeReqDO reqBo, Date date, DycActivityChangeInfo dycActivityChangeInfo) {
        DycActivityChangeInfo dycActivityChangeDo = new DycActivityChangeInfo();
        dycActivityChangeDo.setChangeId(reqBo.getChangeId());
        dycActivityChangeDo.setChangeReason(reqBo.getChangeReason());
        dycActivityChangeDo.setActivityName(reqBo.getActivityName());
        dycActivityChangeDo.setRemark(reqBo.getRemark());
        dycActivityChangeDo.setPcBannerPicUrl(reqBo.getPcBannerPicUrl());
        dycActivityChangeDo.setAppBannerPicUrl(reqBo.getAppBannerPicUrl());
        dycActivityChangeDo.setActivityStartTime(reqBo.getActivityStartTime());
        dycActivityChangeDo.setActivityEndTime(reqBo.getActivityEndTime());
        dycActivityChangeDo.setMaxPrice(reqBo.getMaxPrice());
        dycActivityChangeDo.setMinPrice(reqBo.getMinPrice());
        dycActivityChangeDo.setUpdateUserId(reqBo.getUserId());
        dycActivityChangeDo.setUpdateUserName(reqBo.getName());
        dycActivityChangeDo.setUpdateTime(date);
        dycActivityChangeDo.setCreateTime(date);
        dycActivityChangeDo.setCreateUserId(reqBo.getUserId());
        dycActivityChangeDo.setCreateUserName(reqBo.getName());
        dycActivityChangeDo.setLowPrice(reqBo.getLowPrice());
        this.setUserNum(reqBo, dycActivityChangeDo);
        this.setCommodityItem(dycActivityChangeInfo, dycActivityChangeDo);
        this.setSore(reqBo, dycActivityChangeDo);
        DycActivityChangeInfo dycActivityChangeDoWhere = new DycActivityChangeInfo();
        dycActivityChangeDoWhere.setChangeId(reqBo.getChangeId());
        this.dycActActivityChangeRepository.updateByNew(dycActivityChangeDo, dycActivityChangeDoWhere);
    }

    private void setSore(DycActSubmitActivityChangeReqDO reqBo, DycActivityChangeInfo dycActivityChangeDo) {
        DycActivityChangeUserInfo dycActivityChangeUserInfo = new DycActivityChangeUserInfo();
        dycActivityChangeUserInfo.setChangeId(reqBo.getChangeId());
        dycActivityChangeUserInfo.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        BigDecimal checkByNewUser = this.dycActActivityChangeUserRepository.getCheckByNewSoreCount(dycActivityChangeUserInfo);
        dycActivityChangeDo.setTotalScores(checkByNewUser);
    }

    private void setUserNum(DycActSubmitActivityChangeReqDO reqBo, DycActivityChangeInfo dycActivityChangeDo) {
        DycActivityChangeUserInfo dycActivityChangeUserInfo = new DycActivityChangeUserInfo();
        dycActivityChangeUserInfo.setChangeId(reqBo.getChangeId());
        dycActivityChangeUserInfo.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        int checkByNewUser = this.dycActActivityChangeUserRepository.getCheckByNew(dycActivityChangeUserInfo);
        dycActivityChangeDo.setTotalUser(checkByNewUser);
    }

    private void setCommodityItem(DycActivityChangeInfo dycActivityChangeInfo, DycActivityChangeInfo dycActivityChangeDo) {
        switch (String.valueOf(dycActivityChangeInfo.getCommodityRelaMethod())) {
            case "2": {
                this.dealCatalogNum(dycActivityChangeInfo, dycActivityChangeDo);
                break;
            }
            case "3": {
                this.dealCommodityNum(dycActivityChangeInfo, dycActivityChangeDo);
                break;
            }
        }
    }

    private void dealCommodityNum(DycActivityChangeInfo dycActivityChangeInfo, DycActivityChangeInfo dycActivityChangeDo) {
        DycActivityChangeRelaCommodityInfo dycActivityChangeRelaCommodityInfo = new DycActivityChangeRelaCommodityInfo();
        dycActivityChangeRelaCommodityInfo.setChangeId(dycActivityChangeInfo.getChangeId());
        dycActivityChangeRelaCommodityInfo.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        int checkByNew = this.dycActActivityChangeCommodityRepository.getCheckByNew(dycActivityChangeRelaCommodityInfo);
        dycActivityChangeDo.setTotalCommodity(checkByNew);
        dycActivityChangeDo.setTotalCatalog(0);
    }

    private void dealCatalogNum(DycActivityChangeInfo dycActivityChangeInfo, DycActivityChangeInfo dycActivityChangeDo) {
        DycActivityChangeRelaCommodityCatalogInfo dycActivityChangeRelaCommodityCatalogInfo = new DycActivityChangeRelaCommodityCatalogInfo();
        dycActivityChangeRelaCommodityCatalogInfo.setChangeId(dycActivityChangeInfo.getChangeId());
        dycActivityChangeRelaCommodityCatalogInfo.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        int checkByNew = this.dycActActivityChangeCommodityCatalogRepository.getCheckByNew(dycActivityChangeRelaCommodityCatalogInfo);
        dycActivityChangeDo.setTotalCatalog(checkByNew);
        dycActivityChangeDo.setTotalCommodity(0);
    }

    @Override
    public DycActDealAppApproveActivityRspBo dealAppApprove(DycActDealAppApproveActivityReqBo reqBo) {
        Date date = new Date();
        DycActDealAppApproveActivityRspBo dycActDealAppApproveActivityRspBo = new DycActDealAppApproveActivityRspBo();
        dycActDealAppApproveActivityRspBo.setRespCode("0000");
        dycActDealAppApproveActivityRspBo.setRespDesc("\u6210\u529f");
        if (reqBo.getApproveResult().booleanValue()) {
            String state = "8";
            Long newId = Sequence.getInstance().nextId();
            DycActivityChangeInfo dycActivityChangeInfo = this.getDycActivityChangeInfo(reqBo);
            List<DycActivityChangeUserInfo> activityChangeUserInfoList = this.getDycActivityChangeUserInfos(reqBo);
            List<DycActivityChangeSupplierInfo> activityChangeUserInfoSupList = this.getDycActivityChangeSupplierInfos(reqBo);
            this.setOrgItem(dycActivityChangeInfo, newId, date);
            this.setInfo(date, state, newId, dycActivityChangeInfo);
            this.setUser(date, newId, activityChangeUserInfoList);
            this.setSup(newId, activityChangeUserInfoSupList);
            this.setDel(dycActivityChangeInfo);
            this.setPass(dycActivityChangeInfo);
            this.updateAlertInfo(dycActivityChangeInfo.getOriginalActivityId());
            dycActDealAppApproveActivityRspBo.setActivityId(newId);
        } else {
            DycActivityChangeInfo dycActivityChangeInfo = this.getDycActivityChangeInfoFail(reqBo);
            this.setFail(dycActivityChangeInfo);
        }
        return dycActDealAppApproveActivityRspBo;
    }

    private void updateAlertInfo(Long originalActivityId) {
        DycActFscOrderDO dycActFscOrderDO = new DycActFscOrderDO();
        dycActFscOrderDO.setFscOrderId(originalActivityId);
        dycActFscOrderDO.setAlertType(DycActivityConstants.AlertType.LAST_PAY);
        ActAlertOrderInfo actAlertOrderInfo = this.dycActAlertInfoRepository.getAlertInfo(dycActFscOrderDO);
        if (!Objects.isNull(actAlertOrderInfo)) {
            DycActDealOrderAlertDO set = new DycActDealOrderAlertDO();
            set.setAlertState(DycActivityConstants.AlertState.DEALED);
            set.setUpdateTime(new Date());
            DycActDealOrderAlertDO where = new DycActDealOrderAlertDO();
            where.setObjId(originalActivityId.toString());
            where.setAlertType(DycActivityConstants.AlertType.LAST_PAY);
            this.dycActAlertInfoRepository.updateAlert(set, where);
        }
    }

    private void setFail(DycActivityChangeInfo dycActivityChangeInfo) {
        DycActivityBaseInfo dycActivityBaseInfoWhere = new DycActivityBaseInfo();
        dycActivityBaseInfoWhere.setActivityId(dycActivityChangeInfo.getOriginalActivityId());
        DycActivityBaseInfo dycActivityBaseInfoSet = new DycActivityBaseInfo();
        dycActivityBaseInfoSet.setActivityState(dycActivityChangeInfo.getOriginalActivityState());
        this.dycActActivityRepository.updateByNew(dycActivityBaseInfoSet, dycActivityBaseInfoWhere);
        DycActivityChangeInfo dycActivityChangeDoSet = new DycActivityChangeInfo();
        dycActivityChangeDoSet.setChangeState("3");
        DycActivityChangeInfo dycActivityChangeDoWhere = new DycActivityChangeInfo();
        dycActivityChangeDoWhere.setChangeId(dycActivityChangeInfo.getChangeId());
        this.dycActActivityChangeRepository.updateByNew(dycActivityChangeDoSet, dycActivityChangeDoWhere);
    }

    private DycActivityChangeInfo getDycActivityChangeInfoFail(DycActDealAppApproveActivityReqBo reqBo) {
        DycActivityChangeDO dycActivityChangeDo = new DycActivityChangeDO();
        dycActivityChangeDo.setChangeId(reqBo.getChangeId());
        DycActivityChangeInfo dycActivityChangeInfo = this.dycActActivityChangeRepository.queryActivityChangeBaseInfo(dycActivityChangeDo);
        if (dycActivityChangeInfo == null) {
            throw new BaseBusinessException("8888", "\u67e5\u8be2\u53d8\u66f4\u8868\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        return dycActivityChangeInfo;
    }

    private void setPass(DycActivityChangeInfo dycActivityChangeInfo) {
        DycActivityChangeInfo dycActivityChangeDoSet = new DycActivityChangeInfo();
        dycActivityChangeDoSet.setChangeState("2");
        DycActivityChangeInfo dycActivityChangeDoWhere = new DycActivityChangeInfo();
        dycActivityChangeDoWhere.setChangeId(dycActivityChangeInfo.getChangeId());
        this.dycActActivityChangeRepository.updateByNew(dycActivityChangeDoSet, dycActivityChangeDoWhere);
    }

    private void setDel(DycActivityChangeInfo dycActivityChangeInfo) {
        DycActivityBaseInfo dycActivityBaseInfoWhere = new DycActivityBaseInfo();
        dycActivityBaseInfoWhere.setActivityId(dycActivityChangeInfo.getOriginalActivityId());
        DycActivityBaseInfo dycActivityBaseInfoSet = new DycActivityBaseInfo();
        dycActivityBaseInfoSet.setDelFlag(ActConstants.DelFlag.DEL);
        this.dycActActivityRepository.updateByNew(dycActivityBaseInfoSet, dycActivityBaseInfoWhere);
    }

    private void setSup(Long newId, List<DycActivityChangeSupplierInfo> activityChangeUserInfoSupList) {
        List dycActivityChangeSupplierInfos = JSONObject.parseArray((String)JSONObject.toJSONString(activityChangeUserInfoSupList), DycActivitySupplierInfo.class);
        dycActivityChangeSupplierInfos.forEach(o -> {
            o.setActivityId(newId);
            o.setId(Sequence.getInstance().nextId());
        });
        this.dycActActivitySupplierRepository.insertBatchNew(dycActivityChangeSupplierInfos);
    }

    private void setUser(Date date, Long newId, List<DycActivityChangeUserInfo> activityChangeUserInfoList) {
        List dycActivityUserInfoList = JSONObject.parseArray((String)JSONObject.toJSONString(activityChangeUserInfoList), DycActivityUserInfo.class);
        dycActivityUserInfoList.forEach(o -> {
            o.setActivityId(newId);
            o.setId(Sequence.getInstance().nextId());
            o.setCreateTime(date);
        });
        this.dycActActivityUserRepository.insertBatchNew(dycActivityUserInfoList);
    }

    private void setInfo(Date date, String state, Long newId, DycActivityChangeInfo dycActivityChangeInfo) {
        DycActivityBaseInfo dycActivityBaseInfoModel = new DycActivityBaseInfo();
        dycActivityBaseInfoModel.setActivityId(dycActivityChangeInfo.getOriginalActivityId());
        DycActivityBaseInfo modelByNew = this.dycActActivityRepository.getModelByNew(dycActivityBaseInfoModel);
        DycActivityBaseInfo dycActivityBaseInfo = (DycActivityBaseInfo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)dycActivityChangeInfo), DycActivityBaseInfo.class);
        dycActivityBaseInfo.setActivityId(newId);
        dycActivityBaseInfo.setActivityCode(dycActivityChangeInfo.getNewActivityCode());
        dycActivityBaseInfo.setActivityVersion(dycActivityChangeInfo.getNewActivityVersion());
        dycActivityBaseInfo.setCreateTime(modelByNew.getCreateTime());
        dycActivityBaseInfo.setCreateUserId(modelByNew.getCreateUserId());
        dycActivityBaseInfo.setCreateUserName(modelByNew.getCreateUserName());
        if (dycActivityChangeInfo.getActivityEndTime().compareTo(date) >= 0 && dycActivityChangeInfo.getActivityStartTime().compareTo(date) <= 0) {
            state = "6";
        } else if (dycActivityChangeInfo.getActivityStartTime().compareTo(date) > 0) {
            state = "4";
        } else if (dycActivityChangeInfo.getActivityStartTime().compareTo(date) < 0) {
            state = "4";
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dycActivityChangeInfo.getActivityStartTime());
        calendar.add(5, Integer.parseInt(this.yYLastPayTime));
        Date later = calendar.getTime();
        dycActivityBaseInfo.setYyLastPayTime(later);
        if (org.springframework.util.StringUtils.hasText((String)dycActivityChangeInfo.getJnPayDay())) {
            Calendar calendarLast = Calendar.getInstance();
            calendarLast.setTime(dycActivityBaseInfo.getYyLastPayTime());
            calendarLast.add(5, -Integer.parseInt(dycActivityChangeInfo.getJnPayDay()));
            Date laterLast = calendarLast.getTime();
            dycActivityBaseInfo.setLastPayTime(laterLast);
        }
        dycActivityBaseInfo.setActivityState(state);
        dycActivityBaseInfo.setAlertType(null);
        dycActivityBaseInfo.setWarningDay(null);
        this.dycActActivityRepository.insertNew(dycActivityBaseInfo);
    }

    private List<DycActivityChangeSupplierInfo> getDycActivityChangeSupplierInfos(DycActDealAppApproveActivityReqBo reqBo) {
        DycActivityChangeSupplierInfo dycActivityChangeDoChangeSup = new DycActivityChangeSupplierInfo();
        dycActivityChangeDoChangeSup.setChangeId(reqBo.getChangeId());
        List<DycActivityChangeSupplierInfo> activityChangeUserInfoSupList = this.dycActActivityChangeSupplierRepository.getListNew(dycActivityChangeDoChangeSup);
        if (CollectionUtils.isEmpty(activityChangeUserInfoSupList)) {
            throw new BaseBusinessException("8888", "\u67e5\u8be2\u53d8\u66f4\u4f9b\u5e94\u5546\u8868\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        return activityChangeUserInfoSupList;
    }

    private List<DycActivityChangeUserInfo> getDycActivityChangeUserInfos(DycActDealAppApproveActivityReqBo reqBo) {
        DycActivityChangeUserInfo dycActivityChangeDoChange = new DycActivityChangeUserInfo();
        dycActivityChangeDoChange.setChangeId(reqBo.getChangeId());
        dycActivityChangeDoChange.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        List<DycActivityChangeUserInfo> activityChangeUserInfoList = this.dycActActivityChangeUserRepository.getListNew(dycActivityChangeDoChange);
        if (CollectionUtils.isEmpty(activityChangeUserInfoList)) {
            throw new BaseBusinessException("8888", "\u67e5\u8be2\u53d8\u66f4\u7528\u6237\u8868\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        return activityChangeUserInfoList;
    }

    private DycActivityChangeInfo getDycActivityChangeInfo(DycActDealAppApproveActivityReqBo reqBo) {
        DycActivityChangeInfo dycActivityChangeDo = new DycActivityChangeInfo();
        dycActivityChangeDo.setChangeId(reqBo.getChangeId());
        dycActivityChangeDo.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        DycActivityChangeInfo dycActivityChangeInfo = this.dycActActivityChangeRepository.getModelByNew(dycActivityChangeDo);
        if (dycActivityChangeInfo == null) {
            throw new BaseBusinessException("8888", "\u67e5\u8be2\u53d8\u66f4\u8868\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        dycActivityChangeInfo.setJnPayDay(reqBo.getJnPayDay());
        return dycActivityChangeInfo;
    }

    private void setOrgItem(DycActivityChangeInfo dycActivityChangeInfo, Long newId, Date date) {
        switch (String.valueOf(dycActivityChangeInfo.getCommodityRelaMethod())) {
            case "2": {
                this.dealCatalog(dycActivityChangeInfo, newId, date);
                break;
            }
            case "3": {
                this.dealCommodity(dycActivityChangeInfo, newId, date);
                break;
            }
        }
    }

    private void dealCatalog(DycActivityChangeInfo dycActivityChangeInfo, Long newId, Date date) {
        DycActivityChangeDO dycActivityChangeDo = new DycActivityChangeDO();
        dycActivityChangeDo.setChangeId(dycActivityChangeInfo.getChangeId());
        List<DycActivityChangeRelaCommodityCatalogInfo> list = this.dycActActivityChangeCommodityRepository.getListCatalog(dycActivityChangeDo);
        if (CollectionUtils.isEmpty(list)) {
            throw new BaseBusinessException("8888", "\u67e5\u8be2\u53d8\u66f4\u5546\u54c1\u7c7b\u76ee\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        List dycActiveCommodityCatalogInfoList = JSONObject.parseArray((String)JSONObject.toJSONString(list), DycActiveCommodityCatalogInfo.class);
        dycActiveCommodityCatalogInfoList.forEach(o -> {
            o.setActivityId(newId);
            o.setRelaId(Sequence.getInstance().nextId());
            o.setCreateTime(date);
        });
        this.dycActActivityCommodityRepository.insertAllCatalog(dycActiveCommodityCatalogInfoList);
    }

    private void dealCommodity(DycActivityChangeInfo dycActivityChangeInfo, Long newId, Date date) {
        ActivityChangeRelaCommodityInfo activityChangeRelaCommodityInfo = new ActivityChangeRelaCommodityInfo();
        activityChangeRelaCommodityInfo.setChangeId(dycActivityChangeInfo.getChangeId());
        List<ActivityChangeRelaCommodityInfo> list = this.dycActActivityChangeCommodityRepository.getList(activityChangeRelaCommodityInfo);
        if (CollectionUtils.isEmpty(list)) {
            throw new BaseBusinessException("8888", "\u67e5\u8be2\u53d8\u66f4\u5546\u54c1\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        List dycActActivityRelaCommodityInfoList = JSONObject.parseArray((String)JSONObject.toJSONString(list), DycActActivityRelaCommodityInfo.class);
        dycActActivityRelaCommodityInfoList.forEach(o -> {
            o.setActivityId(newId);
            o.setRelaId(Sequence.getInstance().nextId());
            o.setCreateTime(date);
        });
        this.dycActActivityCommodityRepository.insertAllCommodity(dycActActivityRelaCommodityInfoList);
    }

    @Override
    public DycActQuerySyncActivityUserChangeListRspBo queryActivityUserChangeScoreList(DycActQuerySyncActivityUserChangeListReqBo reqBo) {
        DycActQuerySyncActivityUserChangeListRspBo dycActQuerySyncActivityUserChangeListRspBo = new DycActQuerySyncActivityUserChangeListRspBo();
        ActActivityChangeUserScoresChangeDO actActivityChangeUserScoresChangeDo = new ActActivityChangeUserScoresChangeDO();
        actActivityChangeUserScoresChangeDo.setChangeId(reqBo.getChangeId());
        List<ActActivityChangeUserScoresChangeDO> list = this.actActivityChangeUserScoresChangeRepository.getList(actActivityChangeUserScoresChangeDo);
        if (CollectionUtils.isEmpty(list)) {
            dycActQuerySyncActivityUserChangeListRspBo.setSyncUserScoreBoList(new ArrayList());
            return dycActQuerySyncActivityUserChangeListRspBo;
        }
        ArrayList<SyncUserScoreBoList> syncUserScoreBoList = new ArrayList<SyncUserScoreBoList>();
        for (ActActivityChangeUserScoresChangeDO o : list) {
            SyncUserScoreBoList syncUserScoreBo;
            if (o.getOriginalScores() == null) {
                syncUserScoreBo = new SyncUserScoreBoList();
                syncUserScoreBo.setGiveScores(o.getAfterChangeScores());
                syncUserScoreBo.setActUserId(o.getUserId());
                syncUserScoreBoList.add(syncUserScoreBo);
                continue;
            }
            if (o.getOriginalScores() != null && o.getAfterChangeScores() != null && o.getOriginalScores().compareTo(o.getAfterChangeScores()) != 0) {
                syncUserScoreBo = new SyncUserScoreBoList();
                syncUserScoreBo.setGiveScores(o.getAfterChangeScores().subtract(o.getOriginalScores()));
                syncUserScoreBo.setActUserId(o.getUserId());
                syncUserScoreBoList.add(syncUserScoreBo);
                continue;
            }
            if (o.getAfterChangeScores() != null) continue;
            throw new BaseBusinessException("8888", "\u67e5\u8be2\u6d3b\u52a8\u53d8\u66f4\u79ef\u5206\u540c\u6b65\u63a5\u53e3\u6570\u636e\u6709\u8bef");
        }
        dycActQuerySyncActivityUserChangeListRspBo.setSyncUserScoreBoList(syncUserScoreBoList);
        return dycActQuerySyncActivityUserChangeListRspBo;
    }

    @Override
    public List<ActivityChangeUserInfo> selectByChangeId(DycActivityChangeDO dycActivityChangeDO) {
        return this.dycActActivityChangeUserRepository.selectByChangeId(dycActivityChangeDO);
    }

    @Override
    public List<DycActivityChangeRelaCommodityCatalogInfo> getListCatalog(DycActivityChangeDO reqBo) {
        return this.dycActActivityChangeCommodityRepository.getListCatalog(reqBo);
    }

    @Override
    public int updateActivityCommodityCatalogInCom(DycActivityChangeDO reqBO) {
        return this.dycActActivityChangeCommodityCatalogInComRepository.batchSelectActivityChangeCommodity(reqBO);
    }

    @Override
    public List<DycActivityChangeRelaCommodityInfo> getComCount(DycActivityChangeRelaCommodityInfo reqBo) {
        return this.dycActActivityChangeCommodityCatalogInComRepository.getComCount(reqBo);
    }
}

