/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.service.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.api.DycActSkuInfoModel;
import com.tydic.dyc.act.model.bo.ActJudgeGuideLowestPriceReqBO;
import com.tydic.dyc.act.model.bo.ActJudgeGuideLowestPriceRspBO;
import com.tydic.dyc.act.model.bo.ActSkuGuideBO;
import com.tydic.dyc.act.model.bo.ActSkuGuideListRspBO;
import com.tydic.dyc.act.model.bo.ActSkuGuideReqBO;
import com.tydic.dyc.act.model.bo.ActSkuInfoQryBO;
import com.tydic.dyc.act.model.bo.ActSkuInfoQryRspBO;
import com.tydic.dyc.act.model.bo.DycActActivityRelaCommodityInfo;
import com.tydic.dyc.act.model.bo.DycActiveCommodityCatalogInfo;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActBatchSelectActiveCommodityCatalogService;
import com.tydic.dyc.act.service.bo.DycActActivityCommodityCatalogInfoBO;
import com.tydic.dyc.act.service.bo.DycActBatchSelectActivityCommodityCatalogReqBO;
import com.tydic.dyc.act.service.bo.DycActBatchSelectActivityCommodityCatalogRspBO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ACT_GROUP_DEV/3.2.1/com.tydic.dyc.act.service.api.DycActBatchSelectActiveCommodityCatalogService"})
public class DycActBatchSelectActiveCommodityCatalogServiceImpl
implements DycActBatchSelectActiveCommodityCatalogService {
    private static final Logger log = LoggerFactory.getLogger(DycActBatchSelectActiveCommodityCatalogServiceImpl.class);
    @Autowired
    private DycActActivityModel dycActActivityModel;
    @Autowired
    private DycActSkuInfoModel dycActSkuInfoModel;
    @Value(value="${actBatchNum:1000}")
    private Integer actBatchNum;
    @Value(value="${batchThreadNum:33}")
    private Integer batchThreadNum;

    @PostMapping(value={"batchSelectActivityCommodityCatalog"})
    public DycActBatchSelectActivityCommodityCatalogRspBO batchSelectActivityCommodityCatalog(@RequestBody DycActBatchSelectActivityCommodityCatalogReqBO reqBO) {
        this.verifyParam(reqBO);
        List<DycActiveCommodityCatalogInfo> commodityCatalogInfoBos = this.getDycActiveCommodityCatalogInfos(reqBO);
        DycActivityDO dycActivityDO = (DycActivityDO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), DycActivityDO.class);
        dycActivityDO.setCreateUserId(reqBO.getUserId());
        dycActivityDO.setCreateUserName(reqBO.getName());
        dycActivityDO.setCommodityCatalogInfoBOS(commodityCatalogInfoBos);
        this.dycActActivityModel.batchSelectActivityCommodityCatalog(dycActivityDO);
        DycActBatchSelectActivityCommodityCatalogRspBO rspBO = new DycActBatchSelectActivityCommodityCatalogRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void getCommodityInfo(DycActBatchSelectActivityCommodityCatalogReqBO reqBO) {
        List<Long> collect = reqBO.getCommodityCatalogInfoBOS().stream().map(item -> Long.valueOf(item.getThreeCatalogId())).collect(Collectors.toList());
        ActJudgeGuideLowestPriceReqBO lowestPriceReqBO = new ActJudgeGuideLowestPriceReqBO();
        lowestPriceReqBO.setIsAnomalousPrice(reqBO.getIsAnomalousPrice());
        lowestPriceReqBO.setAgreementPriceMin(reqBO.getAgreementPriceMin());
        lowestPriceReqBO.setAgreementPriceMax(reqBO.getAgreementPriceMax());
        lowestPriceReqBO.setLowPrice(reqBO.getLowPrice());
        lowestPriceReqBO.setGuideIds(collect);
        Date startDate = new Date();
        log.info("\u5f00\u59cb\u65f6\u95f4\uff1a" + startDate);
        ActJudgeGuideLowestPriceRspBO priceRspBO = this.dycActSkuInfoModel.judgeGuideLowestPrice(lowestPriceReqBO);
        Date endDate = new Date();
        log.info("\u7ed3\u675f\u65f6\u95f4\uff1a" + endDate);
        if (ObjectUtils.isEmpty((Object)((Object)priceRspBO)) || CollectionUtils.isEmpty(priceRspBO.getResult())) {
            return;
        }
        ArrayList<Long> skuIdList = new ArrayList<Long>();
        priceRspBO.getResult().forEach(item -> {
            if (!CollectionUtils.isEmpty(item.getSkuIds())) {
                skuIdList.addAll(item.getSkuIds());
            }
        });
        if (CollectionUtils.isEmpty(skuIdList)) {
            return;
        }
        if (skuIdList.size() <= this.actBatchNum) {
            this.getDycActActivityRelaCommodityInfos(reqBO, skuIdList);
        } else {
            ExecutorService executorService = this.createExecutorService(this.batchThreadNum);
            int allTotal = skuIdList.size();
            int batchSizeT = allTotal / this.batchThreadNum;
            int remainder = allTotal % this.batchThreadNum;
            int start = 0;
            for (int i = 0; i < this.batchThreadNum; ++i) {
                int end = start + batchSizeT + (i < remainder ? 1 : 0);
                if (end > allTotal) {
                    end = allTotal;
                }
                List longs = skuIdList.subList(start, end);
                executorService.submit(() -> this.getDycActActivityRelaCommodityInfos(reqBO, longs));
                start = end;
            }
            this.shutdownExecutorService(executorService);
        }
    }

    private void getDycActActivityRelaCommodityInfos(DycActBatchSelectActivityCommodityCatalogReqBO reqBO, List<Long> skuIdList) {
        ArrayList<DycActActivityRelaCommodityInfo> rspBO = new ArrayList<DycActActivityRelaCommodityInfo>();
        int total = skuIdList.size();
        int batchSize = this.actBatchNum;
        int totalBatch = (total + batchSize - 1) / batchSize;
        for (int batchIndex = 0; batchIndex < totalBatch; ++batchIndex) {
            int startIndex = batchIndex * batchSize;
            int endIndex = Math.min((batchIndex + 1) * batchSize, total);
            List<Long> list = skuIdList.subList(startIndex, endIndex);
            ActSkuInfoQryBO qryBO = new ActSkuInfoQryBO();
            qryBO.setPageNo(1);
            qryBO.setPageSize(list.size());
            qryBO.setSkuIds(list);
            ActSkuInfoQryRspBO qryRspBO = this.dycActSkuInfoModel.querySkuPageList(qryBO);
            if (ObjectUtils.isEmpty((Object)((Object)qryRspBO)) || CollectionUtils.isEmpty((Collection)qryRspBO.getRows())) {
                return;
            }
            qryRspBO.getRows().forEach(item -> {
                DycActActivityRelaCommodityInfo info = new DycActActivityRelaCommodityInfo();
                info.setCommodityPoolName(item.getSkuPools());
                info.setSkuCode(item.getExtSkuId());
                info.setSkuName(item.getSkuName());
                info.setSkuUrl(item.getPicUrl());
                info.setSkuId(item.getSkuId());
                info.setPrice(item.getAgreementPrice());
                info.setSkuStatus(item.getSkuStatus());
                info.setFirstCatalogId(item.getFirstCatalogId());
                info.setFirstCatalogName(item.getFirstCatalogName());
                info.setThreeCatalogId(item.getThreeCatalogId());
                info.setThreeCatalogName(item.getThreeCatalogName());
                info.setSecondCatalogId(item.getSecondCatalogId());
                info.setSecondCatalogName(item.getSecondCatalogName());
                info.setCterminalUrl(item.getJdSkuUrl());
                info.setBrand(item.getBrandName());
                info.setFavorableRate(item.getGoodRate().doubleValue());
                info.setSkuDetails(item.getSkuPcDetailUrl());
                info.setExtSkuId(item.getExtSkuId());
                rspBO.add(info);
            });
            DycActivityDO activityDO = new DycActivityDO();
            activityDO.setActivityId(reqBO.getActivityId());
            activityDO.setCreateUserId(reqBO.getUserId());
            activityDO.setCreateUserName(reqBO.getName());
            activityDO.setActActivityRelaCommodityBOS(rspBO);
            this.dycActActivityModel.batchSelectActivityCommodityCatalog(activityDO);
        }
    }

    private ExecutorService createExecutorService(int threadNum) {
        return new ThreadPoolExecutor(threadNum, threadNum, 200L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(100), new ThreadFactoryBuilder().setNameFormat("\u6dfb\u52a0\u5546\u54c1").build(), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    private void shutdownExecutorService(ExecutorService executorService) {
        try {
            executorService.shutdown();
            if (!executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            executorService.shutdownNow();
        }
    }

    private List<DycActiveCommodityCatalogInfo> getDycActiveCommodityCatalogInfos(DycActBatchSelectActivityCommodityCatalogReqBO reqBO) {
        List<Long> threeCatalogIds = reqBO.getCommodityCatalogInfoBOS().stream().map(DycActActivityCommodityCatalogInfoBO::getThreeCatalogId).distinct().map(Convert::toLong).collect(Collectors.toList());
        ActSkuGuideReqBO qryActSkuGuideReqBo = new ActSkuGuideReqBO();
        qryActSkuGuideReqBo.setGuideCatalogIdList(threeCatalogIds);
        ActSkuGuideListRspBO actSkuGuideListRspBO = this.dycActSkuInfoModel.getCatalogBOByCatalogIds(qryActSkuGuideReqBo);
        if (MapUtil.isEmpty(actSkuGuideListRspBO.getCatalogBOByCatalogIds())) {
            throw new BaseBusinessException("200001", "\u67e5\u8be2\u5546\u54c1\u7c7b\u76ee\u5931\u8d25");
        }
        Map<Long, ActSkuGuideBO> actSkuGuideBoMap = actSkuGuideListRspBO.getCatalogBOByCatalogIds();
        ArrayList<DycActiveCommodityCatalogInfo> commodityCatalogInfoBos = new ArrayList<DycActiveCommodityCatalogInfo>(reqBO.getCommodityCatalogInfoBOS().size());
        for (DycActActivityCommodityCatalogInfoBO each : reqBO.getCommodityCatalogInfoBOS()) {
            ActSkuGuideBO actSkuGuideBO = actSkuGuideBoMap.get(Long.parseLong(each.getThreeCatalogId()));
            if (actSkuGuideBO == null) continue;
            DycActiveCommodityCatalogInfo dycActiveCommodityCatalogInfo = (DycActiveCommodityCatalogInfo)JSON.parseObject((String)JSON.toJSONString((Object)each), DycActiveCommodityCatalogInfo.class);
            dycActiveCommodityCatalogInfo.setThreeCatalogName(actSkuGuideBO.getThreeCatalogName());
            dycActiveCommodityCatalogInfo.setSecondCatalogId(actSkuGuideBO.getSecondCatalogId());
            dycActiveCommodityCatalogInfo.setSecondCatalogName(actSkuGuideBO.getSecondCatalogName());
            dycActiveCommodityCatalogInfo.setFirstCatalogId(actSkuGuideBO.getFirstCatalogId());
            dycActiveCommodityCatalogInfo.setFirstCatalogName(actSkuGuideBO.getFirstCatalogName());
            commodityCatalogInfoBos.add(dycActiveCommodityCatalogInfo);
        }
        return commodityCatalogInfoBos;
    }

    private void verifyParam(DycActBatchSelectActivityCommodityCatalogReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getActivityId()) {
            throw new BaseBusinessException("200001", "\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getCommodityCatalogInfoBOS())) {
            throw new BaseBusinessException("200001", "\u5546\u54c1\u7c7b\u76ee\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (DycActActivityCommodityCatalogInfoBO commodityCatalogInfoBO : reqBO.getCommodityCatalogInfoBOS()) {
            if (!StringUtils.isBlank((CharSequence)commodityCatalogInfoBO.getThreeCatalogId())) continue;
            throw new BaseBusinessException("200001", "\u5165\u53c2\uff0c\u5546\u54c1\u4e09\u7ea7\u7c7b\u76ee\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

