/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.model.api.DycActSkuInfoModel;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.ActJudgeGuideLowestPriceReqBO;
import com.tydic.dyc.act.model.bo.ActJudgeGuideLowestPriceRspBO;
import com.tydic.dyc.act.model.bo.ActSkuInfoQryBO;
import com.tydic.dyc.act.model.bo.ActSkuInfoQryRspBO;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.model.bo.DycActivityChangeRelaCommodityCatalogInfo;
import com.tydic.dyc.act.model.bo.DycActivityChangeRelaCommodityInfo;
import com.tydic.dyc.act.service.api.DycActBatchSelectActivityChangeCommodityCatalogInComService;
import com.tydic.dyc.act.service.bo.DycActBatchSelectActivityChangeCommodityCatalogReqBO;
import com.tydic.dyc.act.service.bo.DycActBatchSelectActivityChangeCommodityCatalogRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ACT_GROUP_DEV/3.2.1/com.tydic.dyc.act.service.api.DycActBatchSelectActivityChangeCommodityCatalogInComService"})
public class DycActBatchSelectActivityChangeCommodityCatalogInComServiceImpl
implements DycActBatchSelectActivityChangeCommodityCatalogInComService {
    private static final Logger log = LoggerFactory.getLogger(DycActBatchSelectActivityChangeCommodityCatalogInComServiceImpl.class);
    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;
    @Autowired
    private DycActSkuInfoModel dycActSkuInfoModel;
    @Value(value="${actBatchNum:5}")
    private Integer actBatchNum;

    @PostMapping(value={"batchSelectActivityChangeCommodityCatalogInCom"})
    public DycActBatchSelectActivityChangeCommodityCatalogRspBO batchSelectActivityChangeCommodityCatalogInCom(@RequestBody DycActBatchSelectActivityChangeCommodityCatalogReqBO reqBO) {
        DycActBatchSelectActivityChangeCommodityCatalogRspBO rspBO = new DycActBatchSelectActivityChangeCommodityCatalogRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (CollectionUtils.isEmpty((Collection)reqBO.getCommodityCatalogList())) {
            return rspBO;
        }
        List listCatalog = JSON.parseArray((String)JSON.toJSONString((Object)reqBO.getCommodityCatalogList()), DycActivityChangeRelaCommodityCatalogInfo.class);
        this.getCommodityInfo(reqBO, listCatalog);
        return rspBO;
    }

    private List<DycActivityChangeRelaCommodityInfo> getCommodityInfo(DycActBatchSelectActivityChangeCommodityCatalogReqBO reqBO, List<DycActivityChangeRelaCommodityCatalogInfo> catalogInfos) {
        ArrayList<DycActivityChangeRelaCommodityInfo> rspBO = new ArrayList<DycActivityChangeRelaCommodityInfo>();
        List collect = catalogInfos.stream().map(item -> Long.valueOf(item.getThreeCatalogId())).collect(Collectors.toList());
        int fa = 0;
        int total = collect.size();
        int batchSize = this.actBatchNum;
        int totalBatch = (total + batchSize - 1) / batchSize;
        for (int batchIndex = 0; batchIndex < totalBatch; ++batchIndex) {
            int startIndex = batchIndex * batchSize;
            int endIndex = Math.min((batchIndex + 1) * batchSize, total);
            List<Long> list = collect.subList(startIndex, endIndex);
            ActJudgeGuideLowestPriceReqBO lowestPriceReqBO = new ActJudgeGuideLowestPriceReqBO();
            lowestPriceReqBO.setIsAnomalousPrice(reqBO.getIsAnomalousPrice());
            lowestPriceReqBO.setAgreementPriceMin(reqBO.getAgreementPriceMin());
            lowestPriceReqBO.setAgreementPriceMax(reqBO.getAgreementPriceMax());
            lowestPriceReqBO.setLowPrice(reqBO.getLowPrice());
            lowestPriceReqBO.setGuideIds(list);
            ActJudgeGuideLowestPriceRspBO priceRspBO = this.dycActSkuInfoModel.queryGuideToNumMap(lowestPriceReqBO);
            if (ObjectUtils.isEmpty((Object)((Object)priceRspBO)) || CollectionUtils.isEmpty(priceRspBO.getResult())) continue;
            ArrayList<Long> skuIdList = new ArrayList<Long>();
            priceRspBO.getResult().forEach(item -> {
                if (!CollectionUtils.isEmpty(item.getSkuIds())) {
                    skuIdList.addAll(item.getSkuIds());
                }
            });
            log.info("\u53d8\u66f4\u540c\u6b65\u5546\u54c1\u603b\u6570\uff1a" + (fa += skuIdList.size()));
            if (CollectionUtils.isEmpty(skuIdList)) continue;
            ActSkuInfoQryBO qryBO = new ActSkuInfoQryBO();
            qryBO.setPageNo(1);
            qryBO.setPageSize(skuIdList.size());
            qryBO.setSkuIds(skuIdList);
            ActSkuInfoQryRspBO qryRspBO = this.dycActSkuInfoModel.querySkuPageList(qryBO);
            if (ObjectUtils.isEmpty((Object)((Object)qryRspBO)) || CollectionUtils.isEmpty((Collection)qryRspBO.getRows())) continue;
            ArrayList<DycActivityChangeRelaCommodityInfo> arrayList = new ArrayList<DycActivityChangeRelaCommodityInfo>();
            qryRspBO.getRows().forEach(item -> {
                DycActivityChangeRelaCommodityInfo info = new DycActivityChangeRelaCommodityInfo();
                info.setCommodityPoolName(item.getSkuPools());
                info.setSkuCode(item.getSkuCode());
                info.setSkuName(item.getSkuName());
                info.setSkuUrl(item.getPicUrl());
                info.setSkuId(item.getSkuId());
                info.setPrice(item.getAgreementPrice());
                info.setSkuStatus(item.getSkuStatus());
                info.setFirstCatalogId(item.getFirstCatalogId());
                info.setFirstCatalogName(item.getFirstCatalogName());
                info.setThreeCatalogId(item.getThreeCatalogId());
                info.setThreeCatalogName(item.getThreeCatalogName());
                info.setSecondCatalogId(item.getSecondCatalogId());
                info.setSecondCatalogName(item.getSecondCatalogName());
                info.setCterminalUrl(item.getJdSkuUrl());
                info.setBrand(item.getBrandName());
                info.setFavorableRate(item.getGoodRate().doubleValue());
                info.setSkuDetails(item.getSkuPcDetailUrl());
                info.setExtSkuId(item.getExtSkuId());
                arrayList.add(info);
            });
            DycActivityChangeDO dycActivityChangeDO = new DycActivityChangeDO();
            dycActivityChangeDO.setCommodityList(arrayList);
            dycActivityChangeDO.setChangeId(reqBO.getChangeId());
            this.dycActivityChangeModel.updateActivityCommodityCatalogInCom(dycActivityChangeDO);
        }
        return rspBO;
    }
}

