/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.service.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.model.api.DycActSkuInfoModel;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.ActJudgeGuideLowestPriceReqBO;
import com.tydic.dyc.act.model.bo.ActJudgeGuideLowestPriceRspBO;
import com.tydic.dyc.act.model.bo.ActSkuGuideBO;
import com.tydic.dyc.act.model.bo.ActSkuGuideListRspBO;
import com.tydic.dyc.act.model.bo.ActSkuGuideReqBO;
import com.tydic.dyc.act.model.bo.ActSkuInfoQryBO;
import com.tydic.dyc.act.model.bo.ActSkuInfoQryRspBO;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.model.bo.DycActivityChangeRelaCommodityCatalogInfo;
import com.tydic.dyc.act.model.bo.DycActivityChangeRelaCommodityInfo;
import com.tydic.dyc.act.service.api.DycActBatchSelectActivityChangeCommodityCatalogService;
import com.tydic.dyc.act.service.bo.DycActBatchSelectActivityChangeCommodityCatalogReqBO;
import com.tydic.dyc.act.service.bo.DycActBatchSelectActivityChangeCommodityCatalogRspBO;
import com.tydic.dyc.act.service.bo.DycActivityChangeRelaCommodityCatalogInfoBO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ACT_GROUP_DEV/3.2.1/com.tydic.dyc.act.service.api.DycActBatchSelectActivityChangeCommodityCatalogService"})
public class DycActBatchSelectActivityChangeCommodityCatalogServiceImpl
implements DycActBatchSelectActivityChangeCommodityCatalogService {
    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;
    @Autowired
    private DycActSkuInfoModel dycActSkuInfoModel;

    @PostMapping(value={"batchSelectActivityChangeCommodityCatalog"})
    public DycActBatchSelectActivityChangeCommodityCatalogRspBO batchSelectActivityChangeCommodityCatalog(@RequestBody DycActBatchSelectActivityChangeCommodityCatalogReqBO reqBo) {
        this.verifyParam(reqBo);
        List<DycActivityChangeRelaCommodityCatalogInfo> commodityCatalogInfoBos = this.getDycActiveCommodityCatalogInfos(reqBo);
        DycActivityChangeDO dycActivityChangeDo = (DycActivityChangeDO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBo), DycActivityChangeDO.class));
        dycActivityChangeDo.setCreateUserId(reqBo.getUserId());
        dycActivityChangeDo.setCreateUserName(reqBo.getName());
        dycActivityChangeDo.setCommodityCatalogList(commodityCatalogInfoBos);
        this.dycActivityChangeModel.batchSelectActivityChangeCommodityCatalog(dycActivityChangeDo);
        DycActBatchSelectActivityChangeCommodityCatalogRspBO rspBo = new DycActBatchSelectActivityChangeCommodityCatalogRspBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private List<DycActivityChangeRelaCommodityInfo> getCommodityInfo(DycActBatchSelectActivityChangeCommodityCatalogReqBO reqBO) {
        ArrayList<DycActivityChangeRelaCommodityInfo> rspBO = new ArrayList<DycActivityChangeRelaCommodityInfo>();
        List<Long> collect = reqBO.getCommodityCatalogList().stream().map(item -> Long.valueOf(item.getThreeCatalogId())).collect(Collectors.toList());
        ActJudgeGuideLowestPriceReqBO lowestPriceReqBO = new ActJudgeGuideLowestPriceReqBO();
        lowestPriceReqBO.setIsAnomalousPrice(reqBO.getIsAnomalousPrice());
        lowestPriceReqBO.setAgreementPriceMin(reqBO.getAgreementPriceMin());
        lowestPriceReqBO.setAgreementPriceMax(reqBO.getAgreementPriceMax());
        lowestPriceReqBO.setLowPrice(reqBO.getLowPrice());
        lowestPriceReqBO.setGuideIds(collect);
        ActJudgeGuideLowestPriceRspBO priceRspBO = this.dycActSkuInfoModel.judgeGuideLowestPrice(lowestPriceReqBO);
        if (ObjectUtils.isEmpty((Object)((Object)priceRspBO)) || CollectionUtils.isEmpty(priceRspBO.getResult())) {
            return rspBO;
        }
        ArrayList<Long> skuIdList = new ArrayList<Long>();
        priceRspBO.getResult().forEach(item -> {
            if (!CollectionUtils.isEmpty(item.getSkuIds())) {
                skuIdList.addAll(item.getSkuIds());
            }
        });
        if (CollectionUtils.isEmpty(skuIdList)) {
            return rspBO;
        }
        ActSkuInfoQryBO qryBO = new ActSkuInfoQryBO();
        qryBO.setPageNo(1);
        qryBO.setPageSize(skuIdList.size());
        qryBO.setSkuIds(skuIdList);
        ActSkuInfoQryRspBO qryRspBO = this.dycActSkuInfoModel.querySkuPageList(qryBO);
        if (ObjectUtils.isEmpty((Object)((Object)qryRspBO)) || CollectionUtils.isEmpty((Collection)qryRspBO.getRows())) {
            return rspBO;
        }
        qryRspBO.getRows().forEach(item -> {
            DycActivityChangeRelaCommodityInfo info = new DycActivityChangeRelaCommodityInfo();
            info.setCommodityPoolName(item.getSkuPools());
            info.setSkuCode(item.getExtSkuId());
            info.setSkuName(item.getSkuName());
            info.setSkuUrl(item.getPicUrl());
            info.setSkuId(item.getSkuId());
            info.setPrice(item.getAgreementPrice());
            info.setSkuStatus(item.getSkuStatus());
            info.setFirstCatalogId(item.getFirstCatalogId());
            info.setFirstCatalogName(item.getFirstCatalogName());
            info.setThreeCatalogId(item.getThreeCatalogId());
            info.setThreeCatalogName(item.getThreeCatalogName());
            info.setSecondCatalogId(item.getSecondCatalogId());
            info.setSecondCatalogName(item.getSecondCatalogName());
            info.setCterminalUrl(item.getJdSkuUrl());
            info.setBrand(item.getBrandName());
            info.setFavorableRate(item.getGoodRate().doubleValue());
            info.setSkuDetails(item.getSkuPcDetailUrl());
            info.setExtSkuId(item.getExtSkuId());
            rspBO.add(info);
        });
        return rspBO;
    }

    private List<DycActivityChangeRelaCommodityCatalogInfo> getDycActiveCommodityCatalogInfos(DycActBatchSelectActivityChangeCommodityCatalogReqBO reqBO) {
        List<Long> threeCatalogIds = reqBO.getCommodityCatalogList().stream().map(DycActivityChangeRelaCommodityCatalogInfoBO::getThreeCatalogId).distinct().map(Convert::toLong).collect(Collectors.toList());
        ActSkuGuideReqBO qryActSkuGuideReqBo = new ActSkuGuideReqBO();
        qryActSkuGuideReqBo.setGuideCatalogIdList(threeCatalogIds);
        ActSkuGuideListRspBO actSkuGuideListRspBO = this.dycActSkuInfoModel.getCatalogBOByCatalogIds(qryActSkuGuideReqBo);
        if (MapUtil.isEmpty(actSkuGuideListRspBO.getCatalogBOByCatalogIds())) {
            throw new BaseBusinessException("200001", "\u67e5\u8be2\u5546\u54c1\u7c7b\u76ee\u5931\u8d25");
        }
        Map<Long, ActSkuGuideBO> actSkuGuideBoMap = actSkuGuideListRspBO.getCatalogBOByCatalogIds();
        ArrayList<DycActivityChangeRelaCommodityCatalogInfo> commodityCatalogInfoBos = new ArrayList<DycActivityChangeRelaCommodityCatalogInfo>(reqBO.getCommodityCatalogList().size());
        for (DycActivityChangeRelaCommodityCatalogInfoBO each : reqBO.getCommodityCatalogList()) {
            ActSkuGuideBO actSkuGuideBO = actSkuGuideBoMap.get(Long.parseLong(each.getThreeCatalogId()));
            if (actSkuGuideBO == null) continue;
            DycActivityChangeRelaCommodityCatalogInfo dycActiveCommodityCatalogInfo = (DycActivityChangeRelaCommodityCatalogInfo)JSON.parseObject((String)JSON.toJSONString((Object)each), DycActivityChangeRelaCommodityCatalogInfo.class);
            dycActiveCommodityCatalogInfo.setThreeCatalogName(actSkuGuideBO.getThreeCatalogName());
            dycActiveCommodityCatalogInfo.setSecondCatalogId(actSkuGuideBO.getSecondCatalogId());
            dycActiveCommodityCatalogInfo.setSecondCatalogName(actSkuGuideBO.getSecondCatalogName());
            dycActiveCommodityCatalogInfo.setFirstCatalogId(actSkuGuideBO.getFirstCatalogId());
            dycActiveCommodityCatalogInfo.setFirstCatalogName(actSkuGuideBO.getFirstCatalogName());
            commodityCatalogInfoBos.add(dycActiveCommodityCatalogInfo);
        }
        return commodityCatalogInfoBos;
    }

    private void verifyParam(DycActBatchSelectActivityChangeCommodityCatalogReqBO reqBo) {
        if (ObjectUtils.isEmpty((Object)reqBo)) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getChangeId() == null) {
            throw new BaseBusinessException("200001", "\u53d8\u66f4\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getUserId() == null) {
            throw new BaseBusinessException("200001", "\u64cd\u4f5c\u4ebaId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getName())) {
            throw new BaseBusinessException("200001", "\u64cd\u4f5c\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getCommodityCatalogList())) {
            throw new BaseBusinessException("200001", "\u5546\u54c1\u7c7b\u578b\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (DycActivityChangeRelaCommodityCatalogInfoBO commodityCatalogInfoBO : reqBo.getCommodityCatalogList()) {
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)commodityCatalogInfoBO.getThreeCatalogId())) continue;
            throw new BaseBusinessException("200001", "\u5165\u53c2\uff0c\u5546\u54c1\u4e09\u7ea7\u7c7b\u76ee\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

