/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.api.DycActFscOrderModel;
import com.tydic.dyc.act.model.bo.DycActFscOrderDO;
import com.tydic.dyc.act.model.bo.DycActFscOrderInfo;
import com.tydic.dyc.act.service.api.DycActDealFscOrderRejectService;
import com.tydic.dyc.act.service.bo.DycActDealFscOrderRejectReqBO;
import com.tydic.dyc.act.service.bo.DycActDealFscOrderRejectRspBO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ACT_GROUP_DEV/3.2.1/com.tydic.dyc.act.service.api.DycActDealFscOrderRejectService"})
public class DycActDealFscOrderRejectServiceImpl
implements DycActDealFscOrderRejectService {
    @Autowired
    private DycActFscOrderModel dycActFscOrderModel;

    @PostMapping(value={"dealFscOrderReject"})
    public DycActDealFscOrderRejectRspBO dealFscOrderReject(@RequestBody DycActDealFscOrderRejectReqBO reqBO) {
        this.checkParam(reqBO);
        DycActFscOrderDO dycActFscOrderQryDO = new DycActFscOrderDO();
        dycActFscOrderQryDO.setFscOrderId(reqBO.getFscOrderId());
        DycActFscOrderInfo dycActFscOrderInfo = this.dycActFscOrderModel.getFscOrderOne(dycActFscOrderQryDO);
        if (dycActFscOrderInfo == null) {
            throw new BaseBusinessException("200001", "\u7ed3\u7b97\u5355\u4fe1\u606f\u67e5\u8be2\u4e3a\u7a7a");
        }
        if (!DycActivityConstants.FSC_ORDER_STATE.INVOICING.equals(dycActFscOrderInfo.getOrderState())) {
            throw new BaseBusinessException("200001", "\u9a73\u56de\u5931\u8d25\uff0c\u7ed3\u7b97\u5355\u72b6\u6001\u4e0d\u4e3a\u5f00\u7968\u4e2d");
        }
        DycActFscOrderDO dycActFscOrderDO = new DycActFscOrderDO();
        dycActFscOrderDO.setFscOrderId(reqBO.getFscOrderId());
        dycActFscOrderDO.setOrderState(DycActivityConstants.FSC_ORDER_STATE.REJECT);
        dycActFscOrderDO.setUpdateTime(new Date());
        dycActFscOrderDO.setOrderDesc(reqBO.getRejectReason());
        this.dycActFscOrderModel.dealFscOrderReject(dycActFscOrderDO);
        DycActDealFscOrderRejectRspBO rspBo = (DycActDealFscOrderRejectRspBO)JSON.parseObject((String)JSON.toJSONString((Object)dycActFscOrderInfo), DycActDealFscOrderRejectRspBO.class);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    public void checkParam(DycActDealFscOrderRejectReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getFscOrderId() == null) {
            throw new BaseBusinessException("200001", "\u7ed3\u7b97\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

