/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.api.DycActFscInvoiceModel;
import com.tydic.dyc.act.model.api.DycActFscOrderModel;
import com.tydic.dyc.act.model.bo.DycActFscInvoiceDO;
import com.tydic.dyc.act.model.bo.DycActFscInvoiceInfo;
import com.tydic.dyc.act.model.bo.DycActFscOrderDO;
import com.tydic.dyc.act.model.bo.DycActFscOrderInfo;
import com.tydic.dyc.act.model.bo.DycActFscOrderInvoiceInfo;
import com.tydic.dyc.act.service.api.DycActDealFscSignCheckService;
import com.tydic.dyc.act.service.bo.DycActDealFscSignCheckReqBO;
import com.tydic.dyc.act.service.bo.DycActDealFscSignCheckRspBO;
import com.tydic.dyc.act.service.bo.DycActFscInvoiceBO;
import com.tydic.dyc.act.service.bo.DycActFscInvoiceCmpResultBO;
import com.tydic.dyc.base.utils.JUtil;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ACT_GROUP_DEV/3.2.1/com.tydic.dyc.act.service.api.DycActDealFscSignCheckService"})
public class DycActDealFscSignCheckServiceImpl
implements DycActDealFscSignCheckService {
    @Autowired
    private DycActFscOrderModel dycActFscOrderModel;
    @Autowired
    private DycActFscInvoiceModel dycActFscInvoiceModel;
    private static final String MISMATCHING = "000000";

    @PostMapping(value={"dealFscOrderSignCheck"})
    public DycActDealFscSignCheckRspBO dealFscOrderSignCheck(@RequestBody DycActDealFscSignCheckReqBO reqBO) {
        DycActDealFscSignCheckRspBO rspBO = new DycActDealFscSignCheckRspBO();
        DycActFscOrderDO dycActFscOrderDO = new DycActFscOrderDO();
        dycActFscOrderDO.setFscOrderId(reqBO.getFscOrderId());
        DycActFscOrderInfo dycActFscOrderInfo = this.dycActFscOrderModel.getFscOrderOne(dycActFscOrderDO);
        if (null == dycActFscOrderInfo) {
            throw new ZTBusinessException("\u67e5\u8be2\u7ed3\u7b97\u5355\u6570\u636e\u4e3a\u7a7a");
        }
        if (!DycActivityConstants.FSC_ORDER_STATE.INVOICED.equals(dycActFscOrderInfo.getOrderState())) {
            throw new ZTBusinessException("\u53ea\u6709\u5df2\u5f00\u7968\u72b6\u6001\u624d\u53ef\u6838\u5bf9\u53d1\u7968");
        }
        rspBO = (DycActDealFscSignCheckRspBO)JUtil.js((Object)dycActFscOrderInfo, DycActDealFscSignCheckRspBO.class);
        DycActFscOrderDO fscOrderInvoiceDO = new DycActFscOrderDO();
        fscOrderInvoiceDO.setFscOrderId(reqBO.getFscOrderId());
        DycActFscOrderInvoiceInfo dycActFscOrderInvoiceInfo = this.dycActFscOrderModel.selectOneFscOrderInvoice(fscOrderInvoiceDO);
        if (null != dycActFscOrderInvoiceInfo) {
            DycActFscInvoiceBO preInvoiceBO = (DycActFscInvoiceBO)JSON.parseObject((String)JSON.toJSONString((Object)dycActFscOrderInvoiceInfo), DycActFscInvoiceBO.class);
            preInvoiceBO.setAmt(dycActFscOrderInfo.getTotalCharge());
            rspBO.setPreInvoice(preInvoiceBO);
        }
        DycActFscInvoiceDO fscInvoiceDO = new DycActFscInvoiceDO();
        fscInvoiceDO.setFscOrderId(reqBO.getFscOrderId());
        DycActFscInvoiceInfo dycActFscInvoiceInfo = this.dycActFscInvoiceModel.getSumAmtByFscOrderId(fscInvoiceDO);
        if (null != dycActFscInvoiceInfo) {
            DycActFscInvoiceBO afterInvoiceBO = (DycActFscInvoiceBO)JSON.parseObject((String)JSON.toJSONString((Object)dycActFscInvoiceInfo), DycActFscInvoiceBO.class);
            rspBO.setAfterInvoice(afterInvoiceBO);
        }
        this.cmpResult(rspBO);
        return rspBO;
    }

    private void cmpResult(DycActDealFscSignCheckRspBO rspBO) {
        DycActFscInvoiceCmpResultBO invoiceCmpResultBO = new DycActFscInvoiceCmpResultBO();
        if (null == rspBO.getPreInvoice() || null == rspBO.getAfterInvoice()) {
            invoiceCmpResultBO.setCmpResultStr(MISMATCHING);
            DycActFscInvoiceBO invoiceBO = null;
            if (null != rspBO.getPreInvoice()) {
                invoiceBO = rspBO.getPreInvoice();
            }
            if (null != rspBO.getAfterInvoice()) {
                invoiceBO = rspBO.getAfterInvoice();
            }
            if (null != invoiceBO) {
                invoiceCmpResultBO.setUntaxAmtMargin(invoiceBO.getUntaxAmt());
                invoiceCmpResultBO.setTaxMargin(invoiceBO.getTaxAmt());
                invoiceCmpResultBO.setAmountMargin(invoiceBO.getAmt());
            }
        } else {
            StringBuilder cmpResultStr = new StringBuilder();
            cmpResultStr.append(this.checkParam(rspBO.getPreInvoice().getBuyName(), rspBO.getAfterInvoice().getBuyName()));
            cmpResultStr.append(this.checkParam(rspBO.getPreInvoice().getTaxNo(), rspBO.getAfterInvoice().getTaxNo()));
            cmpResultStr.append(this.checkParam(rspBO.getPreInvoice().getAddress(), rspBO.getAfterInvoice().getAddress()));
            cmpResultStr.append(this.checkParam(rspBO.getPreInvoice().getPhone(), rspBO.getAfterInvoice().getPhone()));
            cmpResultStr.append(this.checkParam(rspBO.getPreInvoice().getBank(), rspBO.getAfterInvoice().getBank()));
            cmpResultStr.append(this.checkParam(rspBO.getPreInvoice().getAccount(), rspBO.getAfterInvoice().getAccount()));
            cmpResultStr.append(this.checkParam(rspBO.getPreInvoice().getAmt(), rspBO.getAfterInvoice().getAmt()));
            invoiceCmpResultBO.setCmpResultStr(cmpResultStr.toString());
            BigDecimal preAmt = null == rspBO.getPreInvoice().getAmt() ? BigDecimal.ZERO : rspBO.getPreInvoice().getAmt();
            BigDecimal afterAmt = null == rspBO.getAfterInvoice().getAmt() ? BigDecimal.ZERO : rspBO.getAfterInvoice().getAmt();
            invoiceCmpResultBO.setAmountMargin(this.subtract(preAmt, afterAmt));
        }
        rspBO.setInvoiceCmpResult(invoiceCmpResultBO);
    }

    private int checkParam(Object param1, Object param2) {
        int isMatch = DycActivityConstants.FscInvoiceVerifyResult.NO;
        if (param1 instanceof String) {
            String pstr1 = (String)param1;
            String pstr2 = (String)param2;
            if (StringUtils.isBlank((CharSequence)pstr1) && StringUtils.isBlank((CharSequence)pstr2)) {
                isMatch = DycActivityConstants.FscInvoiceVerifyResult.YES;
            }
            if (!StringUtils.isBlank((CharSequence)pstr1) && !StringUtils.isBlank((CharSequence)pstr2) && param1.equals(param2)) {
                isMatch = DycActivityConstants.FscInvoiceVerifyResult.YES;
            }
        }
        if (param1 instanceof BigDecimal) {
            BigDecimal bstr1 = (BigDecimal)param1;
            BigDecimal bstr2 = (BigDecimal)param2;
            if (null != bstr1 && null != bstr2 && bstr1.compareTo(bstr2) == 0) {
                isMatch = DycActivityConstants.FscInvoiceVerifyResult.YES;
            }
        }
        return isMatch;
    }

    private BigDecimal subtract(BigDecimal minuend, BigDecimal subtrahend) {
        BigDecimal result = minuend.subtract(subtrahend);
        if (result.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return result.abs();
    }
}

