/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.service.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.api.DycActFscOrderModel;
import com.tydic.dyc.act.model.bo.DycActFscOrderBatchInfoDO;
import com.tydic.dyc.act.model.bo.DycActFscOrderDO;
import com.tydic.dyc.act.model.bo.DycActFscOrderQryDO;
import com.tydic.dyc.act.model.bo.DycActFscOrderRelationDO;
import com.tydic.dyc.act.model.bo.DycActFscOrderRelationInfo;
import com.tydic.dyc.act.service.api.DycActFscOrderSubmitInvoiceSplitService;
import com.tydic.dyc.act.service.bo.DycActFscDealOrderSubmitInvoiceResultRspBO;
import com.tydic.dyc.act.service.bo.DycActFscOrderBatchInfoBO;
import com.tydic.dyc.act.service.bo.DycActFscOrderSubmitInvoiceSplitReqBO;
import com.tydic.dyc.act.service.bo.DycActFscOrderSubmitInvoiceSplitRspBO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.utils.JUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ACT_GROUP_DEV/3.2.1/com.tydic.dyc.act.service.api.DycActFscOrderSubmitInvoiceSplitService"})
public class DycActFscOrderSubmitInvoiceSplitServiceImpl
implements DycActFscOrderSubmitInvoiceSplitService {
    private static final Logger log = LoggerFactory.getLogger(DycActFscOrderSubmitInvoiceSplitServiceImpl.class);
    @Value(value="${ACT_FSC_ORDER_SPLIT_NUM:300}")
    private int splitNum;
    @Autowired
    private DycActFscOrderModel dycActFscOrderModel;

    @PostMapping(value={"dealfscOrderSplit"})
    public DycActFscOrderSubmitInvoiceSplitRspBO dealfscOrderSplit(@RequestBody DycActFscOrderSubmitInvoiceSplitReqBO reqBO) {
        DycActFscOrderDO dycActFscOrderDO = new DycActFscOrderDO();
        dycActFscOrderDO.setFscOrderId(reqBO.getFscOrderId());
        int orderNum = this.dycActFscOrderModel.getFscOrderNum(dycActFscOrderDO);
        int totalBatch = orderNum % this.splitNum == 0 ? orderNum / this.splitNum : orderNum / this.splitNum + 1;
        log.info("totalBatch=====================:{}", (Object)totalBatch);
        ArrayList<Object> batchInfoList = new ArrayList<Object>();
        int batchId = 0;
        do {
            log.info("\u5f53\u524dbatchId={}", (Object)(++batchId));
            DycActFscOrderQryDO dycActFscOrderQryDO = new DycActFscOrderQryDO();
            dycActFscOrderQryDO.setFscOrderId(reqBO.getFscOrderId());
            dycActFscOrderQryDO.setPageNo(batchId);
            dycActFscOrderQryDO.setPageSize(this.splitNum);
            BasePageRspBo<DycActFscOrderRelationInfo> dycActFscOrderRelationInfoBasePageRspBo = this.dycActFscOrderModel.getFscOrderRelationList(dycActFscOrderQryDO);
            if (CollectionUtils.isEmpty((Collection)dycActFscOrderRelationInfoBasePageRspBo.getRows())) break;
            DycActFscOrderRelationDO dycActFscOrderRelationDO = new DycActFscOrderRelationDO();
            dycActFscOrderRelationDO.setFscOrderId(reqBO.getFscOrderId());
            dycActFscOrderRelationDO.setBatchId(batchId);
            dycActFscOrderRelationDO.setOrderIds(dycActFscOrderRelationInfoBasePageRspBo.getRows().stream().map(DycActFscOrderRelationInfo::getOrderId).collect(Collectors.toList()));
            this.dycActFscOrderModel.updateRelationBatch(dycActFscOrderRelationDO);
            DycActFscOrderBatchInfoDO dycActFscOrderBatchInfoDO = new DycActFscOrderBatchInfoDO();
            dycActFscOrderBatchInfoDO.setId(Sequence.getInstance().nextId());
            dycActFscOrderBatchInfoDO.setTotalBatch(totalBatch);
            dycActFscOrderBatchInfoDO.setFscOrderId(reqBO.getFscOrderId());
            dycActFscOrderBatchInfoDO.setPushResult(DycActivityConstants.PushResult.UN_PUSH);
            dycActFscOrderBatchInfoDO.setBatchId(batchId);
            dycActFscOrderBatchInfoDO.setCreateTime(new Date());
            this.dycActFscOrderModel.saveBatchInfo(dycActFscOrderBatchInfoDO);
            batchInfoList.add(JUtil.js((Object)dycActFscOrderBatchInfoDO, DycActFscOrderBatchInfoBO.class));
        } while (batchId != totalBatch);
        DycActFscOrderSubmitInvoiceSplitRspBO rspBO = new DycActFscOrderSubmitInvoiceSplitRspBO();
        rspBO.setBatchInfoList(batchInfoList);
        return rspBO;
    }

    @PostMapping(value={"dealSubmitResult"})
    public DycActFscDealOrderSubmitInvoiceResultRspBO dealSubmitResult(@RequestBody DycActFscOrderSubmitInvoiceSplitReqBO reqBO) {
        DycActFscOrderBatchInfoDO dycActFscOrderBatchInfoDO = (DycActFscOrderBatchInfoDO)JUtil.js((Object)reqBO, DycActFscOrderBatchInfoDO.class);
        dycActFscOrderBatchInfoDO.setPushTime(new Date());
        this.dycActFscOrderModel.updateBatchInfo(dycActFscOrderBatchInfoDO);
        return new DycActFscDealOrderSubmitInvoiceResultRspBO();
    }
}

