/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.service.impl;

import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.api.ActPerformanceRiskControlModel;
import com.tydic.dyc.act.model.bo.ActQryPerformanceRiskControlEmployeeWelfareReqBO;
import com.tydic.dyc.act.model.bo.ActQryPerformanceRiskControlEmployeeWelfareRspBO;
import com.tydic.dyc.act.service.api.DycActQryPerformanceRiskControlEmployeeWelfareService;
import com.tydic.dyc.act.service.bo.DycActQryPerformanceRiskControlEmployeeWelfareReqBO;
import com.tydic.dyc.act.service.bo.DycActQryPerformanceRiskControlEmployeeWelfareRspBO;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.act.utils.DateUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ACT_GROUP_DEV/3.2.1/com.tydic.dyc.act.service.api.DycActQryPerformanceRiskControlEmployeeWelfareService"})
public class DycActQryPerformanceRiskControlEmployeeWelfareServiceImpl
implements DycActQryPerformanceRiskControlEmployeeWelfareService {
    @Autowired
    private ActPerformanceRiskControlModel dycActPerformanceRiskControlModel;

    @PostMapping(value={"qryPerformanceRiskControlEmployeeWelfare"})
    public DycActQryPerformanceRiskControlEmployeeWelfareRspBO qryPerformanceRiskControlEmployeeWelfare(@RequestBody DycActQryPerformanceRiskControlEmployeeWelfareReqBO reqBO) {
        this.checkParam(reqBO);
        DycActQryPerformanceRiskControlEmployeeWelfareRspBO rspBO = new DycActQryPerformanceRiskControlEmployeeWelfareRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (DycActivityConstants.RiskQryRadius.COMPANY.equals(reqBO.getQryRadius())) {
            reqBO.setCompanyIdWeb(reqBO.getCompanyIdWeb());
        } else {
            reqBO.setCompanyIdWeb(null);
        }
        Date date = new Date();
        ActQryPerformanceRiskControlEmployeeWelfareRspBO actQryPerformanceRiskControlEmployeeWelfareRspBO = this.getActQryPerformanceRiskControlEmployeeWelfareRspBO(reqBO, date);
        rspBO.setActCount(actQryPerformanceRiskControlEmployeeWelfareRspBO.getActCount());
        rspBO.setSkuCount(actQryPerformanceRiskControlEmployeeWelfareRspBO.getSkuCount());
        rspBO.setOrderCount(actQryPerformanceRiskControlEmployeeWelfareRspBO.getOrderCount());
        if (DycActivityConstants.RiskControlQryType.WEEK.equals(reqBO.getQryType())) {
            date = DateUtil.getLastWeekTime((Date)date);
        } else if (DycActivityConstants.RiskControlQryType.MONTH.equals(reqBO.getQryType())) {
            date = DateUtil.getLastMonthTime((Date)date);
        } else if (DycActivityConstants.RiskControlQryType.YEAR.equals(reqBO.getQryType())) {
            date = DateUtil.getLastYearTime((Date)date);
        }
        ActQryPerformanceRiskControlEmployeeWelfareRspBO actQryPerformanceRiskControlEmployeeWelfareRspBoLast = this.getActQryPerformanceRiskControlEmployeeWelfareRspBO(reqBO, date);
        rspBO.setPreviousCycleActCount(actQryPerformanceRiskControlEmployeeWelfareRspBoLast.getActCount());
        rspBO.setPreviousCycleSkuCount(actQryPerformanceRiskControlEmployeeWelfareRspBoLast.getSkuCount());
        rspBO.setPreviousCycleOrderCount(actQryPerformanceRiskControlEmployeeWelfareRspBoLast.getOrderCount());
        return rspBO;
    }

    private ActQryPerformanceRiskControlEmployeeWelfareRspBO getActQryPerformanceRiskControlEmployeeWelfareRspBO(DycActQryPerformanceRiskControlEmployeeWelfareReqBO reqBO, Date date) {
        Date qryDateStart = reqBO.getQryDateStart();
        Date qryDateEnd = reqBO.getQryDateEnd();
        if (DycActivityConstants.RiskControlQryType.WEEK.equals(reqBO.getQryType())) {
            qryDateStart = DateUtil.getWeekStartTime((Date)date);
            qryDateEnd = DateUtil.getWeekEndTime((Date)date);
        } else if (DycActivityConstants.RiskControlQryType.MONTH.equals(reqBO.getQryType())) {
            qryDateStart = DateUtil.getMonthStartTime((Date)date);
            qryDateEnd = DateUtil.getMonthEndTime((Date)date);
        } else if (DycActivityConstants.RiskControlQryType.YEAR.equals(reqBO.getQryType())) {
            qryDateStart = DateUtil.getYearStartTime((Date)date);
            qryDateEnd = DateUtil.getYearEndTime((Date)date);
        } else {
            if (qryDateStart == null) {
                throw new BaseBusinessException("200001", "\u5165\u53c2\u6307\u5b9a\u65f6\u95f4\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (qryDateEnd == null) {
                throw new BaseBusinessException("200001", "\u5165\u53c2\u6307\u5b9a\u65f6\u95f4\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        ActQryPerformanceRiskControlEmployeeWelfareReqBO qryDo = (ActQryPerformanceRiskControlEmployeeWelfareReqBO)((Object)ActRu.js((Object)reqBO, ActQryPerformanceRiskControlEmployeeWelfareReqBO.class));
        qryDo.setQryDateStart(qryDateStart);
        qryDo.setQryDateEnd(qryDateEnd);
        ActQryPerformanceRiskControlEmployeeWelfareRspBO actQryPerformanceRiskControlEmployeeWelfareRspBO = this.dycActPerformanceRiskControlModel.qryPerformanceRiskControlEmployeeWelfare(qryDo);
        return actQryPerformanceRiskControlEmployeeWelfareRspBO;
    }

    private void checkParam(DycActQryPerformanceRiskControlEmployeeWelfareReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getQryType() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u3010\u67e5\u8be2\u7c7b\u578b\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getQryRadius() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u3010\u67e5\u8be2\u8303\u56f4\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

