/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.ActConstants;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.api.DycActSkuInfoModel;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.ActActivityChangeCommodityInfoQryDO;
import com.tydic.dyc.act.model.bo.ActSkuInfoDO;
import com.tydic.dyc.act.model.bo.ActSkuInfoQryBO;
import com.tydic.dyc.act.model.bo.ActSkuInfoQryRspBO;
import com.tydic.dyc.act.model.bo.ActivityChangeRelaCommodityInfo;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.model.bo.DycActivityChangeRelaCommodityCatalogInfo;
import com.tydic.dyc.act.model.bo.DycActivityChangeRspDO;
import com.tydic.dyc.act.service.api.DycActQueryActivityChangeCommodityCatalogInComPageListService;
import com.tydic.dyc.act.service.bo.ActivityChangeRelaCommodityInfoBO;
import com.tydic.dyc.act.service.bo.DycActQueryActivityChangeCommodityPageListReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryActivityChangeCommodityPageListRspBO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ACT_GROUP_DEV/3.2.1/com.tydic.dyc.act.service.api.DycActQueryActivityChangeCommodityCatalogInComPageListService"})
public class DycActQueryActivityChangeCommodityCatalogInComPageListServiceImpl
implements DycActQueryActivityChangeCommodityCatalogInComPageListService {
    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;
    @Autowired
    private DycActSkuInfoModel dycActSkuInfoModel;

    @PostMapping(value={"queryActivityChangeCommodityCatalogInComPageList"})
    public DycActQueryActivityChangeCommodityPageListRspBO queryActivityChangeCommodityCatalogInComPageList(@RequestBody DycActQueryActivityChangeCommodityPageListReqBO reqBo) {
        if (reqBo.getChangeId() == null) {
            throw new ZTBusinessException("\u53d8\u66f4\u5355id\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        DycActQueryActivityChangeCommodityPageListRspBO rspBO = new DycActQueryActivityChangeCommodityPageListRspBO();
        DycActivityChangeDO aDo = new DycActivityChangeDO();
        aDo.setChangeId(reqBo.getChangeId());
        DycActivityChangeRspDO dycActivityChangeRspDo = this.dycActivityChangeModel.queryActivityChangeBaseInfo(aDo);
        if ("2".equals(dycActivityChangeRspDo.getChangeBaseDetail().getChangeState())) {
            ActActivityChangeCommodityInfoQryDO qryDo = (ActActivityChangeCommodityInfoQryDO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBo), ActActivityChangeCommodityInfoQryDO.class));
            BasePageRspBo<ActivityChangeRelaCommodityInfo> dycActivityChangeRelaCommodityInfoBasePageRspBo = this.dycActivityChangeModel.queryActivityChangeCommodityCatalogInComPageList(qryDo);
            rspBO = (DycActQueryActivityChangeCommodityPageListRspBO)JSON.parseObject((String)JSON.toJSONString(dycActivityChangeRelaCommodityInfoBasePageRspBo), DycActQueryActivityChangeCommodityPageListRspBO.class);
        } else {
            DycActivityChangeDO queryBO = new DycActivityChangeDO();
            queryBO.setChangeId(reqBo.getChangeId());
            List<DycActivityChangeRelaCommodityCatalogInfo> changeRelaCommodityCatalogInfos = this.dycActivityChangeModel.getListCatalog(queryBO);
            if (!CollectionUtils.isEmpty(changeRelaCommodityCatalogInfos)) {
                List<Long> collect = changeRelaCommodityCatalogInfos.stream().map(a -> Long.valueOf(a.getThreeCatalogId())).collect(Collectors.toList());
                ActSkuInfoQryBO infoQryBO = this.setInfoQryBO(reqBo, collect);
                ActSkuInfoQryRspBO actSkuInfoQryRspBO = null;
                if (ActConstants.LowPrice.YES.equals(reqBo.getLowPrice())) {
                    infoQryBO.setSortName("a.goodRate");
                    infoQryBO.setSortOrder(reqBo.getFavorableRateOrder());
                    actSkuInfoQryRspBO = this.dycActSkuInfoModel.querySkuPageListByLowestPrice(infoQryBO);
                } else {
                    infoQryBO.setSortName("asi.GOOD_RATE");
                    infoQryBO.setSortOrder(reqBo.getFavorableRateOrder());
                    actSkuInfoQryRspBO = this.dycActSkuInfoModel.querySkuPageList(infoQryBO);
                }
                if (actSkuInfoQryRspBO != null && !CollUtil.isEmpty((Collection)actSkuInfoQryRspBO.getRows())) {
                    ArrayList<ActivityChangeRelaCommodityInfoBO> rows = new ArrayList<ActivityChangeRelaCommodityInfoBO>();
                    for (ActSkuInfoDO actSkuInfo : actSkuInfoQryRspBO.getRows()) {
                        ActivityChangeRelaCommodityInfoBO commodityInfoBO = this.getCommodityInfo(dycActivityChangeRspDo.getChangeBaseDetail().getChangeId(), actSkuInfo);
                        rows.add(commodityInfoBO);
                    }
                    rspBO.setPageNo(actSkuInfoQryRspBO.getPageNo());
                    rspBO.setTotal(actSkuInfoQryRspBO.getTotal());
                    rspBO.setRecordsTotal(actSkuInfoQryRspBO.getRecordsTotal());
                    rspBO.setRows(rows);
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private ActSkuInfoQryBO setInfoQryBO(DycActQueryActivityChangeCommodityPageListReqBO reqBO, List<Long> activityGuideIdList) {
        ActSkuInfoQryBO infoQryBO = new ActSkuInfoQryBO();
        infoQryBO.setPoolId(reqBO.getPoolId());
        infoQryBO.setSkuName(reqBO.getSkuName());
        infoQryBO.setExtSkuId(reqBO.getSkuCode());
        infoQryBO.setBrandName(reqBO.getBrand());
        infoQryBO.setIsAnomalousPrice(1);
        infoQryBO.setIsAnomalousPic(1);
        infoQryBO.setSkuStatusList(Collections.singletonList(1));
        infoQryBO.setQryNotDelFlag(Boolean.TRUE);
        infoQryBO.setAgreementPriceMin(reqBO.getMinPrice());
        infoQryBO.setAgreementPriceMax(reqBO.getMaxPrice());
        infoQryBO.setPageNo(reqBO.getPageNo());
        infoQryBO.setPageSize(reqBO.getPageSize());
        infoQryBO.setActivityGuideIdList(activityGuideIdList);
        this.setGuideCatalogId(reqBO, infoQryBO);
        return infoQryBO;
    }

    private ActivityChangeRelaCommodityInfoBO getCommodityInfo(Long changeId, ActSkuInfoDO actSkuInfo) {
        ActivityChangeRelaCommodityInfoBO commodityInfoBO = new ActivityChangeRelaCommodityInfoBO();
        commodityInfoBO.setChangeId(changeId);
        commodityInfoBO.setSkuId(actSkuInfo.getSkuId());
        commodityInfoBO.setSkuCode(actSkuInfo.getExtSkuId());
        commodityInfoBO.setSkuName(actSkuInfo.getSkuName());
        commodityInfoBO.setSkuDetails(actSkuInfo.getSkuPcDetailUrl());
        commodityInfoBO.setBrand(actSkuInfo.getBrandName());
        commodityInfoBO.setCatalogNameStr(actSkuInfo.getCatalogNameDesc());
        commodityInfoBO.setCommodityPoolName(actSkuInfo.getSkuPools());
        commodityInfoBO.setSkuUrl(actSkuInfo.getPicUrl());
        commodityInfoBO.setCterminalUrl(actSkuInfo.getJdSkuUrl());
        commodityInfoBO.setPrice(actSkuInfo.getAgreementPrice());
        commodityInfoBO.setFirstCatalogId(actSkuInfo.getFirstCatalogId());
        commodityInfoBO.setFirstCatalogName(actSkuInfo.getFirstCatalogName());
        commodityInfoBO.setSecondCatalogId(actSkuInfo.getSecondCatalogId());
        commodityInfoBO.setSecondCatalogName(actSkuInfo.getSecondCatalogName());
        commodityInfoBO.setThreeCatalogId(actSkuInfo.getThreeCatalogId());
        commodityInfoBO.setThreeCatalogName(actSkuInfo.getThreeCatalogName());
        commodityInfoBO.setFavorableRate(Double.valueOf(actSkuInfo.getGoodRate().doubleValue()));
        if (commodityInfoBO.getFavorableRate() != null) {
            if (commodityInfoBO.getFavorableRate() % (double)commodityInfoBO.getFavorableRate().intValue() == 0.0) {
                commodityInfoBO.setFavorableRateStr(commodityInfoBO.getFavorableRate().intValue() + "%");
            } else {
                commodityInfoBO.setFavorableRateStr(commodityInfoBO.getFavorableRate() + "%");
            }
        } else {
            commodityInfoBO.setFavorableRateStr("-");
        }
        return commodityInfoBO;
    }

    private void setGuideCatalogId(DycActQueryActivityChangeCommodityPageListReqBO reqBO, ActSkuInfoQryBO infoQryBO) {
        if (ObjectUtil.isNotEmpty((Object)reqBO.getThreeCatalogId())) {
            infoQryBO.setGuideCatalogId(Long.valueOf(reqBO.getThreeCatalogId()));
            infoQryBO.setCatalogLevel(DycActivityConstants.CatalogLevel.THREE);
            return;
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getSecondCatalogId())) {
            infoQryBO.setGuideCatalogId(Long.valueOf(reqBO.getSecondCatalogId()));
            infoQryBO.setCatalogLevel(DycActivityConstants.CatalogLevel.TWO);
            return;
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getFirstCatalogId())) {
            infoQryBO.setGuideCatalogId(Long.valueOf(reqBO.getFirstCatalogId()));
            infoQryBO.setCatalogLevel(DycActivityConstants.CatalogLevel.ONE);
        }
    }
}

