/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.ActConstants;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.api.DycActSkuInfoModel;
import com.tydic.dyc.act.model.bo.ActSkuInfoDO;
import com.tydic.dyc.act.model.bo.ActSkuInfoQryBO;
import com.tydic.dyc.act.model.bo.ActSkuInfoQryRspBO;
import com.tydic.dyc.act.model.bo.DycActiveCommodityCatalogInfo;
import com.tydic.dyc.act.model.bo.DycActiveCommodityCatalogQueryBO;
import com.tydic.dyc.act.model.bo.DycActivityBaseInfo;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActQueryActivityCommodityCatalogInComPageListService;
import com.tydic.dyc.act.service.bo.DycActActivityCommodityInfoBO;
import com.tydic.dyc.act.service.bo.DycActQueryActivityCommodityPageListReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryActivityCommodityPageListRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ACT_GROUP_DEV/3.2.1/com.tydic.dyc.act.service.api.DycActQueryActivityCommodityCatalogInComPageListService"})
public class DycActQueryActivityCommodityCatalogInComPageListServiceImpl
implements DycActQueryActivityCommodityCatalogInComPageListService {
    @Autowired
    private DycActActivityModel dycActActivityModel;
    @Autowired
    private DycActSkuInfoModel dycActSkuInfoModel;

    @PostMapping(value={"queryActivityCommodityCatalogInComPageList"})
    public DycActQueryActivityCommodityPageListRspBO queryActivityCommodityCatalogInComPageList(@RequestBody DycActQueryActivityCommodityPageListReqBO reqBO) {
        if (reqBO.getActivityId() == null) {
            throw new ZTBusinessException("\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        DycActQueryActivityCommodityPageListRspBO rspBO = new DycActQueryActivityCommodityPageListRspBO();
        DycActivityDO aDo = new DycActivityDO();
        aDo.setActivityId(reqBO.getActivityId());
        List<DycActivityBaseInfo> dycActivityBaseInfos = this.dycActActivityModel.queryActivityList(aDo);
        if (DycActivityConstants.ActivitySyncState.SUCCESS.equals(dycActivityBaseInfos.get(0).getActivitySyncState()) || DycActivityConstants.ActivitySyncState.PART_SUCCESS.equals(dycActivityBaseInfos.get(0).getActivitySyncState())) {
            DycActivityDO dycActivityDO = (DycActivityDO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), DycActivityDO.class);
            rspBO = (DycActQueryActivityCommodityPageListRspBO)JSON.parseObject((String)JSON.toJSONString(this.dycActActivityModel.queryActivityCommodityCatalogInComPageList(dycActivityDO)), DycActQueryActivityCommodityPageListRspBO.class);
        } else {
            DycActiveCommodityCatalogQueryBO queryBO = new DycActiveCommodityCatalogQueryBO();
            queryBO.setActivityId(reqBO.getActivityId());
            List<DycActiveCommodityCatalogInfo> dycActiveCommodityCatalogInfos = this.dycActActivityModel.queryActiveCommodityCatalogAllList(queryBO);
            if (!CollectionUtils.isEmpty(dycActiveCommodityCatalogInfos)) {
                List<Long> collect = dycActiveCommodityCatalogInfos.stream().map(a -> Long.valueOf(a.getThreeCatalogId())).collect(Collectors.toList());
                ActSkuInfoQryBO infoQryBO = this.setInfoQryBO(reqBO, collect);
                ActSkuInfoQryRspBO actSkuInfoQryRspBO = null;
                if (ActConstants.LowPrice.YES.equals(reqBO.getLowPrice())) {
                    infoQryBO.setSortName("a.goodRate");
                    infoQryBO.setSortOrder(reqBO.getFavorableRateOrder());
                    actSkuInfoQryRspBO = this.dycActSkuInfoModel.querySkuPageListByLowestPrice(infoQryBO);
                } else {
                    infoQryBO.setSortName("asi.GOOD_RATE");
                    infoQryBO.setSortOrder(reqBO.getFavorableRateOrder());
                    actSkuInfoQryRspBO = this.dycActSkuInfoModel.querySkuPageList(infoQryBO);
                }
                if (actSkuInfoQryRspBO != null && !CollUtil.isEmpty((Collection)actSkuInfoQryRspBO.getRows())) {
                    ArrayList<DycActActivityCommodityInfoBO> rows = new ArrayList<DycActActivityCommodityInfoBO>();
                    for (ActSkuInfoDO actSkuInfo : actSkuInfoQryRspBO.getRows()) {
                        DycActActivityCommodityInfoBO commodityInfoBO = this.getCommodityInfo(dycActivityBaseInfos, actSkuInfo);
                        rows.add(commodityInfoBO);
                    }
                    rspBO.setPageNo(actSkuInfoQryRspBO.getPageNo());
                    rspBO.setTotal(actSkuInfoQryRspBO.getTotal());
                    rspBO.setRecordsTotal(actSkuInfoQryRspBO.getRecordsTotal());
                    rspBO.setRows(rows);
                }
            }
        }
        return rspBO;
    }

    private ActSkuInfoQryBO setInfoQryBO(DycActQueryActivityCommodityPageListReqBO reqBO, List<Long> collect) {
        ActSkuInfoQryBO infoQryBO = new ActSkuInfoQryBO();
        infoQryBO.setPoolId(reqBO.getPoolId());
        infoQryBO.setSkuName(reqBO.getSkuName());
        infoQryBO.setExtSkuId(reqBO.getSkuCode());
        infoQryBO.setBrandName(reqBO.getBrand());
        infoQryBO.setIsAnomalousPrice(reqBO.getIsAnomalousPrice());
        infoQryBO.setIsAnomalousPic(1);
        infoQryBO.setSkuStatusList(Collections.singletonList(1));
        infoQryBO.setQryNotDelFlag(Boolean.TRUE);
        infoQryBO.setAgreementPriceMin(reqBO.getMinPrice());
        infoQryBO.setAgreementPriceMax(reqBO.getMaxPrice());
        infoQryBO.setPageNo(reqBO.getPageNo());
        infoQryBO.setPageSize(reqBO.getPageSize());
        infoQryBO.setActivityGuideIdList(collect);
        this.setGuideCatalogId(reqBO, infoQryBO);
        return infoQryBO;
    }

    private DycActActivityCommodityInfoBO getCommodityInfo(List<DycActivityBaseInfo> dycActivityBaseInfos, ActSkuInfoDO actSkuInfo) {
        DycActActivityCommodityInfoBO commodityInfoBO = new DycActActivityCommodityInfoBO();
        commodityInfoBO.setActivityId(dycActivityBaseInfos.get(0).getActivityId());
        commodityInfoBO.setSkuId(actSkuInfo.getSkuId());
        commodityInfoBO.setSkuCode(actSkuInfo.getExtSkuId());
        commodityInfoBO.setSkuName(actSkuInfo.getSkuName());
        commodityInfoBO.setSkuDetails(actSkuInfo.getSkuPcDetailUrl());
        commodityInfoBO.setBrand(actSkuInfo.getBrandName());
        commodityInfoBO.setCatalogNameStr(actSkuInfo.getCatalogNameDesc());
        commodityInfoBO.setCommodityPoolName(actSkuInfo.getSkuPools());
        commodityInfoBO.setSkuUrl(actSkuInfo.getPicUrl());
        commodityInfoBO.setSkuStatus(actSkuInfo.getSkuStatus());
        commodityInfoBO.setCterminalUrl(actSkuInfo.getJdSkuUrl());
        commodityInfoBO.setPrice(actSkuInfo.getAgreementPrice());
        commodityInfoBO.setFirstCatalogId(actSkuInfo.getFirstCatalogId());
        commodityInfoBO.setFirstCatalogName(actSkuInfo.getFirstCatalogName());
        commodityInfoBO.setSecondCatalogId(actSkuInfo.getSecondCatalogId());
        commodityInfoBO.setSecondCatalogName(actSkuInfo.getSecondCatalogName());
        commodityInfoBO.setThreeCatalogId(actSkuInfo.getThreeCatalogId());
        commodityInfoBO.setThreeCatalogName(actSkuInfo.getThreeCatalogName());
        commodityInfoBO.setFavorableRate(Double.valueOf(actSkuInfo.getGoodRate().doubleValue()));
        if (commodityInfoBO.getFavorableRate() != null) {
            if (commodityInfoBO.getFavorableRate() % (double)commodityInfoBO.getFavorableRate().intValue() == 0.0) {
                commodityInfoBO.setFavorableRateStr(commodityInfoBO.getFavorableRate().intValue() + "%");
            } else {
                commodityInfoBO.setFavorableRateStr(commodityInfoBO.getFavorableRate() + "%");
            }
        } else {
            commodityInfoBO.setFavorableRateStr("-");
        }
        return commodityInfoBO;
    }

    private void setGuideCatalogId(DycActQueryActivityCommodityPageListReqBO reqBO, ActSkuInfoQryBO infoQryBO) {
        if (ObjectUtil.isNotEmpty((Object)reqBO.getThreeCatalogId())) {
            infoQryBO.setGuideCatalogId(Long.valueOf(reqBO.getThreeCatalogId()));
            infoQryBO.setCatalogLevel(DycActivityConstants.CatalogLevel.THREE);
            return;
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getSecondCatalogId())) {
            infoQryBO.setGuideCatalogId(Long.valueOf(reqBO.getSecondCatalogId()));
            infoQryBO.setCatalogLevel(DycActivityConstants.CatalogLevel.TWO);
            return;
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getFirstCatalogId())) {
            infoQryBO.setGuideCatalogId(Long.valueOf(reqBO.getFirstCatalogId()));
            infoQryBO.setCatalogLevel(DycActivityConstants.CatalogLevel.ONE);
        }
    }
}

