/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.api.DycActSkuInfoModel;
import com.tydic.dyc.act.model.bo.ActJudgeGuideLowestPriceBO;
import com.tydic.dyc.act.model.bo.ActJudgeGuideLowestPriceReqBO;
import com.tydic.dyc.act.model.bo.ActJudgeGuideLowestPriceRspBO;
import com.tydic.dyc.act.model.bo.DycActActivityRelaCommodityInfo;
import com.tydic.dyc.act.model.bo.DycActiveCommodityCatalogInfo;
import com.tydic.dyc.act.model.bo.DycActiveCommodityCatalogQueryBO;
import com.tydic.dyc.act.model.bo.DycActivityBaseInfo;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActQueryActivityCommodityCatalogPageListService;
import com.tydic.dyc.act.service.bo.DycActQueryActivityCommodityCatalogPageListReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryActivityCommodityCatalogPageListRspBO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ACT_GROUP_DEV/3.2.1/com.tydic.dyc.act.service.api.DycActQueryActivityCommodityCatalogPageListService"})
public class DycActQueryActivityCommodityCatalogPageListServiceImpl
implements DycActQueryActivityCommodityCatalogPageListService {
    @Autowired
    private DycActActivityModel dycActActivityModel;
    @Autowired
    private DycActSkuInfoModel dycActSkuInfoModel;

    @PostMapping(value={"queryActivityCommodityCatalogPageList"})
    public DycActQueryActivityCommodityCatalogPageListRspBO queryActivityCommodityCatalogPageList(@RequestBody DycActQueryActivityCommodityCatalogPageListReqBO reqBO) {
        List<String> collect;
        DycActiveCommodityCatalogQueryBO dycActiveCommodityCatalogQueryBO = (DycActiveCommodityCatalogQueryBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), DycActiveCommodityCatalogQueryBO.class));
        BasePageRspBo<DycActiveCommodityCatalogInfo> catalogInfoBasePageRspBo = this.dycActActivityModel.queryActiveCommodityCatalogList(dycActiveCommodityCatalogQueryBO);
        DycActivityDO aDo = new DycActivityDO();
        aDo.setActivityId(reqBO.getActivityId());
        List<DycActivityBaseInfo> dycActivityBaseInfos = this.dycActActivityModel.queryActivityList(aDo);
        if (DycActivityConstants.ActivitySyncState.SUCCESS.equals(dycActivityBaseInfos.get(0).getActivitySyncState()) || DycActivityConstants.ActivitySyncState.PART_SUCCESS.equals(dycActivityBaseInfos.get(0).getActivitySyncState())) {
            if (!CollectionUtils.isEmpty((Collection)catalogInfoBasePageRspBo.getRows())) {
                collect = catalogInfoBasePageRspBo.getRows().stream().map(item -> item.getThreeCatalogId()).collect(Collectors.toList());
                DycActivityDO activityDO = new DycActivityDO();
                activityDO.setActivityId(reqBO.getActivityId());
                activityDO.setThreeCatalogIds(collect);
                List<DycActActivityRelaCommodityInfo> comCount = this.dycActActivityModel.getComCount(activityDO);
                if (!CollectionUtils.isEmpty(comCount)) {
                    Map<String, Integer> integerMap = comCount.stream().collect(Collectors.toMap(DycActActivityRelaCommodityInfo::getThreeCatalogId, DycActActivityRelaCommodityInfo::getComCount));
                    catalogInfoBasePageRspBo.getRows().forEach(item -> {
                        if (null == integerMap.get(item.getThreeCatalogId())) {
                            item.setTotalCommodity(0);
                        } else {
                            item.setTotalCommodity((Integer)integerMap.get(item.getThreeCatalogId()));
                        }
                    });
                }
            }
        } else if (!CollectionUtils.isEmpty((Collection)catalogInfoBasePageRspBo.getRows())) {
            collect = catalogInfoBasePageRspBo.getRows().stream().map(item -> Long.valueOf(item.getThreeCatalogId())).collect(Collectors.toList());
            ActJudgeGuideLowestPriceReqBO lowestPriceReqBO = new ActJudgeGuideLowestPriceReqBO();
            lowestPriceReqBO.setIsAnomalousPrice(reqBO.getIsAnomalousPrice());
            lowestPriceReqBO.setAgreementPriceMin(reqBO.getAgreementPriceMin());
            lowestPriceReqBO.setAgreementPriceMax(reqBO.getAgreementPriceMax());
            lowestPriceReqBO.setLowPrice(reqBO.getLowPrice());
            lowestPriceReqBO.setGuideIds(collect);
            ActJudgeGuideLowestPriceRspBO priceRspBO = this.dycActSkuInfoModel.queryGuideToNumMap(lowestPriceReqBO);
            if (!ObjectUtil.isEmpty((Object)((Object)priceRspBO)) && !CollectionUtils.isEmpty(priceRspBO.getResult())) {
                Map<Long, Integer> integerMap = priceRspBO.getResult().stream().collect(Collectors.toMap(ActJudgeGuideLowestPriceBO::getGuideId, ActJudgeGuideLowestPriceBO::getSkuCount));
                catalogInfoBasePageRspBo.getRows().forEach(item -> item.setTotalCommodity((Integer)integerMap.get(Long.valueOf(item.getThreeCatalogId()))));
            }
        }
        DycActQueryActivityCommodityCatalogPageListRspBO rspBO = (DycActQueryActivityCommodityCatalogPageListRspBO)JSON.parseObject((String)JSON.toJSONString(catalogInfoBasePageRspBo), DycActQueryActivityCommodityCatalogPageListRspBO.class);
        return rspBO;
    }
}

