/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.api.DycActSkuInfoModel;
import com.tydic.dyc.act.model.bo.ActSkuGuideBO;
import com.tydic.dyc.act.model.bo.ActSkuGuideReqBO;
import com.tydic.dyc.act.model.bo.ActSkuInfoReqBO;
import com.tydic.dyc.act.model.bo.ActSkuInfoRspBO;
import com.tydic.dyc.act.model.bo.ActSkuPicBO;
import com.tydic.dyc.act.model.bo.ActSkuPicReqBO;
import com.tydic.dyc.act.model.bo.ActSkuSpecBO;
import com.tydic.dyc.act.model.bo.ActSkuSpecReqBO;
import com.tydic.dyc.act.service.api.DycActQuerySkuDetailsService;
import com.tydic.dyc.act.service.bo.DycActQuerySkuDetailsReqBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuDetailsRspBO;
import com.tydic.dyc.act.service.bo.DycActSkuParamsBO;
import com.tydic.dyc.act.service.bo.DycActSkuPicBO;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ACT_GROUP_DEV/3.2.1/com.tydic.dyc.act.service.api.DycActQuerySkuDetailsService"})
public class DycActQuerySkuDetailsServiceImpl
implements DycActQuerySkuDetailsService {
    @Autowired
    private DycActSkuInfoModel dycActSkuInfoModel;

    @PostMapping(value={"querySkuDetails"})
    public DycActQuerySkuDetailsRspBO querySkuDetails(@RequestBody DycActQuerySkuDetailsReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u5546\u54c1\u8be6\u60c5\u67e5\u8be2\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u5546\u54c1\u8be6\u60c5\u67e5\u8be2\u5165\u53c2\u5355\u54c1ID[skuId]\u4e3a\u7a7a");
        }
        DycActQuerySkuDetailsRspBO rspBO = (DycActQuerySkuDetailsRspBO)ActRu.success(DycActQuerySkuDetailsRspBO.class);
        ActSkuInfoReqBO qryBO = new ActSkuInfoReqBO();
        qryBO.setSkuId(reqBO.getSkuId());
        ActSkuInfoRspBO skuInfoRspBO = this.dycActSkuInfoModel.querySkuDetails(qryBO);
        if (ObjectUtil.isEmpty((Object)skuInfoRspBO.getData())) {
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBO;
        }
        rspBO = (DycActQuerySkuDetailsRspBO)ActRu.js((Object)skuInfoRspBO.getData(), DycActQuerySkuDetailsRspBO.class);
        if (DycActivityConstants.SkuStatue.ON_SALE.equals(rspBO.getSkuStatus())) {
            rspBO.setSkuStatusDesc("\u5df2\u4e0a\u67b6");
        } else if (DycActivityConstants.SkuStatue.WITHDRAWN.equals(rspBO.getSkuStatus())) {
            rspBO.setSkuStatusDesc("\u5df2\u4e0b\u67b6");
        } else if (DycActivityConstants.SkuStatue.DELETE.equals(rspBO.getSkuStatus())) {
            rspBO.setSkuStatusDesc("\u5df2\u5220\u9664");
        }
        ActSkuPicReqBO skuPicReqBO = new ActSkuPicReqBO();
        skuPicReqBO.setSkuId(reqBO.getSkuId());
        List<ActSkuPicBO> skuPicBOList = this.dycActSkuInfoModel.queryActSkuPicList(skuPicReqBO).getData();
        if (CollectionUtil.isNotEmpty(skuPicBOList)) {
            List skuPicList = skuPicBOList.stream().map(picBO -> {
                DycActSkuPicBO skuPicBO = new DycActSkuPicBO();
                skuPicBO.setPicType(picBO.getPicType());
                skuPicBO.setPicUrl(picBO.getSkuPicUrl());
                skuPicBO.setPicOrder(picBO.getPicOrder());
                return skuPicBO;
            }).collect(Collectors.toList());
            rspBO.setSkuPicList(skuPicList);
        }
        ActSkuSpecReqBO specReqBO = new ActSkuSpecReqBO();
        specReqBO.setSkuId(reqBO.getSkuId());
        List<ActSkuSpecBO> skuSpecBOList = this.dycActSkuInfoModel.queryActSkuSpecList(specReqBO).getData();
        if (CollectionUtil.isNotEmpty(skuSpecBOList)) {
            List skuParamList = skuSpecBOList.stream().map(specBO -> {
                DycActSkuParamsBO paramsBO = new DycActSkuParamsBO();
                paramsBO.setPropName(specBO.getPropName());
                paramsBO.setPropValue(specBO.getPropValue());
                return paramsBO;
            }).collect(Collectors.toList());
            rspBO.setSkuParamList(skuParamList);
        }
        ActSkuGuideReqBO guideReqBO = new ActSkuGuideReqBO();
        guideReqBO.setGuideCatalogIdList(Collections.singletonList(skuInfoRspBO.getData().getGuideId()));
        Map<Long, ActSkuGuideBO> fullNameByCatalogIdMap = this.dycActSkuInfoModel.getCatalogBOByCatalogIds(guideReqBO).getCatalogBOByCatalogIds();
        if (fullNameByCatalogIdMap.containsKey(skuInfoRspBO.getData().getGuideId())) {
            rspBO.setCatalogNameDesc(fullNameByCatalogIdMap.get(skuInfoRspBO.getData().getGuideId()).getCatalogFullName());
        }
        return rspBO;
    }
}

