/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.api.DycActSkuInfoModel;
import com.tydic.dyc.act.model.api.DycActSkuPoolModel;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.ActActivityChangeCommodityInfoQryDO;
import com.tydic.dyc.act.model.bo.ActRelSourcePoolBO;
import com.tydic.dyc.act.model.bo.ActRelSourcePoolReqBO;
import com.tydic.dyc.act.model.bo.ActSkuGuideBO;
import com.tydic.dyc.act.model.bo.ActSkuGuideReqBO;
import com.tydic.dyc.act.model.bo.ActSkuInfoQryBO;
import com.tydic.dyc.act.model.bo.ActSkuInfoQryRspBO;
import com.tydic.dyc.act.model.bo.ActSkuPicBO;
import com.tydic.dyc.act.model.bo.ActSkuPicReqBO;
import com.tydic.dyc.act.model.bo.ActSkuSpecBO;
import com.tydic.dyc.act.model.bo.ActSkuSpecReqBO;
import com.tydic.dyc.act.model.bo.ActivityChangeRelaCommodityInfo;
import com.tydic.dyc.act.model.bo.DycActActivityRelaCommodityInfo;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActQuerySkuPageListService;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPageListBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPageListReqBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPageListRspBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPoolReqBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPoolRspBO;
import com.tydic.dyc.act.service.bo.DycActSkuParamsBO;
import com.tydic.dyc.act.service.bo.DycActSkuPicBO;
import com.tydic.dyc.act.utils.ActRu;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ACT_GROUP_DEV/3.2.1/com.tydic.dyc.act.service.api.DycActQuerySkuPageListService"})
public class DycActQuerySkuPageListServiceImpl
implements DycActQuerySkuPageListService {
    @Autowired
    private DycActSkuInfoModel dycActSkuInfoModel;
    @Autowired
    private DycActActivityModel dycActActivityModel;
    @Autowired
    private DycActSkuPoolModel dycActSkuPoolModel;
    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;

    @PostMapping(value={"querySkuPageList"})
    public DycActQuerySkuPageListRspBO querySkuPageList(@RequestBody DycActQuerySkuPageListReqBO reqBO) {
        List<Serializable> commodityInfoList;
        DycActQuerySkuPageListRspBO rspBO = (DycActQuerySkuPageListRspBO)ActRu.success(DycActQuerySkuPageListRspBO.class);
        ActSkuInfoQryBO qryBO = (ActSkuInfoQryBO)((Object)ActRu.js((Object)reqBO, ActSkuInfoQryBO.class));
        if (ObjectUtil.isNotEmpty((Object)reqBO.getGuideCatalogId()) && ObjectUtil.isEmpty((Object)reqBO.getCatalogLevel())) {
            throw new ZTBusinessException("\u5546\u54c1\u7c7b\u76eeID\u548c\u5546\u54c1\u7c7b\u76ee\u7b49\u7ea7\u5fc5\u987b\u4e00\u8d77\u4f20");
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getExitsActivityId())) {
            DycActivityDO activityDO = new DycActivityDO();
            activityDO.setActivityId(reqBO.getExitsActivityId());
            activityDO.setCommodityRelaMethod(Integer.valueOf("3"));
            commodityInfoList = this.dycActActivityModel.queryActivityCommodityList(activityDO);
            if (!CollectionUtil.isEmpty(commodityInfoList)) {
                qryBO.setExitsSkuIds(commodityInfoList.stream().map(DycActActivityRelaCommodityInfo::getSkuId).collect(Collectors.toList()));
            }
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getExitsChangeId())) {
            ActActivityChangeCommodityInfoQryDO qryDO = new ActActivityChangeCommodityInfoQryDO();
            qryDO.setChangeId(reqBO.getExitsChangeId());
            commodityInfoList = this.dycActivityChangeModel.queryActivityChangeCommodityList(qryDO);
            if (!CollectionUtil.isEmpty(commodityInfoList)) {
                qryBO.setExitsSkuIds(commodityInfoList.stream().map(ActivityChangeRelaCommodityInfo::getSkuId).collect(Collectors.toList()));
            }
        }
        ActSkuInfoQryRspBO qryRspBO = this.dycActSkuInfoModel.querySkuPageList(qryBO);
        rspBO.setPageNo(qryRspBO.getPageNo());
        rspBO.setTotal(qryRspBO.getTotal());
        rspBO.setRecordsTotal(qryRspBO.getRecordsTotal());
        if (CollectionUtil.isEmpty((Collection)qryRspBO.getRows())) {
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBO;
        }
        List rows = ActRu.jsl((List)qryRspBO.getRows(), DycActQuerySkuPageListBO.class);
        if (reqBO.getQrySkuSpecPic().booleanValue()) {
            for (DycActQuerySkuPageListBO row : rows) {
                ActSkuPicReqBO skuPicReqBO = new ActSkuPicReqBO();
                skuPicReqBO.setSkuId(row.getSkuId());
                List<ActSkuPicBO> skuPicBOList = this.dycActSkuInfoModel.queryActSkuPicList(skuPicReqBO).getData();
                if (CollectionUtil.isNotEmpty(skuPicBOList)) {
                    List skuPicList = skuPicBOList.stream().map(picBO -> {
                        DycActSkuPicBO skuPicBO = new DycActSkuPicBO();
                        skuPicBO.setPicId(picBO.getPicId());
                        skuPicBO.setPicType(picBO.getPicType());
                        skuPicBO.setPicUrl(picBO.getSkuPicUrl());
                        skuPicBO.setPicOrder(picBO.getPicOrder());
                        return skuPicBO;
                    }).collect(Collectors.toList());
                    row.setSkuPicList(skuPicList);
                }
                ActSkuSpecReqBO specReqBO = new ActSkuSpecReqBO();
                specReqBO.setSkuId(row.getSkuId());
                List<ActSkuSpecBO> skuSpecBOList = this.dycActSkuInfoModel.queryActSkuSpecList(specReqBO).getData();
                if (!CollectionUtil.isNotEmpty(skuSpecBOList)) continue;
                List skuParamList = skuSpecBOList.stream().map(specBO -> {
                    DycActSkuParamsBO paramsBO = new DycActSkuParamsBO();
                    paramsBO.setPropName(specBO.getPropName());
                    paramsBO.setPropValue(specBO.getPropValue());
                    return paramsBO;
                }).collect(Collectors.toList());
                row.setSkuParamList(skuParamList);
            }
        }
        rspBO.setRows(rows);
        return rspBO;
    }

    private void setPoolRelReqQuery(Long poolId, ActSkuInfoQryBO qryBO, Integer relType) {
        DycActQuerySkuPoolReqBO skuPoolReqBO = new DycActQuerySkuPoolReqBO();
        skuPoolReqBO.setPoolId(poolId);
        DycActQuerySkuPoolRspBO skuPoolRspBO = this.dycActSkuPoolModel.querySkuPoolDetail(skuPoolReqBO);
        if (ObjectUtil.isEmpty((Object)skuPoolRspBO)) {
            throw new ZTBusinessException("\u5546\u54c1\u6c60\u4e0d\u5b58\u5728");
        }
        ActRelSourcePoolReqBO relSourcePoolReqBO = new ActRelSourcePoolReqBO();
        relSourcePoolReqBO.setPoolId(poolId);
        List<ActRelSourcePoolBO> relSourcePoolBOS = this.dycActSkuPoolModel.queryActRelSourcePoolList(relSourcePoolReqBO).getData();
        if (!CollectionUtil.isEmpty(relSourcePoolBOS)) {
            List<Long> sourceIds = relSourcePoolBOS.stream().map(ActRelSourcePoolBO::getSourceId).collect(Collectors.toList());
            if (DycActivityConstants.RelPoolOperType.REL.equals(relType)) {
                if (DycActivityConstants.PoolType.SUPPLIER.equals(skuPoolRspBO.getPoolType())) {
                    qryBO.setPoolSupplierIdList(sourceIds);
                    qryBO.setPoolId(null);
                } else if (DycActivityConstants.PoolType.CATALOG.equals(skuPoolRspBO.getPoolType())) {
                    qryBO.setPoolGuideIdList(sourceIds);
                    qryBO.setPoolId(null);
                }
            } else if (DycActivityConstants.PoolType.SUPPLIER.equals(skuPoolRspBO.getPoolType())) {
                qryBO.setExitsPoolSupplierIdList(sourceIds);
                qryBO.setExitsPoolId(null);
            } else if (DycActivityConstants.PoolType.CATALOG.equals(skuPoolRspBO.getPoolType())) {
                qryBO.setExitsPoolGuideIdList(sourceIds);
                qryBO.setExitsPoolId(null);
            }
        }
    }

    private List<Long> qryGuideIdList(Long guideCatalogId) {
        ActSkuGuideReqBO qrySubGuideBO = new ActSkuGuideReqBO();
        qrySubGuideBO.setUpperCatalogId(guideCatalogId);
        List<ActSkuGuideBO> list = this.dycActSkuInfoModel.queryActSkuGuideList(qrySubGuideBO).getData();
        if (!CollectionUtil.isEmpty(list)) {
            return list.stream().map(ActSkuGuideBO::getGuideCatalogId).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }
}

