/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.bo.RspPage;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.api.DycActSkuInfoModel;
import com.tydic.dyc.act.model.api.DycActSkuPoolModel;
import com.tydic.dyc.act.model.bo.ActRelSourcePoolBO;
import com.tydic.dyc.act.model.bo.ActRelSourcePoolReqBO;
import com.tydic.dyc.act.model.bo.ActSkuGuideBO;
import com.tydic.dyc.act.model.bo.ActSkuGuideReqBO;
import com.tydic.dyc.act.service.api.DycActQuerySkuPoolRelPageListService;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPoolRelPageListBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPoolRelPageListReqBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPoolRelPageListRspBO;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ACT_GROUP_DEV/3.2.1/com.tydic.dyc.act.service.api.DycActQuerySkuPoolRelPageListService"})
public class DycActQuerySkuPoolRelPageListServiceImpl
implements DycActQuerySkuPoolRelPageListService {
    @Autowired
    private DycActSkuPoolModel dycActSkuPoolModel;
    @Autowired
    private DycActSkuInfoModel dycActSkuInfoModel;

    @PostMapping(value={"querySkuPoolRelPageList"})
    public DycActQuerySkuPoolRelPageListRspBO querySkuPoolRelPageList(@RequestBody DycActQuerySkuPoolRelPageListReqBO reqBO) {
        ActRelSourcePoolReqBO sourcePoolReqBO;
        this.valData(reqBO);
        DycActQuerySkuPoolRelPageListRspBO rspBO = (DycActQuerySkuPoolRelPageListRspBO)ActRu.success(DycActQuerySkuPoolRelPageListRspBO.class);
        RspPage<ActRelSourcePoolBO> rspPage = new RspPage<ActRelSourcePoolBO>();
        if (DycActivityConstants.PoolType.SUPPLIER.equals(reqBO.getPoolType())) {
            sourcePoolReqBO = new ActRelSourcePoolReqBO();
            sourcePoolReqBO.setPageNo(reqBO.getPageNo());
            sourcePoolReqBO.setPageSize(reqBO.getPageSize());
            sourcePoolReqBO.setPoolId(reqBO.getPoolId());
            sourcePoolReqBO.setSourceId(reqBO.getVendorId());
            sourcePoolReqBO.setPoolType(reqBO.getPoolType());
            rspPage = this.dycActSkuPoolModel.querySkuPoolRelPageListBySup(sourcePoolReqBO);
        }
        if (DycActivityConstants.PoolType.CATALOG.equals(reqBO.getPoolType())) {
            sourcePoolReqBO = new ActRelSourcePoolReqBO();
            sourcePoolReqBO.setPoolId(reqBO.getPoolId());
            sourcePoolReqBO.setPoolType(reqBO.getPoolType());
            sourcePoolReqBO.setPageNo(reqBO.getPageNo());
            sourcePoolReqBO.setPageSize(reqBO.getPageSize());
            if (DycActivityConstants.CatalogLevel.THREE.equals(reqBO.getCatalogLevel())) {
                sourcePoolReqBO.setSourceId(reqBO.getGuideCatalogId());
            } else if (DycActivityConstants.CatalogLevel.TWO.equals(reqBO.getCatalogLevel())) {
                sourcePoolReqBO.setSourceIdList(this.qryGuideIdList(reqBO.getGuideCatalogId()));
            } else if (DycActivityConstants.CatalogLevel.ONE.equals(reqBO.getCatalogLevel())) {
                ArrayList<Long> threeGuideId = new ArrayList<Long>();
                List<Long> twoGuideId = this.qryGuideIdList(reqBO.getGuideCatalogId());
                if (!CollectionUtil.isEmpty(twoGuideId)) {
                    for (Long guideId : twoGuideId) {
                        threeGuideId.addAll(this.qryGuideIdList(guideId));
                    }
                }
                sourcePoolReqBO.setSourceIdList(threeGuideId);
            }
            rspPage = this.dycActSkuPoolModel.querySkuPoolRelPageListByCatalog(sourcePoolReqBO);
        }
        rspBO.setPageNo(rspPage.getPageNo());
        rspBO.setTotal(rspPage.getTotal());
        rspBO.setRecordsTotal(rspPage.getRecordsTotal());
        if (CollectionUtil.isEmpty((Collection)rspPage.getRows())) {
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBO;
        }
        rspBO.setRows(ActRu.jsl((List)rspPage.getRows(), DycActQuerySkuPoolRelPageListBO.class));
        return rspBO;
    }

    private List<Long> qryGuideIdList(Long guideCatalogId) {
        ActSkuGuideReqBO qrySubGuideBO = new ActSkuGuideReqBO();
        qrySubGuideBO.setUpperCatalogId(guideCatalogId);
        List<ActSkuGuideBO> list = this.dycActSkuInfoModel.queryActSkuGuideList(qrySubGuideBO).getData();
        if (!CollectionUtil.isEmpty(list)) {
            return list.stream().map(ActSkuGuideBO::getGuideCatalogId).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }

    private void valData(DycActQuerySkuPoolRelPageListReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u5546\u54c1\u6c60\u5df2\u5173\u8054\u5217\u8868\u67e5\u8be2\uff08\u5206\u9875\uff09\u670d\u52a1\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getPoolId())) {
            throw new BaseBusinessException("200001", "\u5546\u54c1\u6c60\u5df2\u5173\u8054\u5217\u8868\u67e5\u8be2\uff08\u5206\u9875\uff09\u670d\u52a1\u5165\u53c2\u5546\u54c1\u6c60ID[poolId]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getPoolType())) {
            throw new BaseBusinessException("200001", "\u5546\u54c1\u6c60\u5df2\u5173\u8054\u5217\u8868\u67e5\u8be2\uff08\u5206\u9875\uff09\u670d\u52a1\u5165\u53c2\u5546\u54c1\u6c60\u5173\u8054\u7c7b\u578b[poolType]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getGuideCatalogId()) && ObjectUtil.isEmpty((Object)reqBO.getCatalogLevel())) {
            throw new BaseBusinessException("8888", "\u7c7b\u76eeID\u548c\u7c7b\u76ee\u7b49\u7ea7\u5fc5\u987b\u4e00\u8d77\u4f20");
        }
    }
}

