/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.service.impl;

import com.tydic.dyc.act.model.api.DycActSkuInfoModel;
import com.tydic.dyc.act.model.bo.ActSkuPriceLogBO;
import com.tydic.dyc.act.model.bo.ActSkuPriceLogReqBO;
import com.tydic.dyc.act.service.api.DycActQuerySkuPushInfoService;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPushInfoBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPushInfoReqBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPushInfoRspBO;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ACT_GROUP_DEV/3.2.1/com.tydic.dyc.act.service.api.DycActQuerySkuPushInfoService"})
public class DycActQuerySkuPushInfoServiceImpl
implements DycActQuerySkuPushInfoService {
    @Autowired
    private DycActSkuInfoModel dycActSkuInfoModel;

    @PostMapping(value={"qrySkuPushInfo"})
    public DycActQuerySkuPushInfoRspBO qrySkuPushInfo(@RequestBody DycActQuerySkuPushInfoReqBO reqBO) {
        DycActQuerySkuPushInfoRspBO rspBO = this.dycActSkuInfoModel.qrySkuPushInfo(reqBO);
        if (rspBO.getRows() != null && rspBO.getRows().size() > 0 && reqBO.getQryPrice().booleanValue()) {
            ActSkuPriceLogReqBO priceLogReqBO = new ActSkuPriceLogReqBO();
            priceLogReqBO.setSkuIds(reqBO.getSkuIds());
            List<ActSkuPriceLogBO> priceLogBOS = this.dycActSkuInfoModel.qrySkuPriceLog(priceLogReqBO).getData();
            if (priceLogBOS != null && priceLogBOS.size() > 0) {
                Map priceLogBOMap = priceLogBOS.stream().collect(Collectors.toMap(ActSkuPriceLogBO::getSkuId, Function.identity()));
                for (DycActQuerySkuPushInfoBO row : rspBO.getRows()) {
                    if (!priceLogBOMap.containsKey(row.getSkuId())) continue;
                    ActSkuPriceLogBO priceLogBO = (ActSkuPriceLogBO)priceLogBOMap.get(row.getSkuId());
                    if (0 != row.getMarketPrice().compareTo(priceLogBO.getMarketPrice())) {
                        row.setChangeMarketPriceFlag(Boolean.TRUE);
                    }
                    if (0 == row.getAgreementPrice().compareTo(priceLogBO.getAgreementPrice())) continue;
                    row.setChangeAgreementPriceFlag(Boolean.TRUE);
                }
            }
        }
        return rspBO;
    }
}

