/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.api.DycActSkuInfoModel;
import com.tydic.dyc.act.model.bo.ActActivitySkuChangePriceLogReqBO;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActQuerySkuToActivityService;
import com.tydic.dyc.act.service.bo.DycActQuerySkuToActivityBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuToActivityReqBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuToActivityRspBO;
import com.tydic.dyc.act.utils.ActRu;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ACT_GROUP_DEV/3.2.1/com.tydic.dyc.act.service.api.DycActQuerySkuToActivityService"})
public class DycActQuerySkuToActivityServiceImpl
implements DycActQuerySkuToActivityService {
    @Autowired
    private DycActActivityModel dycActActivityModel;
    @Autowired
    private DycActSkuInfoModel dycActSkuInfoModel;

    @PostMapping(value={"querySkuToActivity"})
    public DycActQuerySkuToActivityRspBO querySkuToActivity(@RequestBody DycActQuerySkuToActivityReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u67e5\u8be2\u5546\u54c1\u6240\u5728\u6d3b\u52a8\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getSkuIdList())) {
            throw new ZTBusinessException("\u67e5\u8be2\u5546\u54c1\u6240\u5728\u6d3b\u52a8\u5165\u53c2skuIdList\u4e3a\u7a7a");
        }
        DycActQuerySkuToActivityRspBO rspBO = (DycActQuerySkuToActivityRspBO)ActRu.success(DycActQuerySkuToActivityRspBO.class);
        DycActivityDO activityDO = new DycActivityDO();
        activityDO.setSkuIdList(reqBO.getSkuIdList());
        List<DycActivityDO> list = this.dycActActivityModel.querySkuToActivity(activityDO);
        if (CollectionUtils.isEmpty(list)) {
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBO;
        }
        ArrayList<DycActQuerySkuToActivityBO> skuToActivityList = new ArrayList<DycActQuerySkuToActivityBO>();
        ArrayList<ActActivitySkuChangePriceLogReqBO> addList = new ArrayList<ActActivitySkuChangePriceLogReqBO>();
        for (DycActivityDO dycActivityDO : list) {
            ActActivitySkuChangePriceLogReqBO addBO = (ActActivitySkuChangePriceLogReqBO)ActRu.js((Object)dycActivityDO, ActActivitySkuChangePriceLogReqBO.class);
            DycActQuerySkuToActivityBO activityBO = (DycActQuerySkuToActivityBO)ActRu.js((Object)dycActivityDO, DycActQuerySkuToActivityBO.class);
            int i = dycActivityDO.getAgreementPrice().compareTo(dycActivityDO.getSkuPrice());
            if (0 > i) {
                activityBO.setChangeFlagStr("\u964d\u4ef7");
                addBO.setChangeFlag(DycActivityConstants.ChangeFlag.FALL);
            } else {
                if (0 >= i) continue;
                activityBO.setChangeFlagStr("\u6da8\u4ef7");
                addBO.setChangeFlag(DycActivityConstants.ChangeFlag.RISE);
            }
            skuToActivityList.add(activityBO);
            addBO.setChangeTime(dycActivityDO.getUpdateTime());
            addBO.setChangeBeforePrice(dycActivityDO.getSkuPrice());
            addBO.setChangeAfterPrice(dycActivityDO.getAgreementPrice());
            addList.add(addBO);
        }
        if (CollectionUtils.isEmpty(skuToActivityList)) {
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getIsWriteHistory().booleanValue()) {
            this.dycActSkuInfoModel.addListActActivitySkuChangePriceLog(addList);
        }
        Map<Long, List<DycActQuerySkuToActivityBO>> skuToActivityMap = skuToActivityList.stream().collect(Collectors.groupingBy(DycActQuerySkuToActivityBO::getSkuId));
        rspBO.setSkuToActivityMap(skuToActivityMap);
        return rspBO;
    }
}

