/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.act.model.api.DycActSkuPoolModel;
import com.tydic.dyc.act.model.bo.ActRelSkuPoolBO;
import com.tydic.dyc.act.model.bo.ActRelSkuPoolReqBO;
import com.tydic.dyc.act.service.api.DycActSkuBatchRelPoolService;
import com.tydic.dyc.act.service.bo.DycActSkuBatchRelPoolReqBO;
import com.tydic.dyc.act.service.bo.DycActSkuBatchRelPoolRspBO;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ACT_GROUP_DEV/3.2.1/com.tydic.dyc.act.service.api.DycActSkuBatchRelPoolService"})
public class DycActSkuBatchRelPoolServiceImpl
implements DycActSkuBatchRelPoolService {
    @Autowired
    private DycActSkuPoolModel dycActSkuPoolModel;

    @PostMapping(value={"skuBatchRelPool"})
    public DycActSkuBatchRelPoolRspBO skuBatchRelPool(@RequestBody DycActSkuBatchRelPoolReqBO reqBO) {
        this.valData(reqBO);
        DycActSkuBatchRelPoolRspBO rspBO = (DycActSkuBatchRelPoolRspBO)ActRu.success(DycActSkuBatchRelPoolRspBO.class);
        ActRelSkuPoolReqBO skuPoolReqBO = new ActRelSkuPoolReqBO();
        skuPoolReqBO.setPoolIds(reqBO.getPoolIds());
        List<ActRelSkuPoolBO> poolBOS = this.dycActSkuPoolModel.queryActRelSkuPoolList(skuPoolReqBO).getData();
        if (!ObjectUtil.isEmpty(poolBOS)) {
            Map poolMap = poolBOS.stream().collect(Collectors.groupingBy(ActRelSkuPoolBO::getPoolId, Collectors.mapping(ActRelSkuPoolBO::getSkuId, Collectors.toList())));
            for (Long poolId : reqBO.getPoolIds()) {
                if (poolMap.containsKey(poolId)) {
                    List skuIds = poolMap.get(poolId);
                    if (skuIds.contains(reqBO.getSkuId())) continue;
                    this.addSkuRelPool(reqBO.getSkuId(), poolId);
                    continue;
                }
                this.addSkuRelPool(reqBO.getSkuId(), poolId);
            }
        } else {
            for (Long poolId : reqBO.getPoolIds()) {
                this.addSkuRelPool(reqBO.getSkuId(), poolId);
            }
        }
        return rspBO;
    }

    private void addSkuRelPool(Long skuId, Long poolId) {
        ActRelSkuPoolReqBO addReqBO = new ActRelSkuPoolReqBO();
        addReqBO.setSkuId(skuId);
        addReqBO.setPoolId(poolId);
        this.dycActSkuPoolModel.addActRelSkuPool(addReqBO);
    }

    private void valData(DycActSkuBatchRelPoolReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u5546\u54c1\u6279\u91cf\u5173\u8054\u5546\u54c1\u6c60\u670d\u52a1\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getSkuId())) {
            throw new BaseBusinessException("200001", "\u5546\u54c1\u6279\u91cf\u5173\u8054\u5546\u54c1\u6c60\u670d\u52a1\u5165\u53c2\u5546\u54c1\u6c60ID[skuId]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getPoolIds())) {
            throw new BaseBusinessException("200001", "\u5546\u54c1\u6279\u91cf\u5173\u8054\u5546\u54c1\u6c60\u670d\u52a1\u5165\u53c2\u5546\u54c1\u6c60\u5173\u8054\u7c7b\u578b[poolIds]\u4e3a\u7a7a");
        }
    }
}

