/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.api.DycActSkuInfoModel;
import com.tydic.dyc.act.model.api.DycActSkuPoolModel;
import com.tydic.dyc.act.model.bo.ActRelSkuPoolReqBO;
import com.tydic.dyc.act.model.bo.ActRelSourcePoolReqBO;
import com.tydic.dyc.act.model.bo.ActSkuInfoBO;
import com.tydic.dyc.act.model.bo.ActSkuInfoReqBO;
import com.tydic.dyc.act.service.api.DycActSkuPoolRelService;
import com.tydic.dyc.act.service.bo.DycActSkuPoolRelReqBO;
import com.tydic.dyc.act.service.bo.DycActSkuPoolRelRspBO;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ACT_GROUP_DEV/3.2.1/com.tydic.dyc.act.service.api.DycActSkuPoolRelService"})
public class DycActSkuPoolRelServiceImpl
implements DycActSkuPoolRelService {
    @Autowired
    private DycActSkuInfoModel dycActSkuInfoModel;
    @Autowired
    private DycActSkuPoolModel dycActSkuPoolModel;

    @PostMapping(value={"relSkuPool"})
    public DycActSkuPoolRelRspBO relSkuPool(@RequestBody DycActSkuPoolRelReqBO reqBO) {
        this.valData(reqBO);
        switch (reqBO.getPoolType()) {
            case 1: 
            case 3: {
                this.supplierAndCatalog(reqBO);
                break;
            }
            case 2: {
                this.commodity(reqBO);
                break;
            }
            default: {
                throw new BaseBusinessException("8888", "\u5546\u54c1\u6c60\u5173\u8054\u5546\u54c1\u670d\u52a1\u5165\u53c2\u5173\u8054\u7c7b\u578b\u4e0d\u7b26\u5408\u89c4\u5219");
            }
        }
        return (DycActSkuPoolRelRspBO)ActRu.success(DycActSkuPoolRelRspBO.class);
    }

    private void supplierAndCatalog(DycActSkuPoolRelReqBO reqBO) {
        ActSkuInfoReqBO skuInfoReqBO = new ActSkuInfoReqBO();
        if (DycActivityConstants.PoolType.SUPPLIER.equals(reqBO.getPoolType())) {
            skuInfoReqBO.setSupplierIdList(reqBO.getRelIds());
        }
        if (DycActivityConstants.PoolType.CATALOG.equals(reqBO.getPoolType())) {
            skuInfoReqBO.setGuideIdList(reqBO.getRelIds());
        }
        List<ActSkuInfoBO> data = this.dycActSkuInfoModel.queryActSkuInfoList(skuInfoReqBO).getData();
        if (DycActivityConstants.RelPoolOperType.REL.equals(reqBO.getOperType())) {
            this.batchInsertRelSourcePool(reqBO.getRelIds(), reqBO.getPoolId());
            if (!CollectionUtil.isEmpty(data)) {
                this.batchInsertRelSkuPool(data.stream().map(ActSkuInfoBO::getSkuId).collect(Collectors.toList()), reqBO.getPoolId());
            }
        }
        if (DycActivityConstants.RelPoolOperType.CANCEL_REL.equals(reqBO.getOperType())) {
            this.batchDeleteRelSourcePool(reqBO.getRelIds(), reqBO.getPoolId());
            if (!CollectionUtil.isEmpty(data)) {
                this.batchDeleteRelSkuPool(data.stream().map(ActSkuInfoBO::getSkuId).collect(Collectors.toList()), reqBO.getPoolId());
            }
        }
    }

    private void commodity(DycActSkuPoolRelReqBO reqBO) {
        if (DycActivityConstants.RelPoolOperType.REL.equals(reqBO.getOperType())) {
            this.batchInsertRelSkuPool(reqBO.getRelIds(), reqBO.getPoolId());
        }
        if (DycActivityConstants.RelPoolOperType.CANCEL_REL.equals(reqBO.getOperType())) {
            this.batchDeleteRelSkuPool(reqBO.getRelIds(), reqBO.getPoolId());
        }
    }

    private void batchInsertRelSourcePool(List<Long> sourceIds, Long poolId) {
        ArrayList<ActRelSourcePoolReqBO> actRelSourcePoolReqBO = new ArrayList<ActRelSourcePoolReqBO>();
        for (Long sourceId : sourceIds) {
            ActRelSourcePoolReqBO relSourcePoolReqBO = new ActRelSourcePoolReqBO();
            relSourcePoolReqBO.setPoolId(poolId);
            relSourcePoolReqBO.setSourceId(sourceId);
            actRelSourcePoolReqBO.add(relSourcePoolReqBO);
        }
        this.dycActSkuPoolModel.batchInsertActRelSourcePool(actRelSourcePoolReqBO);
    }

    private void batchInsertRelSkuPool(List<Long> skuIds, Long poolId) {
        ArrayList<ActRelSkuPoolReqBO> actRelSkuPoolReqBO = new ArrayList<ActRelSkuPoolReqBO>();
        for (Long skuId : skuIds) {
            ActRelSkuPoolReqBO relSkuPoolReqBO = new ActRelSkuPoolReqBO();
            relSkuPoolReqBO.setPoolId(poolId);
            relSkuPoolReqBO.setSkuId(skuId);
            actRelSkuPoolReqBO.add(relSkuPoolReqBO);
        }
        this.dycActSkuPoolModel.batchInsertActRelSkuPool(actRelSkuPoolReqBO);
    }

    private void batchDeleteRelSkuPool(List<Long> skuIds, Long poolId) {
        ActRelSkuPoolReqBO skuPoolReqBO = new ActRelSkuPoolReqBO();
        skuPoolReqBO.setSkuIdList(skuIds);
        skuPoolReqBO.setPoolId(poolId);
        this.dycActSkuPoolModel.batchDeleteActRelSkuPool(skuPoolReqBO);
    }

    private void batchDeleteRelSourcePool(List<Long> sourceIds, Long poolId) {
        ActRelSourcePoolReqBO sourcePoolReqBO = new ActRelSourcePoolReqBO();
        sourcePoolReqBO.setSourceIdList(sourceIds);
        sourcePoolReqBO.setPoolId(poolId);
        this.dycActSkuPoolModel.batchDeleteActRelSourcePool(sourcePoolReqBO);
    }

    private void valData(DycActSkuPoolRelReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u5546\u54c1\u6c60\u5173\u8054\u5546\u54c1\u670d\u52a1\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getPoolId())) {
            throw new BaseBusinessException("200001", "\u5546\u54c1\u6c60\u5173\u8054\u5546\u54c1\u670d\u52a1\u5165\u53c2\u5546\u54c1\u6c60ID[poolId]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getPoolType())) {
            throw new BaseBusinessException("200001", "\u5546\u54c1\u6c60\u5173\u8054\u5546\u54c1\u670d\u52a1\u5165\u53c2\u5546\u54c1\u6c60\u5173\u8054\u7c7b\u578b[poolType]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getRelIds())) {
            throw new BaseBusinessException("200001", "\u5546\u54c1\u6c60\u5173\u8054\u5546\u54c1\u670d\u52a1\u5165\u53c2\u5173\u8054ID\u96c6\u5408[relIds]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getOperType())) {
            throw new BaseBusinessException("200001", "\u5546\u54c1\u6c60\u5173\u8054\u5546\u54c1\u670d\u52a1\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b[operType]\u4e3a\u7a7a");
        }
    }
}

