package com.tydic.dyc.act.repository.dao;

import com.tydic.dyc.act.repository.po.ActivityChangeUserInfoPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @ClassName: ActivityChangeUserInfoMapper
 * @Description: ActivityChangeUserInfoMapper
 * @author: zhoulu
 * @date: 2023年12月11日16:44:00
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Mapper
@Repository
public interface ActivityChangeUserInfoMapper {

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActivityChangeUserInfoPO>
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    List<ActivityChangeUserInfoPO> selectByCondition(ActivityChangeUserInfoPO record);

    /**
     * 描述: 根据条件删除
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    int delete(ActivityChangeUserInfoPO record);

    /**
     * 描述: 插入单条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    int insert(ActivityChangeUserInfoPO record);

    /**
     * 描述: 插入多条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    int allInsert(List<ActivityChangeUserInfoPO> record);

    /**
     * 描述: 更新单条数据（可选择的）
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    int update(ActivityChangeUserInfoPO record);

    /**
     * 描述:根据变更单以及用户id批量移除
     *
     * @param ids, record
     * @return int
     */
    int updateBatchByUserId(@Param("ids") List<Long> ids, ActivityChangeUserInfoPO record);


    /**
     * 活动变更用户积分修改（批量）服务
     * @param activityChangeUserInfoPOS
     * @return
     */
    int batchModifyActivityChangeUserScores(List<ActivityChangeUserInfoPO> activityChangeUserInfoPOS);
}
