package com.tydic.dyc.act.repository.dao;

import com.tydic.dyc.act.repository.po.ActivityRelaCommodityCatalogPO;
import com.tydic.dyc.act.repository.po.ActivityRelaCommodityPoolPO;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @ClassName: ActivityRelaCommodityCatalogMapper
 * @Description: ActivityRelaCommodityCatalogMapper
 * @author: zhoulu
 * @date: 2023年12月11日16:44:00
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Mapper
@Repository
public interface ActivityRelaCommodityCatalogMapper {

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActivityRelaCommodityCatalogPO>
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    List<ActivityRelaCommodityCatalogPO> selectByCondition(ActivityRelaCommodityCatalogPO record);


    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActivityRelaCommodityPoolPO>
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    List<ActivityRelaCommodityCatalogPO> selectByConditionExt(ActivityRelaCommodityCatalogPO record);

    /**
     * 描述: 根据条件删除
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    int delete(ActivityRelaCommodityCatalogPO record);

    /**
     * 描述: 插入单条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    int insert(ActivityRelaCommodityCatalogPO record);

    /**
     * 描述: 插入多条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    int allInsert(List<ActivityRelaCommodityCatalogPO> record);

    /**
     * 描述: 更新单条数据（可选择的）
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    int update(ActivityRelaCommodityCatalogPO record);

    /**
     * 活动商品类型移除（批量）服务
     * @param list
     * @return
     */
    int batchRemoveActivityCommodityCatalog(List<ActivityRelaCommodityCatalogPO> list);
}
