package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.model.bo.DycActivityChangeRelaCommodityCatalogInfo;
import com.tydic.dyc.act.model.bo.DycActivityChangeRelaCommodityInfo;
import com.tydic.dyc.act.model.bo.DycActivityChangeRelaCommodityPoolInfo;
import com.tydic.dyc.act.repository.api.DycActActivityChangeCommodityRepository;
import com.tydic.dyc.act.repository.dao.ActivityChangeRelaCommodityCatalogMapper;
import com.tydic.dyc.act.repository.dao.ActivityChangeRelaCommodityMapper;
import com.tydic.dyc.act.repository.dao.ActivityChangeRelaCommodityPoolMapper;
import com.tydic.dyc.act.repository.po.ActivityChangeRelaCommodityCatalogPO;
import com.tydic.dyc.act.repository.po.ActivityChangeRelaCommodityPO;
import com.tydic.dyc.act.repository.po.ActivityChangeRelaCommodityPoolPO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 说明：〈活动商品变更基建方法〉实现
 *
 * @author zhoulu
 * @date 2023年12月22日 14:26
 */
@Service
public class DycActActivityChangeCommodityRepositoryImpl implements DycActActivityChangeCommodityRepository {
    @Autowired
    private ActivityChangeRelaCommodityCatalogMapper activityChangeRelaCommodityCatalogMapper;
    @Autowired
    private ActivityChangeRelaCommodityPoolMapper activityChangeRelaCommodityPoolMapper;

    @Autowired
    private ActivityChangeRelaCommodityMapper activityChangeRelaCommodityMapper;

    @Override
    public BasePageRspBo<DycActivityChangeRelaCommodityCatalogInfo> queryActivityChangeSelectedCommodityCatalogPageList(DycActivityChangeDO reqBO) {
        BasePageRspBo<DycActivityChangeRelaCommodityCatalogInfo> rspBo = new BasePageRspBo<>();
        ActivityChangeRelaCommodityCatalogPO activityChangeRelaCommodityCatalogPO = JSON.parseObject(JSON.toJSONString(reqBO), ActivityChangeRelaCommodityCatalogPO.class);
        Page<ActivityChangeRelaCommodityCatalogPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.activityChangeRelaCommodityCatalogMapper.selectByCondition(activityChangeRelaCommodityCatalogPO));
        if (ObjectUtils.isEmpty(page)) {
            rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
            rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
            return rspBo;
        }
        List<DycActivityChangeRelaCommodityCatalogInfo> rows = JSON.parseArray(JSON.toJSONString(page.getResult()), DycActivityChangeRelaCommodityCatalogInfo.class);
        rspBo.setPageNo(page.getPageNum());
        rspBo.setRows(rows);
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int) page.getTotal());
        rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBo;
    }

    @Override
    public BasePageRspBo<DycActivityChangeRelaCommodityPoolInfo> queryActivityChangeCommodityPoolPageList(DycActivityChangeDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBO.getChangeId()) {
            throw new ZTBusinessException("变更单id不能为空！");
        }
        ActivityChangeRelaCommodityPoolPO selectActivityChangeRelaCommodityPoolPO = new ActivityChangeRelaCommodityPoolPO();
        BeanUtils.copyProperties(reqBO, selectActivityChangeRelaCommodityPoolPO);
        Page<ActivityChangeRelaCommodityPoolPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.activityChangeRelaCommodityPoolMapper.selectByCondition(selectActivityChangeRelaCommodityPoolPO));

        //封装集合
        List<DycActivityChangeRelaCommodityPoolInfo> activityChangeRelaCommodityPoolBOList = new ArrayList<>();
        for (ActivityChangeRelaCommodityPoolPO activityChangeRelaCommodityPoolPO : page.getResult()) {
            DycActivityChangeRelaCommodityPoolInfo activityChangeRelaCommodityPoolBO = new DycActivityChangeRelaCommodityPoolInfo();
            BeanUtils.copyProperties(activityChangeRelaCommodityPoolPO, activityChangeRelaCommodityPoolBO);
            activityChangeRelaCommodityPoolBOList.add(activityChangeRelaCommodityPoolBO);
        }

        BasePageRspBo<DycActivityChangeRelaCommodityPoolInfo> rspPage = new BasePageRspBo<>();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(activityChangeRelaCommodityPoolBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        rspPage.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspPage.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspPage;
    }

    @Override
    public DycActivityChangeRelaCommodityPoolInfo batchSelectActivityChangeCommodityPool(DycActivityChangeDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO) || null == reqBO.getChangeId()) {
            throw new ZTBusinessException("入参不能为空或者变更单id不能为空！");
        }
        if (CollectionUtils.isEmpty(reqBO.getCommodityPoolList())) {
            throw new ZTBusinessException("商品池列表不能为空！");
        }
        List<ActivityChangeRelaCommodityPoolPO> commodityPoolPOS = JSON.parseArray(JSON.toJSONString(reqBO.getCommodityPoolList()), ActivityChangeRelaCommodityPoolPO.class);
        commodityPoolPOS.forEach(item -> {
            item.setRelaId(Sequence.getInstance().nextId());
            item.setChangeId(reqBO.getChangeId());
            item.setDelFlag(0);
            item.setCreateTime(new Date());
            item.setCreateUserId(reqBO.getCreateUserId());
            item.setCreateUserName(reqBO.getCreateUserName());
        });

        int i = activityChangeRelaCommodityPoolMapper.allInsert(commodityPoolPOS);
        if (reqBO.getCommodityPoolList().size() != i) {
            throw new ZTBusinessException("活动变更商品池选择（批量）服务失败！");
        }
        return new DycActivityChangeRelaCommodityPoolInfo();
    }

    @Override
    public DycActivityChangeRelaCommodityPoolInfo batchRemoveActivityChangeCommodityPool(DycActivityChangeDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO) || null == reqBO.getChangeId()) {
            throw new ZTBusinessException("入参不能为空或者变更单id不能为空！");
        }
        if (CollectionUtils.isEmpty(reqBO.getCommodityPoolIdList())) {
            throw new ZTBusinessException("商品池Id列表不能为空！");
        }
        ActivityChangeRelaCommodityPoolPO commodityPoolPO = new ActivityChangeRelaCommodityPoolPO();
        commodityPoolPO.setChangeId(reqBO.getChangeId());
        commodityPoolPO.setUpdateTime(new Date());
        commodityPoolPO.setUpdateUserId(reqBO.getUpdateUserId());
        commodityPoolPO.setUpdateUserName(reqBO.getUpdateUserName());
        int i = activityChangeRelaCommodityPoolMapper.updateBatchById(reqBO.getCommodityPoolIdList(), commodityPoolPO);
        if (i != reqBO.getCommodityPoolIdList().size()) {
            throw new ZTBusinessException("活动变更商品池移除（批量）服务失败！");
        }
        return new DycActivityChangeRelaCommodityPoolInfo();
    }

    @Override
    public int batchSelectActivityChangeCommodity(DycActivityChangeDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO) || null == reqBO.getChangeId()) {
            throw new ZTBusinessException("入参不能为空或者变更单id不能为空！");
        }
        if (CollectionUtils.isEmpty(reqBO.getCommodityList())) {
            throw new ZTBusinessException("商品列表不能为空！");
        }
        List<ActivityChangeRelaCommodityPO> commodityPOS = JSON.parseArray(JSON.toJSONString(reqBO.getCommodityList()), ActivityChangeRelaCommodityPO.class);
        commodityPOS.forEach(item -> {
            item.setRelaId(Sequence.getInstance().nextId());
            item.setChangeId(reqBO.getChangeId());
            item.setDelFlag(0);
            item.setCreateTime(new Date());
            item.setCreateUserId(reqBO.getCreateUserId());
            item.setCreateUserName(reqBO.getCreateUserName());
        });

        int i = activityChangeRelaCommodityMapper.allInsert(commodityPOS);
        if (reqBO.getCommodityList().size() != i) {
            throw new ZTBusinessException("活动变更商品选择（批量）服务失败！");
        }
        return i;
    }

    @Override
    public int batchSelectActivityChangeCommodityCatalog(DycActivityChangeDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO) || null == reqBO.getChangeId()) {
            throw new ZTBusinessException("入参不能为空或者变更单id不能为空！");
        }
        if (CollectionUtils.isEmpty(reqBO.getCommodityCatalogList())) {
            throw new ZTBusinessException("商品类型列表不能为空！");
        }
        List<ActivityChangeRelaCommodityCatalogPO> commodityPOS = JSON.parseArray(JSON.toJSONString(reqBO.getCommodityCatalogList()), ActivityChangeRelaCommodityCatalogPO.class);
        commodityPOS.forEach(item -> {
            item.setRelaId(Sequence.getInstance().nextId());
            item.setChangeId(reqBO.getChangeId());
            item.setDelFlag(0);
            item.setCreateTime(new Date());
            item.setCreateUserId(reqBO.getCreateUserId());
            item.setCreateUserName(reqBO.getCreateUserName());
        });

        int i = activityChangeRelaCommodityCatalogMapper.allInsert(commodityPOS);
        if (reqBO.getCommodityCatalogList().size() != i) {
            throw new ZTBusinessException("活动变更商品类型选择（批量）服务失败！");
        }
        return i;
    }

    @Override
    public int batchRemoveActivityChangeCommodityCatalog(DycActivityChangeDO reqBO) {
        List<ActivityChangeRelaCommodityCatalogPO> list = new ArrayList<>();
        for (Long aLong : reqBO.getCommodityTypeIdList()) {
            ActivityChangeRelaCommodityCatalogPO activityChangeRelaCommodityCatalogPO = new ActivityChangeRelaCommodityCatalogPO();
            activityChangeRelaCommodityCatalogPO.setChangeId(reqBO.getChangeId());
            activityChangeRelaCommodityCatalogPO.setUpdateTime(new Date());
            activityChangeRelaCommodityCatalogPO.setUpdateUserId(reqBO.getUpdateUserId());
            activityChangeRelaCommodityCatalogPO.setUpdateUserName(reqBO.getUpdateUserName());
            activityChangeRelaCommodityCatalogPO.setCommodityTypeId(aLong);
            list.add(activityChangeRelaCommodityCatalogPO);
        }
        int num = activityChangeRelaCommodityCatalogMapper.batchRemoveActivityChangeCommodityCatalog(list);
        return num;
    }

    @Override
    public BasePageRspBo<DycActivityChangeRelaCommodityInfo> queryActivityChangeCommodityPageList(DycActivityChangeDO reqBO) {
        BasePageRspBo<DycActivityChangeRelaCommodityInfo> rspBo = new BasePageRspBo<>();
        ActivityChangeRelaCommodityPO activityChangeRelaCommodityPO = JSON.parseObject(JSON.toJSONString(reqBO), ActivityChangeRelaCommodityPO.class);
        Page<ActivityChangeRelaCommodityPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.activityChangeRelaCommodityMapper.selectByCondition(activityChangeRelaCommodityPO));
        if (ObjectUtils.isEmpty(page)) {
            rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
            rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
            return rspBo;
        }
        List<DycActivityChangeRelaCommodityInfo> rows = JSON.parseArray(JSON.toJSONString(page.getResult()), DycActivityChangeRelaCommodityInfo.class);
        rspBo.setPageNo(page.getPageNum());
        rspBo.setRows(rows);
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int) page.getTotal());
        rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBo;
    }

    @Override
    public int batchRemoveActivityChangeCommodity(DycActivityChangeDO reqBO) {
        List<ActivityChangeRelaCommodityPO> list = new ArrayList<>();
        for (Long aLong : reqBO.getSkuIdList()) {
            ActivityChangeRelaCommodityPO activityChangeRelaCommodityPO = new ActivityChangeRelaCommodityPO();
            activityChangeRelaCommodityPO.setChangeId(reqBO.getChangeId());
            activityChangeRelaCommodityPO.setUpdateTime(new Date());
            activityChangeRelaCommodityPO.setUpdateUserId(reqBO.getUpdateUserId());
            activityChangeRelaCommodityPO.setUpdateUserName(reqBO.getUpdateUserName());
            activityChangeRelaCommodityPO.setSkuId(aLong);
            list.add(activityChangeRelaCommodityPO);
        }
        int num = activityChangeRelaCommodityMapper.batchRemoveActivityChangeCommodity(list);
        return num;
    }
}
