package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.bo.DycActActivityChangeApproveBaseInfo;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.model.bo.DycActivityChangeInfo;
import com.tydic.dyc.act.model.bo.DycProcessDO;
import com.tydic.dyc.act.repository.api.DycActActivityChangeRepository;
import com.tydic.dyc.act.repository.dao.ActivityChangeInfoMapper;
import com.tydic.dyc.act.repository.po.ActivityChangeInfoPO;
import com.tydic.dyc.act.repository.po.ActivityChangeInfoTimePO;
import com.tydic.dyc.act.repository.po.DycActActivityChangeApproveBaseInfoPO;
import com.tydic.dyc.act.utils.DycActivityTransFieldUtil;
import com.tydic.dyc.base.bo.BasePageRspBo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;

/**
 * 说明：〈活动变更实体基建方法〉实现
 *
 * @author zhoulu
 * @date 2023年12月22日 14:26
 */
@Service
public class DycActActivityChangeRepositoryImpl implements DycActActivityChangeRepository {

    @Autowired
    private ActivityChangeInfoMapper activityChangeInfoMapper;

    @Override
    public DycActivityChangeInfo queryActivityChangeBaseInfo(DycActivityChangeDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO) || null == reqBO.getChangeId()) {
            throw new ZTBusinessException("内容不能为空或者变更id不能为空！");
        }
        DycActivityChangeInfo rspBO = new DycActivityChangeInfo();
        ActivityChangeInfoPO selectActivityChangeInfoPO = new ActivityChangeInfoPO();
        selectActivityChangeInfoPO.setChangeId(reqBO.getChangeId());
        List<ActivityChangeInfoPO> activityChangeInfoList = this.activityChangeInfoMapper.selectByCondition(selectActivityChangeInfoPO);
        if (activityChangeInfoList.size() > 1) {
            throw new ZTBusinessException("当前id存在多个变更单！");
        }
        if (activityChangeInfoList.size() < 1) {
            throw new ZTBusinessException("当前id不存在变更单！");
        }
        BeanUtils.copyProperties(activityChangeInfoList.get(0), rspBO);
        return rspBO;
    }

    @Override
    public DycActivityChangeInfo saveActiveChangeBaseInfo(DycActivityChangeDO reqBO) {

        ActivityChangeInfoPO changeInfoPO = new ActivityChangeInfoPO();
        BeanUtils.copyProperties(reqBO, changeInfoPO);
        changeInfoPO.setChangeId(Sequence.getInstance().nextId());
        // 获取当前时间
        LocalDateTime now = LocalDateTime.now();
        // 格式化当前时间
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        String formattedDateTime = now.format(formatter);
        // 生成3位随机数字
        Random random = new Random();
        int randomNum = random.nextInt(900) + 100;
        // 组合字符串
        String activityCode = "FLHD" + formattedDateTime + randomNum;
        String changeCode = "HDBGD" + formattedDateTime + randomNum;
        changeInfoPO.setChangeCode(changeCode);
        changeInfoPO.setChangeState(String.valueOf(0));
        changeInfoPO.setDelFlag(0);
        changeInfoPO.setCreateTime(new Date());
        changeInfoPO.setNewActivityCode(activityCode);
        int i = activityChangeInfoMapper.insert(changeInfoPO);
        if (1 != i) {
            throw new ZTBusinessException("新增变更单失败！");
        }
        DycActivityChangeInfo rspBO = new DycActivityChangeInfo();
        rspBO.setChangeId(changeInfoPO.getChangeId());
        return rspBO;
    }

    @Override
    public DycActivityChangeInfo changeActivityChangeState(DycActivityChangeDO reqBO) {
        ActivityChangeInfoPO changeInfoPO = new ActivityChangeInfoPO();
        changeInfoPO.setChangeId(reqBO.getChangeId());
        changeInfoPO.setUpdateTime(new Date());
        changeInfoPO.setUpdateUserId(reqBO.getUserId());
        changeInfoPO.setUpdateUserName(reqBO.getName());
        changeInfoPO.setChangeState(reqBO.getChangeState());
        activityChangeInfoMapper.update(changeInfoPO);
        return new DycActivityChangeInfo();
    }

    @Override
    public BasePageRspBo<DycActivityChangeInfo> queryActivityChangePageList(DycActivityChangeDO reqBO) {
        BasePageRspBo<DycActivityChangeInfo> rspBo = new BasePageRspBo<>();
        ActivityChangeInfoTimePO activityChangeInfoTimePO = JSON.parseObject(JSON.toJSONString(reqBO), ActivityChangeInfoTimePO.class);
        Page<ActivityChangeInfoPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.activityChangeInfoMapper.queryActivityChangePageList(activityChangeInfoTimePO));

        if (ObjectUtils.isEmpty(page)) {
            rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
            rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
            return rspBo;
        }

        List<DycActivityChangeInfo> activityChangeInfoList = new ArrayList<>();
        for (ActivityChangeInfoPO activityChangeInfoPO : page.getResult()) {
            DycActivityChangeInfo dycActivityChangeInfo = new DycActivityChangeInfo();
            BeanUtils.copyProperties(activityChangeInfoPO, dycActivityChangeInfo);
            dycActivityChangeInfo.setChangeStateStr(DycActivityTransFieldUtil.ChangeState(String.valueOf(dycActivityChangeInfo.getChangeState())));
            dycActivityChangeInfo.setActivityTypeDesc(DycActivityTransFieldUtil.ActivityType(String.valueOf(dycActivityChangeInfo.getActivityType())));
            activityChangeInfoList.add(dycActivityChangeInfo);
        }
        rspBo.setPageNo(page.getPageNum());
        rspBo.setRows(activityChangeInfoList);
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int) page.getTotal());
        rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBo;
    }

    @Override
    public BasePageRspBo<DycActActivityChangeApproveBaseInfo> queryActivityChangeApprovePageList(DycProcessDO reqBO) {
        BasePageRspBo<DycActActivityChangeApproveBaseInfo> rspBo = new BasePageRspBo<>();
        ActivityChangeInfoTimePO activityBaseInfoTimePO = JSON.parseObject(JSON.toJSONString(reqBO), ActivityChangeInfoTimePO.class);
        if ("1".equals(activityBaseInfoTimePO.getTabId())) {
            activityBaseInfoTimePO.setCurrentNodeStatus(1);
        } else if ("2".equals(activityBaseInfoTimePO.getTabId())) {
            activityBaseInfoTimePO.setCurrentNodeStatus(2);
        }
        Page<DycActActivityChangeApproveBaseInfoPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.activityChangeInfoMapper.queryActivityChangeApprovePageList(activityBaseInfoTimePO));

        if (ObjectUtils.isEmpty(page)) {
            rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
            rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
            return rspBo;
        }
        //封装集合
        List<DycActActivityChangeApproveBaseInfo> activityBaseInfoBOList = JSON.parseArray(JSON.toJSONString(page.getResult()), DycActActivityChangeApproveBaseInfo.class);
        rspBo.setPageNo(page.getPageNum());
        rspBo.setRows(activityBaseInfoBOList);
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int) page.getTotal());
        rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBo;
    }
}
