package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.model.bo.DycActivityChangeSupplierInfo;
import com.tydic.dyc.act.repository.api.DycActActivityChangeSupplierRepository;
import com.tydic.dyc.act.repository.dao.ActivityChangeSupplierInfoMapper;
import com.tydic.dyc.act.repository.po.ActivityChangeSupplierInfoPO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 说明：〈活动变更供应商基建方法〉实现
 *
 * @author zhoulu
 * @date 2023年12月22日 14:25
 */
@Service
public class DycActActivityChangeSupplierRepositoryImpl implements DycActActivityChangeSupplierRepository {

    @Autowired
    private ActivityChangeSupplierInfoMapper activityChangeSupplierInfoMapper;

    @Override
    public BasePageRspBo<DycActivityChangeSupplierInfo> queryActivityChangeSelectedSupplierPageList(DycActivityChangeDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBO.getChangeId()) {
            throw new ZTBusinessException("变更单id不能为空！");
        }
        BasePageRspBo<DycActivityChangeSupplierInfo> rspBo = new BasePageRspBo<>();
        ActivityChangeSupplierInfoPO activityChangeSupplierInfoPO = JSON.parseObject(JSON.toJSONString(reqBO), ActivityChangeSupplierInfoPO.class);
        Page<ActivityChangeSupplierInfoPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.activityChangeSupplierInfoMapper.selectByCondition(activityChangeSupplierInfoPO));
        if (ObjectUtils.isEmpty(page)) {
            rspBo.setPageNo(reqBO.getPageNo());
            rspBo.setTotal(0);
            rspBo.setRecordsTotal(0);
            rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
            rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
            return rspBo;
        }
        rspBo.setRows(JSON.parseArray(JSON.toJSONString(page.getResult()), DycActivityChangeSupplierInfo.class));
        rspBo.setPageNo(page.getPageNum());
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int) page.getTotal());
        rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBo;
    }

    @Override
    public int batchSelectActivityChangeSupplier(DycActivityChangeDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBO.getChangeId()) {
            throw new ZTBusinessException("变更单id不能为空！");
        }
        if (reqBO.getSupplierList().size() < 1) {
            throw new ZTBusinessException("供应商集合不能为空！");
        }
        List<ActivityChangeSupplierInfoPO> record = new ArrayList<>();
        for (DycActivityChangeSupplierInfo dycActivityChangeSupplierInfo : reqBO.getSupplierList()) {
            ActivityChangeSupplierInfoPO activityChangeSupplierInfoPO = JSON.parseObject(JSON.toJSONString(dycActivityChangeSupplierInfo), ActivityChangeSupplierInfoPO.class);
            activityChangeSupplierInfoPO.setChangeId(reqBO.getChangeId());
            activityChangeSupplierInfoPO.setId(Sequence.getInstance().nextId());
            record.add(activityChangeSupplierInfoPO);
        }
        return activityChangeSupplierInfoMapper.allInsert(record);
    }

    @Override
    public int batchRemoveActivityChangeSupplier(DycActivityChangeDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBO.getChangeId()) {
            throw new ZTBusinessException("变更单id不能为空！");
        }
        if (reqBO.getSupplierIdList().size() < 1) {
            throw new ZTBusinessException("供应商集合不能为空！");
        }
        List<ActivityChangeSupplierInfoPO> record = new ArrayList<>();
        for (Long aLong : reqBO.getSupplierIdList()) {
            ActivityChangeSupplierInfoPO activityChangeSupplierInfoPO = new ActivityChangeSupplierInfoPO();
            activityChangeSupplierInfoPO.setChangeId(reqBO.getChangeId());
            activityChangeSupplierInfoPO.setSupplierId(aLong);
            record.add(activityChangeSupplierInfoPO);
        }
        return activityChangeSupplierInfoMapper.batchRemoveActivityChangeSupplier(record);
    }
}
