package com.tydic.dyc.act.repository.impl;

import cn.hutool.core.util.DesensitizedUtil;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.model.bo.DycActivityChangeUserInfo;
import com.tydic.dyc.act.repository.api.DycActActivityChangeUserRepository;
import com.tydic.dyc.act.repository.dao.ActivityChangeUserInfoMapper;
import com.tydic.dyc.act.repository.po.ActivityChangeUserInfoPO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 说明：活动变更用户基建方法〉实现
 *
 * @author zhoulu
 * @date 2023年12月22日 14:25
 */
@Service
public class DycActActivityChangeUserRepositoryImpl implements DycActActivityChangeUserRepository {

    @Autowired
    private ActivityChangeUserInfoMapper activityChangeUserInfoMapper;

    @Override
    public int batchSelectActivityChangeUser(DycActivityChangeDO reqBO) {

        List<ActivityChangeUserInfoPO> changeUserInfoPO = reqBO.getUserList().stream().map(item -> {
            ActivityChangeUserInfoPO changeUser = new ActivityChangeUserInfoPO();
            BeanUtils.copyProperties(item, changeUser);
            changeUser.setChangeId(reqBO.getChangeId());
            changeUser.setCreateUserId(reqBO.getCreateUserId());
            changeUser.setCreateUserName(reqBO.getActivityName());
            changeUser.setId(Sequence.getInstance().nextId());
            changeUser.setDelFlag(0);
            changeUser.setCreateTime(new Date());
            changeUser.setUserId(item.getActUserId());
            changeUser.setUserName(item.getActUserName());
            changeUser.setName(item.getActName());
            changeUser.setWorkNo(item.getActWorkNo());
            changeUser.setUserOrgId(item.getActUserOrgId());
            changeUser.setUserOrgName(item.getActUserOrgName());
            return changeUser;
        }).collect(Collectors.toList());


        int i = activityChangeUserInfoMapper.allInsert(changeUserInfoPO);
        if (i != reqBO.getUserList().size()) {
            throw new ZTBusinessException("变更用户批量添加失败！");
        }
        return i;
    }

    @Override
    public BasePageRspBo<DycActivityChangeUserInfo> queryActivityChangeUserPageList(DycActivityChangeDO reqBO) {

        ActivityChangeUserInfoPO selectActivityChangeUserInfoPO = new ActivityChangeUserInfoPO();
        BeanUtils.copyProperties(reqBO, selectActivityChangeUserInfoPO);
        selectActivityChangeUserInfoPO.setUserId(reqBO.getActUserId());
        selectActivityChangeUserInfoPO.setUserName(reqBO.getActUserName());
        selectActivityChangeUserInfoPO.setName(reqBO.getActName());
        Page<ActivityChangeUserInfoPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.activityChangeUserInfoMapper.selectByCondition(selectActivityChangeUserInfoPO));

        //封装集合
        List<DycActivityChangeUserInfo> activityChangeUserInfoBOList = new ArrayList<>();
        for (ActivityChangeUserInfoPO activityChangeUserInfoPO : page.getResult()) {
            DycActivityChangeUserInfo activityChangeUserInfoBO = new DycActivityChangeUserInfo();
            BeanUtils.copyProperties(activityChangeUserInfoPO, activityChangeUserInfoBO);
            activityChangeUserInfoBO.setPhone(DesensitizedUtil.mobilePhone(activityChangeUserInfoBO.getPhone()));
            activityChangeUserInfoBOList.add(activityChangeUserInfoBO);
        }

        BasePageRspBo<DycActivityChangeUserInfo> rspPage = new BasePageRspBo<>();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(activityChangeUserInfoBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        rspPage.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspPage.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspPage;
    }

    @Override
    public int batchRemoveActivityChangeUser(DycActivityChangeDO reqBO) {
        ActivityChangeUserInfoPO activityChangeUserInfoPO = new ActivityChangeUserInfoPO();
        BeanUtils.copyProperties(reqBO, activityChangeUserInfoPO);
        activityChangeUserInfoPO.setUpdateTime(new Date());
        int i = activityChangeUserInfoMapper.updateBatchByUserId(reqBO.getUserIdList(), activityChangeUserInfoPO);
        if (i != reqBO.getUserIdList().size()) {
            throw new ZTBusinessException("当前用户已有使用积分，不可进行移除！");
        }
        return i;
    }

    @Override
    public List<DycActivityChangeUserInfo> queryChangeActivityUserList(DycActivityChangeDO dycActivityChangeDO) {
        ActivityChangeUserInfoPO activityChangeUserInfoPO = new ActivityChangeUserInfoPO();
        activityChangeUserInfoPO.setChangeId(dycActivityChangeDO.getChangeId());
        List<ActivityChangeUserInfoPO> activityChangeUserInfoPOS = activityChangeUserInfoMapper.selectByCondition(activityChangeUserInfoPO);
        List<DycActivityChangeUserInfo> list = JSON.parseArray(JSON.toJSONString(activityChangeUserInfoPOS), DycActivityChangeUserInfo.class);
        return list;
    }

    @Override
    public int addChangeUser(DycActivityChangeDO dycActivityUserInfo) {
        ActivityChangeUserInfoPO activityChangeUserInfoPO = JSON.parseObject(JSON.toJSONString(dycActivityUserInfo), ActivityChangeUserInfoPO.class);
        activityChangeUserInfoPO.setCreateTime(new Date());
        activityChangeUserInfoPO.setId(Sequence.getInstance().nextId());
        activityChangeUserInfoPO.setDelFlag(0);
        activityChangeUserInfoPO.setUserId(dycActivityUserInfo.getActUserId());
        activityChangeUserInfoPO.setUserName(dycActivityUserInfo.getActUserName());
        activityChangeUserInfoPO.setName(dycActivityUserInfo.getActName());
        activityChangeUserInfoPO.setWorkNo(dycActivityUserInfo.getActWorkNo());
        return activityChangeUserInfoMapper.insert(activityChangeUserInfoPO);
    }

    @Override
    public int batchModifyActivityChangeUserScores(DycActivityChangeDO dycActivityChangeDO) {
        ActivityChangeUserInfoPO activityChangeUserInfoPO = new ActivityChangeUserInfoPO();
        activityChangeUserInfoPO.setChangeId(dycActivityChangeDO.getChangeId());
        if (dycActivityChangeDO.getUserId() != null) {
            activityChangeUserInfoPO.setUserId(dycActivityChangeDO.getUserId());
        }
        List<ActivityChangeUserInfoPO> activityChangeUserInfoPOS = activityChangeUserInfoMapper.selectByCondition(activityChangeUserInfoPO);
        if (activityChangeUserInfoPOS.size() < 1) {
            throw new ZTBusinessException("没有需要修改的用户");
        }
        BigDecimal max = new BigDecimal("0");
        for (ActivityChangeUserInfoPO changeUserInfoPO : activityChangeUserInfoPOS) {
            if (changeUserInfoPO.getBalanceScores() == null || changeUserInfoPO.getGiveScores() == null) {
                throw new ZTBusinessException("用户积分异常");
            }
//            if (changeUserInfoPO.getGiveScores().add(dycActivityChangeDO.getBalanceScores()).compareTo(new BigDecimal("0")) < 0){
//                max = changeUserInfoPO.getBalanceScores();
//            }
            if (changeUserInfoPO.getBalanceScores().add(dycActivityChangeDO.getGiveScores()).compareTo(new BigDecimal("0")) < 0) {
                max = changeUserInfoPO.getBalanceScores();
            }
            changeUserInfoPO.setBalanceScores(changeUserInfoPO.getBalanceScores().add(dycActivityChangeDO.getGiveScores()));
            changeUserInfoPO.setGiveScores(changeUserInfoPO.getGiveScores().add(dycActivityChangeDO.getGiveScores()));
            changeUserInfoPO.setUpdateTime(new Date());
            changeUserInfoPO.setUpdateUserId(dycActivityChangeDO.getUpdateUserId());
            changeUserInfoPO.setUpdateUserName(dycActivityChangeDO.getUpdateUserName());

        }
        if (max.compareTo(new BigDecimal("0")) > 0) {
            throw new ZTBusinessException("发放积分失败，最小值应大于:-" + max);
        }
        return activityChangeUserInfoMapper.batchModifyActivityChangeUserScores(activityChangeUserInfoPOS);
    }
}
