package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.api.DycActActivityCommodityRepository;
import com.tydic.dyc.act.repository.dao.ActivityRelaCommodityCatalogMapper;
import com.tydic.dyc.act.repository.dao.ActivityRelaCommodityMapper;
import com.tydic.dyc.act.repository.dao.ActivityRelaCommodityPoolMapper;
import com.tydic.dyc.act.repository.po.ActivityRelaCommodityCatalogPO;
import com.tydic.dyc.act.repository.po.ActivityRelaCommodityPO;
import com.tydic.dyc.act.repository.po.ActivityRelaCommodityPoolPO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 标题：DycActActivityCommodityRepositoryImpl
 * 说明：活动已选商品池列表分页查询
 * 时间： 2023-12-13 15:43
 * 作者 @author LY
 */
@Service
public class DycActActivityCommodityRepositoryImpl implements DycActActivityCommodityRepository {

    @Autowired
    private ActivityRelaCommodityPoolMapper activityRelaCommodityPoolMapper;
    @Autowired
    private ActivityRelaCommodityMapper activityRelaCommodityMapper;

    @Autowired
    private ActivityRelaCommodityCatalogMapper activityRelaCommodityCatalogMapper;

    @Override
    public BasePageRspBo<DycActivityCommodityPoolInfo> queryActivityCommodityPoolPageList(DycQueryActivityCommodityPoolPageListReqBO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("活动已选商品池列表分页查询失败！");
        }
        BasePageRspBo<DycActivityCommodityPoolInfo> rspPage = new BasePageRspBo<>();
        ActivityRelaCommodityPoolPO selectActivityRelaCommodityPoolPO = new ActivityRelaCommodityPoolPO();
        BeanUtils.copyProperties(reqBO, selectActivityRelaCommodityPoolPO);
        Page<ActivityRelaCommodityPoolPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.activityRelaCommodityPoolMapper.selectByCondition(selectActivityRelaCommodityPoolPO));

        if (ObjectUtils.isEmpty(page)) {
            rspPage.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
            rspPage.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
            return rspPage;
        }
        //封装集合
        List<DycActivityCommodityPoolInfo> activityRelaCommodityPoolBOList = new ArrayList<>();
        for (ActivityRelaCommodityPoolPO activityRelaCommodityPoolPO : page.getResult()) {
            DycActivityCommodityPoolInfo activityRelaCommodityPoolBO = new DycActivityCommodityPoolInfo();
            BeanUtils.copyProperties(activityRelaCommodityPoolPO, activityRelaCommodityPoolBO);
            activityRelaCommodityPoolBOList.add(activityRelaCommodityPoolBO);
        }

        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(activityRelaCommodityPoolBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        rspPage.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspPage.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspPage;
    }

    @Override
    public List<DycActivityCommodityPoolInfo> queryActivityCommodityPoolList(DycQueryActivityCommodityPoolPageListReqBO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("活动已选商品池列表分页查询失败！");
        }
        ActivityRelaCommodityPoolPO relaCommodityPoolPO = new ActivityRelaCommodityPoolPO();
        BeanUtils.copyProperties(reqBO, relaCommodityPoolPO);
        List<ActivityRelaCommodityPoolPO> commodityPoolPOS = activityRelaCommodityPoolMapper.selectByCondition(relaCommodityPoolPO);
        List<DycActivityCommodityPoolInfo> rspBO = JSON.parseArray(JSON.toJSONString(commodityPoolPOS), DycActivityCommodityPoolInfo.class);
        return rspBO;
    }

    @Override
    public BasePageRspBo<DycActiveCommodityCatalogInfo> queryActiveCommodityCatalogList(DycActiveCommodityCatalogQueryBO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("活动已选商品类型列表分页查询失败！");
        }
        BasePageRspBo<DycActiveCommodityCatalogInfo> rspPage = new BasePageRspBo<>();
        ActivityRelaCommodityCatalogPO commodityPoolPO = new ActivityRelaCommodityCatalogPO();
        BeanUtils.copyProperties(reqBO, commodityPoolPO);
        Page<ActivityRelaCommodityCatalogPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.activityRelaCommodityCatalogMapper.selectByConditionExt(commodityPoolPO));
        if (ObjectUtils.isEmpty(page)) {
            rspPage.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
            rspPage.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
            return rspPage;
        }
        List<DycActiveCommodityCatalogInfo> dycActiveCommodityCatalogInfos = new ArrayList<>();
        for (ActivityRelaCommodityCatalogPO relaCommodityPoolPO : page.getResult()) {
            DycActiveCommodityCatalogInfo catalogInfo = new DycActiveCommodityCatalogInfo();
            BeanUtils.copyProperties(relaCommodityPoolPO, catalogInfo);
            catalogInfo.setCatalogStr(catalogInfo.getFirstCatalogName() + "/" + catalogInfo.getSecondCatalogName() + "/" + catalogInfo.getThreeCatalogName());
            dycActiveCommodityCatalogInfos.add(catalogInfo);
        }

        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(dycActiveCommodityCatalogInfos);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        rspPage.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspPage.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspPage;
    }

    @Override
    public List<DycActiveCommodityCatalogInfo> queryActiveCommodityCatalogAllList(DycActiveCommodityCatalogQueryBO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("活动已选商品类型列表分页查询失败！");
        }
        ActivityRelaCommodityCatalogPO selectActivityRelaCommodityPO = new ActivityRelaCommodityCatalogPO();
        BeanUtils.copyProperties(reqBO, selectActivityRelaCommodityPO);
        List<ActivityRelaCommodityCatalogPO> activityRelaCommodityPOList = this.activityRelaCommodityCatalogMapper.selectByCondition(selectActivityRelaCommodityPO);
        List<DycActiveCommodityCatalogInfo> activityRelaCommodityBOList = JSON.parseArray(JSON.toJSONString(activityRelaCommodityPOList), DycActiveCommodityCatalogInfo.class);
        return activityRelaCommodityBOList;
    }

    @Override

    public DycActivityCommodityPoolInfo batchSelectActivityCommodityPool(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (CollectionUtils.isEmpty(reqBO.getActivityCommodityPoolInfos())) {
            throw new ZTBusinessException("活动商品池选择（批量）服务为空！");
        }
        List<ActivityRelaCommodityPoolPO> commodityPoolPOS = JSON.parseArray(JSON.toJSONString(reqBO.getActivityCommodityPoolInfos()), ActivityRelaCommodityPoolPO.class);
        List<ActivityRelaCommodityPoolPO> collect = commodityPoolPOS.stream().map(item -> {
            item.setRelaId(Sequence.getInstance().nextId());
            item.setCreateTime(new Date());
            item.setCreateUserId(reqBO.getCreateUserId());
            item.setCreateUserName(reqBO.getCreateUserName());
            item.setActivityId(reqBO.getActivityId());
            item.setDelFlag(0);
            return item;
        }).collect(Collectors.toList());
        int i = activityRelaCommodityPoolMapper.allInsert(collect);
        if (i != reqBO.getActivityCommodityPoolInfos().size()) {
            throw new ZTBusinessException("活动商品池选择（批量）服务新增失败！");
        }
        DycActivityCommodityPoolInfo rspBO = new DycActivityCommodityPoolInfo();
        rspBO.setActivityId(reqBO.getActivityId());
        return rspBO;
    }

    @Override
    public int batchRemoveActivityCommodityPool(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (reqBO.getActivityId() == null) {
            throw new ZTBusinessException("活动id不能为空！");
        }
        if (reqBO.getCommodityPoolIdList().size() < 1) {
            throw new ZTBusinessException("商品池id列表不能为空！");
        }
        List<ActivityRelaCommodityPoolPO> list = new ArrayList<>();
        for (Long aLong : reqBO.getCommodityPoolIdList()) {
            ActivityRelaCommodityPoolPO activityRelaCommodityPoolPO = new ActivityRelaCommodityPoolPO();
            activityRelaCommodityPoolPO.setActivityId(reqBO.getActivityId());
            activityRelaCommodityPoolPO.setUpdateTime(new Date());
            activityRelaCommodityPoolPO.setUpdateUserId(reqBO.getUpdateUserId());
            activityRelaCommodityPoolPO.setUpdateUserName(reqBO.getUpdateUserName());
            activityRelaCommodityPoolPO.setCommodityPoolId(aLong);
            list.add(activityRelaCommodityPoolPO);
        }
        return activityRelaCommodityPoolMapper.batchRemoveActivityCommodityPool(list);
    }

    @Override
    public DycActiveCommodityCatalogInfo batchSelectActivityCommodityCatalog(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("活动商品类型选择（批量）服务为空！");
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("活动商品类型选择（批量）服务活动ID为空！");
        }
        if (CollectionUtils.isEmpty(reqBO.getCommodityCatalogInfoBOS())) {
            throw new ZTBusinessException("活动商品类型选择（批量）服务类型为空！");
        }
        List<ActivityRelaCommodityCatalogPO> collect = reqBO.getCommodityCatalogInfoBOS().stream().map(item -> {
            ActivityRelaCommodityCatalogPO catalogPO = new ActivityRelaCommodityCatalogPO();
            BeanUtils.copyProperties(item, catalogPO);
            catalogPO.setActivityId(reqBO.getActivityId());
            catalogPO.setCreateTime(new Date());
            catalogPO.setDelFlag(0);
            catalogPO.setRelaId(Sequence.getInstance().nextId());
            catalogPO.setCreateUserId(reqBO.getCreateUserId());
            catalogPO.setCreateUserName(reqBO.getCreateUserName());
            return catalogPO;
        }).collect(Collectors.toList());
        int i = activityRelaCommodityCatalogMapper.allInsert(collect);
        if (i != reqBO.getCommodityCatalogInfoBOS().size()) {
            throw new ZTBusinessException("活动商品类型选择（批量）服务类型失败！");
        }
        return new DycActiveCommodityCatalogInfo();
    }

    @Override
    public int batchRemoveActivityCommodityCatalog(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (reqBO.getActivityId() == null) {
            throw new ZTBusinessException("活动id不能为空！");
        }
        if (reqBO.getCommodityTypeIdList().size() < 1) {
            throw new ZTBusinessException("商品类型Id列表不能为空！");
        }
        List<ActivityRelaCommodityCatalogPO> list = new ArrayList<>();
        for (Long aLong : reqBO.getCommodityTypeIdList()) {
            ActivityRelaCommodityCatalogPO activityRelaCommodityPoolPO = new ActivityRelaCommodityCatalogPO();
            activityRelaCommodityPoolPO.setActivityId(reqBO.getActivityId());
            activityRelaCommodityPoolPO.setUpdateTime(new Date());
            activityRelaCommodityPoolPO.setUpdateUserId(reqBO.getUpdateUserId());
            activityRelaCommodityPoolPO.setUpdateUserName(reqBO.getUpdateUserName());
            activityRelaCommodityPoolPO.setCommodityTypeId(aLong);
            list.add(activityRelaCommodityPoolPO);
        }
        return activityRelaCommodityCatalogMapper.batchRemoveActivityCommodityCatalog(list);
    }

    @Override
    public DycActActivityRelaCommodityInfo batchSelectActivityCommodity(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("活动id不能为空！");
        }
        if (!CollectionUtils.isEmpty(reqBO.getActActivityRelaCommodityBOS())) {
            List<ActivityRelaCommodityPO> collect = reqBO.getActActivityRelaCommodityBOS().stream().map(item -> {
                ActivityRelaCommodityPO commodityPO = new ActivityRelaCommodityPO();
                BeanUtils.copyProperties(item, commodityPO);
                commodityPO.setActivityId(reqBO.getActivityId());
                commodityPO.setCreateTime(new Date());
                commodityPO.setCreateUserId(reqBO.getCreateUserId());
                commodityPO.setRelaId(Sequence.getInstance().nextId());
                commodityPO.setDelFlag(0);
                commodityPO.setCreateUserName(reqBO.getCreateUserName());
                return commodityPO;
            }).collect(Collectors.toList());
            int i = activityRelaCommodityMapper.allInsert(collect);
            if (i != reqBO.getActActivityRelaCommodityBOS().size()) {
                throw new ZTBusinessException("活动商品选择（批量）服务添加失败！");
            }
        }

        return new DycActActivityRelaCommodityInfo();
    }

    @Override
    public int batchRemoveActivityCommodity(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("活动id不能为空！");
        }
        if (reqBO.getSkuIdList().size() < 1) {
            throw new ZTBusinessException("商品id不能为空！");
        }
        List<ActivityRelaCommodityPO> list = new ArrayList<>();
        for (Long aLong : reqBO.getSkuIdList()) {
            ActivityRelaCommodityPO activityRelaCommodityPO = new ActivityRelaCommodityPO();
            activityRelaCommodityPO.setActivityId(reqBO.getActivityId());
            activityRelaCommodityPO.setUpdateTime(new Date());
            activityRelaCommodityPO.setUpdateUserId(reqBO.getUpdateUserId());
            activityRelaCommodityPO.setUpdateUserName(reqBO.getUpdateUserName());
            activityRelaCommodityPO.setSkuId(aLong);
            list.add(activityRelaCommodityPO);
        }
        int num = activityRelaCommodityMapper.batchRemoveActivityCommodity(list);
        return num;
    }

    @Override
    public BasePageRspBo<DycActActivityRelaCommodityInfo> queryActivityCommodityPageList(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("活动id不能为空！");
        }
        BasePageRspBo<DycActActivityRelaCommodityInfo> rspBo = new BasePageRspBo<>();
        ActivityRelaCommodityPO activityRelaCommodityPO = new ActivityRelaCommodityPO();
        activityRelaCommodityPO.setActivityId(reqBO.getActivityId());
        Page<ActivityRelaCommodityPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.activityRelaCommodityMapper.selectByCondition(activityRelaCommodityPO));

        if (ObjectUtils.isEmpty(page)) {
            rspBo.setPageNo(reqBO.getPageNo());
            rspBo.setTotal(0);
            rspBo.setRecordsTotal(0);
            rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
            rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
            return rspBo;
        }
        rspBo.setRows(JSON.parseArray(JSON.toJSONString(page.getResult()), DycActActivityRelaCommodityInfo.class));
        rspBo.setPageNo(page.getPageNum());
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int) page.getTotal());
        rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBo;
    }

    @Override
    public List<DycActActivityRelaCommodityInfo> queryActivityCommodityList(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("活动id不能为空！");
        }
        ActivityRelaCommodityPO selectActivityRelaCommodityPO = new ActivityRelaCommodityPO();
        BeanUtils.copyProperties(reqBO, selectActivityRelaCommodityPO);
        List<ActivityRelaCommodityPO> activityRelaCommodityPOList = this.activityRelaCommodityMapper.selectByCondition(selectActivityRelaCommodityPO);
        List<DycActActivityRelaCommodityInfo> activityRelaCommodityBOList = JSON.parseArray(JSON.toJSONString(activityRelaCommodityPOList), DycActActivityRelaCommodityInfo.class);
        return activityRelaCommodityBOList;
    }
}
