package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.api.DycActActivityRepository;
import com.tydic.dyc.act.repository.dao.ActivityBaseInfoMapper;
import com.tydic.dyc.act.repository.po.ActivityBaseInfoPO;
import com.tydic.dyc.act.repository.po.ActivityBaseInfoTimePO;
import com.tydic.dyc.act.repository.po.DycActActivityApproveBaseInfoPO;
import com.tydic.dyc.act.utils.DycActivitySequence;
import com.tydic.dyc.act.utils.DycActivityTransFieldUtil;
import com.tydic.dyc.base.bo.BasePageRspBo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;

/**
 * 描述: 〈活动实体基建方法实现〉
 *
 * @author : yuhao
 * @date : 2023/12/12 15:33
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Slf4j
@Service
public class DycActActivityRepositoryImpl implements DycActActivityRepository {

    @Autowired
    private ActivityBaseInfoMapper activityBaseInfoMapper;

    /**
     * 根据条件查询活动基本信息列表（分页）
     *
     * @param reqBO
     * @return
     */
    @Override
    public BasePageRspBo<DycActivityBaseInfo> queryActivityPageList(DycActivityDO reqBO) {
        ActivityBaseInfoPO selectActivityBaseInfoPO = new ActivityBaseInfoPO();
        BasePageRspBo<DycActivityBaseInfo> rspPage = new BasePageRspBo<>();
        BeanUtils.copyProperties(reqBO, selectActivityBaseInfoPO);
        Page<ActivityBaseInfoPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.activityBaseInfoMapper.selectByCondition(selectActivityBaseInfoPO));

        if (ObjectUtils.isEmpty(page)) {
            rspPage.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
            rspPage.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
            return rspPage;
        }
        //封装集合
        List<DycActivityBaseInfo> activityBaseInfoBOList = new ArrayList<>();
        for (ActivityBaseInfoPO activityBaseInfoPO : page.getResult()) {
            DycActivityBaseInfo activityBaseInfoBO = new DycActivityBaseInfo();
            BeanUtils.copyProperties(activityBaseInfoPO, activityBaseInfoBO);
            activityBaseInfoBO.setInvoiceClassStr(DycActivityTransFieldUtil.InvoiceClass(String.valueOf(activityBaseInfoBO.getInvoiceClass())));
            activityBaseInfoBO.setInvoiceTypeStr(DycActivityTransFieldUtil.ActivityType(String.valueOf(activityBaseInfoBO.getInvoiceType())));
            activityBaseInfoBO.setActivityTypeStr(DycActivityTransFieldUtil.ActivityType(String.valueOf(activityBaseInfoBO.getActivityType())));
            activityBaseInfoBO.setActivityPayModeStr(DycActivityTransFieldUtil.ActivityPayMode(String.valueOf(activityBaseInfoBO.getActivityPayMode())));
            activityBaseInfoBO.setActivityStateStr(DycActivityTransFieldUtil.ActivityState(activityBaseInfoBO.getActivityState()));
            activityBaseInfoBOList.add(activityBaseInfoBO);
        }

        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(activityBaseInfoBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        rspPage.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspPage.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspPage;
    }

    @Override
    public List<DycActivityBaseInfo> queryActivityList(DycActivityDO reqBO) {
        ActivityBaseInfoPO selectActivityBaseInfoPO = new ActivityBaseInfoPO();
        BeanUtils.copyProperties(reqBO, selectActivityBaseInfoPO);
        List<ActivityBaseInfoPO> activityBaseInfoPOS = activityBaseInfoMapper.selectByCondition(selectActivityBaseInfoPO);
        //封装集合
        List<DycActivityBaseInfo> activityBaseInfoBOList = new ArrayList<>();
        if (activityBaseInfoPOS.size() < 1) {
            return activityBaseInfoBOList;
        }
        for (ActivityBaseInfoPO activityBaseInfoPO : activityBaseInfoPOS) {
            DycActivityBaseInfo activityBaseInfoBO = new DycActivityBaseInfo();
            BeanUtils.copyProperties(activityBaseInfoPO, activityBaseInfoBO);
            activityBaseInfoBO.setActivityStateStr(DycActivityTransFieldUtil.ActivityState(activityBaseInfoBO.getActivityState()));
            activityBaseInfoBO.setActivityTypeStr(DycActivityTransFieldUtil.ActivityType(String.valueOf(activityBaseInfoBO.getActivityType())));
            activityBaseInfoBOList.add(activityBaseInfoBO);
        }

        return activityBaseInfoBOList;
    }


    /**
     * 描述:活动基本详情保存
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityBaseInfo
     */
    @Override
    public DycActivityBaseInfo saveActiveBaseInfo(DycActiveBaseInfoSaveReqBO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("保存内容为空！");
        }
        DycActivityBaseInfo rspBO = new DycActivityBaseInfo();
        if (null == reqBO.getActivityId()) {
            //新增
            ActivityBaseInfoPO insertBO = new ActivityBaseInfoPO();
            BeanUtils.copyProperties(reqBO, insertBO);

            // 获取当前时间
            LocalDateTime now = LocalDateTime.now();
            // 格式化当前时间
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
            String formattedDateTime = now.format(formatter);
            // 生成3位随机数字
            Random random = new Random();
            int randomNum = random.nextInt(900) + 100;
            // 组合字符串
            String randomString = "FLHD" + formattedDateTime + randomNum;
            insertBO.setActivityCode(randomString);
            insertBO.setActivityId(DycActivitySequence.getInstance().nextId());
            insertBO.setActivityVersion(1);
            insertBO.setActivityState("1");
            insertBO.setDelFlag(0);
            insertBO.setCreateTime(new Date());
            if (null != reqBO.getMinPrice() && reqBO.getMinPrice().compareTo(BigDecimal.ZERO) < 0) {
                throw new ZTBusinessException("商品最低价格不能低于0！");
            }
            int i = activityBaseInfoMapper.insert(insertBO);
            if (1 != i) {
                throw new ZTBusinessException("保存内容失败！");
            }
            rspBO.setActivityId(insertBO.getActivityId());
        } else {
            //修改
            ActivityBaseInfoPO baseInfoPO = new ActivityBaseInfoPO();
            BeanUtils.copyProperties(reqBO, baseInfoPO);
            int i = activityBaseInfoMapper.update(baseInfoPO);
            if (1 != i) {
                throw new ZTBusinessException("更新内容失败！");
            }
        }
        return rspBO;
    }

    @Override
    public int changeActivityState(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("活动id不能为空！");
        }
        if (StringUtils.isEmpty(reqBO.getActivityState())) {
            throw new ZTBusinessException("活动状态不能为空！");
        }
        ActivityBaseInfoPO activityBaseInfoPO = JSON.parseObject(JSON.toJSONString(reqBO), ActivityBaseInfoPO.class);
        activityBaseInfoPO.setUpdateTime(new Date());
        return activityBaseInfoMapper.update(activityBaseInfoPO);
    }

    @Override
    public int deleteActivity(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("活动id不能为空！");
        }
        ActivityBaseInfoPO activityBaseInfoPO = JSON.parseObject(JSON.toJSONString(reqBO), ActivityBaseInfoPO.class);
        activityBaseInfoPO.setUpdateTime(new Date());
        return activityBaseInfoMapper.deleteActivity(activityBaseInfoPO);
    }

    @Override
    public int autoEffectActivity(DycActivityDO reqBO) {
        ActivityBaseInfoPO activityBaseInfoPO = new ActivityBaseInfoPO();
        List<ActivityBaseInfoPO> list = activityBaseInfoMapper.selectAutoEffectActivity(activityBaseInfoPO);
        if (list.size() < 1) {
            return 0;
        }
        for (ActivityBaseInfoPO baseInfoPO : list) {
            baseInfoPO.setUpdateTime(new Date());
            baseInfoPO.setActivityState("5");
        }
        return activityBaseInfoMapper.batchUpdate(list);
    }

    @Override
    public DycActivityBaseInfo autoLoseEffectActivity(DycActivityDO reqBO) {
        List<ActivityBaseInfoPO> activityBaseInfoPOS = activityBaseInfoMapper.autoLoseEffectActivity();
        DycActivityBaseInfo rspBO = new DycActivityBaseInfo();
        if (CollectionUtils.isEmpty(activityBaseInfoPOS)) {
            return rspBO;
        }
        activityBaseInfoPOS.forEach(item -> {
            item.setActivityState(String.valueOf(7));
            item.setUpdateTime(new Date());
        });
        activityBaseInfoMapper.batchUpdate(activityBaseInfoPOS);
        return rspBO;
    }

    @Override
    public BasePageRspBo<DycActActivityApproveBaseInfo> queryActivityApprovePageList(DycProcessDO reqBO) {
        BasePageRspBo<DycActActivityApproveBaseInfo> rspBo = new BasePageRspBo<>();
        ActivityBaseInfoTimePO activityBaseInfoTimePO = JSON.parseObject(JSON.toJSONString(reqBO), ActivityBaseInfoTimePO.class);
        if ("1".equals(activityBaseInfoTimePO.getTabId())) {
            activityBaseInfoTimePO.setCurrentNodeStatus(1);
        } else if ("2".equals(activityBaseInfoTimePO.getTabId())) {
            activityBaseInfoTimePO.setCurrentNodeStatus(2);
        }
        Page<DycActActivityApproveBaseInfoPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.activityBaseInfoMapper.queryActivityApprovePageList(activityBaseInfoTimePO));

        if (ObjectUtils.isEmpty(page)) {
            rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
            rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
            return rspBo;
        }
        //封装集合
        List<DycActActivityApproveBaseInfo> activityBaseInfoBOList = JSON.parseArray(JSON.toJSONString(page.getResult()), DycActActivityApproveBaseInfo.class);
        rspBo.setPageNo(page.getPageNum());
        rspBo.setRows(activityBaseInfoBOList);
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int) page.getTotal());
        rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBo;
    }


}
