package com.tydic.dyc.act.repository.impl;

import cn.hutool.core.util.DesensitizedUtil;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.model.bo.DycActivityUserInfo;
import com.tydic.dyc.act.model.bo.DycActivityUserScoresUseRecordInfo;
import com.tydic.dyc.act.repository.api.DycActActivityUserRepository;
import com.tydic.dyc.act.repository.dao.ActivityUserInfoMapper;
import com.tydic.dyc.act.repository.dao.ActivityUserScoresUseRecordMapper;
import com.tydic.dyc.act.repository.po.ActivityUserInfoPO;
import com.tydic.dyc.act.repository.po.ActivityUserScoresUseRecordPO;
import com.tydic.dyc.act.repository.po.ActivityUserScoresUseRecordTimePO;
import com.tydic.dyc.act.utils.DycActivityTransFieldUtil;
import com.tydic.dyc.base.bo.BasePageRspBo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 说明：
 *
 * @author zhoulu
 * @date 2023年12月18日 16:31
 */
@Service
public class DycActActivityUserRepositoryImpl implements DycActActivityUserRepository {

    @Autowired
    private ActivityUserInfoMapper activityUserInfoMapper;
    @Autowired
    private ActivityUserScoresUseRecordMapper activityUserScoresUseRecordMapper;

    @Override
    public BasePageRspBo<DycActivityUserInfo> queryActivityUserPageList(DycActivityDO reqBO) {
        if (reqBO.getActivityId() == null) {
            throw new ZTBusinessException("活动id不能为空！");
        }
        BasePageRspBo<DycActivityUserInfo> rspBo = new BasePageRspBo<>();
        ActivityUserInfoPO activityUserInfoPO = new ActivityUserInfoPO();
        BeanUtils.copyProperties(reqBO, activityUserInfoPO);
        activityUserInfoPO.setUserId(reqBO.getActUserId());
        activityUserInfoPO.setUserName(reqBO.getActUserName());
        activityUserInfoPO.setName(reqBO.getActName());
        activityUserInfoPO.setWorkNo(reqBO.getActWorkNo());
        activityUserInfoPO.setUserOrgId(reqBO.getActUserOrgId());
        activityUserInfoPO.setUserOrgName(reqBO.getActUserOrgName());
        Page<ActivityUserInfoPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.activityUserInfoMapper.selectByCondition(activityUserInfoPO));
        if (ObjectUtils.isEmpty(page)) {
            rspBo.setPageNo(reqBO.getPageNo());
            rspBo.setTotal(0);
            rspBo.setRecordsTotal(0);
            rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
            rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
            return rspBo;
        }
        List<DycActivityUserInfo> activityUserInfos = page.getResult().stream().map(item -> {
            DycActivityUserInfo userInfo = new DycActivityUserInfo();
            BeanUtils.copyProperties(item,userInfo);
            userInfo.setActUserId(item.getUserId());
            userInfo.setActUserName(item.getUserName());
            userInfo.setActName(item.getName());
            userInfo.setActWorkNo(item.getWorkNo());
            userInfo.setActUserOrgId(item.getUserOrgId());
            userInfo.setActUserOrgName(item.getUserOrgName());
            return userInfo;
        }).collect(Collectors.toList());
        rspBo.setRows(activityUserInfos);
        rspBo.setPageNo(page.getPageNum());
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int) page.getTotal());
        rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBo;
    }

    @Override
    public List<DycActivityUserInfo> queryActivityUserList(DycActivityDO reqBO) {
        if (reqBO.getActivityId() == null) {
            throw new ZTBusinessException("活动id不能为空！");
        }
        ActivityUserInfoPO activityUserInfoPO = new ActivityUserInfoPO();
        BeanUtils.copyProperties(reqBO, activityUserInfoPO);
        activityUserInfoPO.setUserId(reqBO.getActUserId());
        activityUserInfoPO.setUserName(reqBO.getActUserName());
        activityUserInfoPO.setName(reqBO.getActName());
        activityUserInfoPO.setWorkNo(reqBO.getActWorkNo());
        activityUserInfoPO.setUserOrgId(reqBO.getActUserOrgId());
        activityUserInfoPO.setUserOrgName(reqBO.getActUserOrgName());
        List<ActivityUserInfoPO> activityUserInfoPOS = activityUserInfoMapper.selectByCondition(activityUserInfoPO);
        List<DycActivityUserInfo> rspBo = activityUserInfoPOS.stream().map(item -> {
            DycActivityUserInfo userInfo = new DycActivityUserInfo();
            BeanUtils.copyProperties(item, userInfo);
            userInfo.setActUserId(item.getUserId());
            userInfo.setActUserName(item.getUserName());
            userInfo.setActName(item.getName());
            userInfo.setActWorkNo(item.getWorkNo());
            userInfo.setActUserOrgId(item.getUserOrgId());
            userInfo.setActUserOrgName(item.getUserOrgName());
            return userInfo;
        }).collect(Collectors.toList());
        return rspBo;
    }

    @Override
    public int addUser(DycActivityDO reqBO) {
        ActivityUserInfoPO activityUserInfoPO = JSON.parseObject(JSON.toJSONString(reqBO), ActivityUserInfoPO.class);
        activityUserInfoPO.setCreateTime(new Date());
        activityUserInfoPO.setId(Sequence.getInstance().nextId());
        activityUserInfoPO.setDelFlag(0);
        activityUserInfoPO.setUserId(reqBO.getActUserId());
        activityUserInfoPO.setUserName(reqBO.getActUserName());
        activityUserInfoPO.setName(reqBO.getActName());
        activityUserInfoPO.setWorkNo(reqBO.getActWorkNo());
        activityUserInfoPO.setUserOrgId(reqBO.getActUserOrgId());
        activityUserInfoPO.setUserOrgName(reqBO.getActUserOrgName());
        return activityUserInfoMapper.insert(activityUserInfoPO);
    }

    @Override
    public DycActivityUserInfo batchSelectActivityUser(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO) || null == reqBO.getActivityId()) {
            throw new ZTBusinessException("保存内容不能为空或者活动id不能为空！");
        }
        if (CollectionUtils.isEmpty(reqBO.getActivityUserList())) {
            throw new ZTBusinessException("保存内容用户信息不能为空！");
        }
        List<ActivityUserInfoPO> collect = reqBO.getActivityUserList().stream().map(item -> {
            ActivityUserInfoPO activityUserInfoPO = new ActivityUserInfoPO();
            BeanUtils.copyProperties(item, activityUserInfoPO);
            activityUserInfoPO.setActivityId(reqBO.getActivityId());
            activityUserInfoPO.setCreateUserId(reqBO.getCreateUserId());
            activityUserInfoPO.setCreateUserName(reqBO.getCreateUserName());
            activityUserInfoPO.setCreateTime(new Date());
            activityUserInfoPO.setId(Sequence.getInstance().nextId());
            activityUserInfoPO.setDelFlag(0);

            activityUserInfoPO.setUserId(reqBO.getActUserId());
            activityUserInfoPO.setUserName(reqBO.getActUserName());
            activityUserInfoPO.setName(reqBO.getActName());
            activityUserInfoPO.setWorkNo(reqBO.getActWorkNo());
            activityUserInfoPO.setUserOrgId(reqBO.getActUserOrgId());
            activityUserInfoPO.setUserOrgName(reqBO.getActUserOrgName());
            return activityUserInfoPO;
        }).collect(Collectors.toList());
        int i = activityUserInfoMapper.allInsert(collect);
        if (reqBO.getActivityUserList().size() != i) {
            throw new ZTBusinessException("保存内容用户添加失败！");
        }
        return new DycActivityUserInfo();
    }

    @Override
    public DycActivityUserInfo batchRemoveActivityUser(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO) || null == reqBO.getActivityId()) {
            throw new ZTBusinessException("保存内容不能为空或者活动id不能为空！");
        }
        if (CollectionUtils.isEmpty(reqBO.getUserIdList())) {
            throw new ZTBusinessException("移除列表用户id不能为空！");
        }
        ActivityUserInfoPO userInfoPO = new ActivityUserInfoPO();
        userInfoPO.setActivityId(reqBO.getActivityId());
        userInfoPO.setUpdateUserId(reqBO.getUpdateUserId());
        userInfoPO.setUpdateUserName(reqBO.getUpdateUserName());
        userInfoPO.setUpdateTime(new Date());
        activityUserInfoMapper.batchRemoveActivityUser(reqBO.getUserIdList(), userInfoPO);

        return new DycActivityUserInfo();
    }

    @Override
    public DycActivityUserInfo modifyActivityUserScores(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO) || null == reqBO.getActivityId()) {
            throw new ZTBusinessException("保存内容不能为空或者活动id不能为空！");
        }
        if (null == reqBO.getActUserId()) {
            throw new ZTBusinessException("发放对应用户id为不能为空！");
        }
        if (null == reqBO.getGiveScores() || BigDecimal.ZERO.compareTo(reqBO.getGiveScores()) > 0) {
            throw new ZTBusinessException("发放积分不能为空或者积分不能小于0！");
        }
        ActivityUserInfoPO activityUserInfoPO = new ActivityUserInfoPO();
        BeanUtils.copyProperties(reqBO, activityUserInfoPO);
        activityUserInfoPO.setUserId(reqBO.getActUserId());
        activityUserInfoPO.setUpdateTime(new Date());
        int i = activityUserInfoMapper.update(activityUserInfoPO);
        if (1 != i) {
            throw new ZTBusinessException("积分修改失败！");
        }
        return new DycActivityUserInfo();
    }

    @Override
    public DycActivityUserInfo batchModifyActivityUserScores(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO) || null == reqBO.getActivityId()) {
            throw new ZTBusinessException("保存内容不能为空或者活动id不能为空！");
        }
        if (null == reqBO.getGiveScores() || BigDecimal.ZERO.compareTo(reqBO.getGiveScores()) > 0) {
            throw new ZTBusinessException("批量发放积分不能为空或者积分不能小于0！");
        }
        ActivityUserInfoPO activityUserInfoPO = new ActivityUserInfoPO();
        BeanUtils.copyProperties(reqBO, activityUserInfoPO);
        activityUserInfoPO.setUpdateTime(new Date());
        activityUserInfoMapper.update(activityUserInfoPO);
        return new DycActivityUserInfo();
    }

    @Override
    public BasePageRspBo<DycActivityUserScoresUseRecordInfo> queryActivityUserScoresUseRecordPageList(DycActivityDO reqBO) {
        BasePageRspBo<DycActivityUserScoresUseRecordInfo> rspBo = new BasePageRspBo<>();
        List<DycActivityUserScoresUseRecordInfo> rows = new ArrayList<>();
        ActivityUserScoresUseRecordTimePO activityUserScoresUseRecordTimePO = JSON.parseObject(JSON.toJSONString(reqBO), ActivityUserScoresUseRecordTimePO.class);
        Page<ActivityUserScoresUseRecordPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.activityUserScoresUseRecordMapper.queryActivityUserScoresUseRecordPageList(activityUserScoresUseRecordTimePO));
        if (ObjectUtils.isEmpty(page)) {
            rspBo.setPageNo(reqBO.getPageNo());
            rspBo.setTotal(0);
            rspBo.setRecordsTotal(0);
            rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
            rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
            return rspBo;
        }
        for (ActivityUserScoresUseRecordPO activityUserScoresUseRecordPO : page.getResult()) {
            DycActivityUserScoresUseRecordInfo dycActivityUserScoresUseRecordInfo = JSON.parseObject(JSON.toJSONString(activityUserScoresUseRecordPO), DycActivityUserScoresUseRecordInfo.class);
            dycActivityUserScoresUseRecordInfo.setUseTypeStr(DycActivityTransFieldUtil.UseType(dycActivityUserScoresUseRecordInfo.getUseType()));
            dycActivityUserScoresUseRecordInfo.setActUserId(activityUserScoresUseRecordPO.getUserId());
            dycActivityUserScoresUseRecordInfo.setActUserName(activityUserScoresUseRecordPO.getUserName());
            dycActivityUserScoresUseRecordInfo.setActName(activityUserScoresUseRecordPO.getName());
            rows.add(dycActivityUserScoresUseRecordInfo);
        }
        rspBo.setRows(rows);
        rspBo.setPageNo(page.getPageNum());
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int) page.getTotal());
        rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBo;
    }

    @Override
    public int deductOrReturnActivityScores(DycActivityDO reqBO) {
        ActivityUserInfoPO activityUserInfoPO = JSON.parseObject(JSON.toJSONString(reqBO), ActivityUserInfoPO.class);
        List<ActivityUserInfoPO> activityUserInfoPOS = activityUserInfoMapper.selectByCondition(activityUserInfoPO);
        if (activityUserInfoPOS.size() < 1) {
            throw new ZTBusinessException("没有此用户");
        }
        ActivityUserInfoPO activityUserInfoPO1 = activityUserInfoPOS.get(0);
        //流水新增
        ActivityUserScoresUseRecordPO activityUserScoresUseRecordPO = new ActivityUserScoresUseRecordPO();
        activityUserScoresUseRecordPO.setBeforeUseScores(activityUserInfoPO1.getBalanceScores());
        if ("2".equals(reqBO.getOperType())) {
            if (activityUserInfoPO1.getBalanceScores().compareTo(reqBO.getUseScores()) < 0) {
                throw new ZTBusinessException("积分不够不能消费");
            }
            activityUserInfoPO1.setBalanceScores(activityUserInfoPO1.getBalanceScores().subtract(reqBO.getUseScores()));
            activityUserInfoPO1.setUsedScores(activityUserInfoPO1.getUsedScores().add(reqBO.getUseScores()));
        } else if ("3".equals(reqBO.getOperType())) {
            activityUserInfoPO1.setBalanceScores(activityUserInfoPO1.getBalanceScores().add(reqBO.getUseScores()));
            activityUserInfoPO1.setUsedScores(activityUserInfoPO1.getUsedScores().subtract(reqBO.getUseScores()));
        } else {
            throw new ZTBusinessException("操作异常");
        }
        activityUserInfoMapper.update(activityUserInfoPO1);

        activityUserScoresUseRecordPO.setRecordId(Sequence.getInstance().nextId());
        activityUserScoresUseRecordPO.setActivityId(reqBO.getActivityId());
        activityUserScoresUseRecordPO.setActivityName(reqBO.getActivityName());
        activityUserScoresUseRecordPO.setUserId(activityUserInfoPO1.getUserId());
        activityUserScoresUseRecordPO.setUserName(activityUserInfoPO1.getUserName());
        activityUserScoresUseRecordPO.setName(activityUserInfoPO1.getName());
        activityUserScoresUseRecordPO.setUseType(reqBO.getOperType());
        activityUserScoresUseRecordPO.setObjId(reqBO.getObjId());
        activityUserScoresUseRecordPO.setObjType(reqBO.getObjType());
        activityUserScoresUseRecordPO.setUseScores(reqBO.getUseScores());
        activityUserScoresUseRecordPO.setAfterUseScores(activityUserInfoPO1.getBalanceScores());
        activityUserScoresUseRecordPO.setUseTime(reqBO.getUseTime());
        activityUserScoresUseRecordPO.setUseUserId(reqBO.getUseUserId());
        activityUserScoresUseRecordPO.setUseUserName(reqBO.getUseUserName());
        activityUserScoresUseRecordPO.setCreateTime(new Date());
        activityUserScoresUseRecordPO.setCreateUserId(reqBO.getUseUserId());
        activityUserScoresUseRecordPO.setCreateUserName(reqBO.getUseUserName());
        return activityUserScoresUseRecordMapper.insert(activityUserScoresUseRecordPO);
    }
}
