package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.model.bo.DycActivityFlowTaskInfo;
import com.tydic.dyc.act.model.bo.DycProcessDO;
import com.tydic.dyc.act.repository.api.DycActivityFlowTaskRepository;
import com.tydic.dyc.act.repository.dao.ActivityFlowTaskMapper;
import com.tydic.dyc.act.repository.po.ActivityFlowTaskPO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service
public class DycActivityFlowTaskRepositoryImpl implements DycActivityFlowTaskRepository {

    @Autowired
    ActivityFlowTaskMapper activityFlowTaskMapper;

    @Override
    public DycActivityFlowTaskInfo queryActivityFlowTaskSingle(DycProcessDO activityFlowTaskReqBO) {
        DycActivityFlowTaskInfo rspBO = new DycActivityFlowTaskInfo();
        ActivityFlowTaskPO selectActivityFlowTaskPO = new ActivityFlowTaskPO();
        BeanUtils.copyProperties(activityFlowTaskReqBO, selectActivityFlowTaskPO);
        List<ActivityFlowTaskPO> activityFlowTaskList = this.activityFlowTaskMapper.selectByCondition(selectActivityFlowTaskPO);
        if (activityFlowTaskList.size() == 1) {
            rspBO = JSON.parseObject(JSON.toJSONString(activityFlowTaskList.get(0)), DycActivityFlowTaskInfo.class);
        }
        return rspBO;
    }

    @Override
    public List<DycActivityFlowTaskInfo> queryActivityFlowTaskList(DycProcessDO activityFlowTaskReqBO) {
        List<DycActivityFlowTaskInfo> rspBO = new ArrayList<>();
        ActivityFlowTaskPO selectActivityFlowTaskPO = new ActivityFlowTaskPO();
        BeanUtils.copyProperties(activityFlowTaskReqBO, selectActivityFlowTaskPO);
        List<ActivityFlowTaskPO> activityFlowTaskPOList = this.activityFlowTaskMapper.selectByCondition(selectActivityFlowTaskPO);

        rspBO = JSON.parseArray(JSON.toJSONString(activityFlowTaskPOList), DycActivityFlowTaskInfo.class);
        return rspBO;
    }

    @Override
    public int addActivityFlowTask(DycProcessDO activityFlowTaskReqBO) {

        ActivityFlowTaskPO insertActivityFlowTaskPO = new ActivityFlowTaskPO();
        BeanUtils.copyProperties(activityFlowTaskReqBO, insertActivityFlowTaskPO);
        long id = Sequence.getInstance().nextId();
        insertActivityFlowTaskPO.setId(id);
        return activityFlowTaskMapper.insert(insertActivityFlowTaskPO);
    }


    @Override
    public int addListActivityFlowTask(DycProcessDO activityFlowTaskReqBO) {
        List<DycActivityFlowTaskInfo> flowTaskInfosList = activityFlowTaskReqBO.getFlowTaskInfosList();

        List<ActivityFlowTaskPO> insertActivityFlowTaskPO = JSONObject.parseArray(JSONObject.toJSONString(flowTaskInfosList), ActivityFlowTaskPO.class);
        for (ActivityFlowTaskPO activityFlowTaskPO : insertActivityFlowTaskPO) {
            activityFlowTaskPO.setId(Sequence.getInstance().nextId());
            activityFlowTaskPO.setTaskStatus(1);
            activityFlowTaskPO.setTaskCreateTime(new Date());
            activityFlowTaskPO.setDelFlag(0);
        }
        return activityFlowTaskMapper.allInsert(insertActivityFlowTaskPO);
    }

    @Override
    public int updateActivityFlowTask(DycProcessDO activityFlowTaskReqBO) {
        int num = 0;
        ActivityFlowTaskPO updateActivityFlowTaskPO = new ActivityFlowTaskPO();
        BeanUtils.copyProperties(activityFlowTaskReqBO.getFlowTaskInfosList(), updateActivityFlowTaskPO);
        num = this.activityFlowTaskMapper.update(updateActivityFlowTaskPO);
        return num;
    }


    @Override
    public int deleteActivityFlowTask(DycProcessDO activityFlowTaskReqBO) {
        ActivityFlowTaskPO selectActivityFlowTaskPO = new ActivityFlowTaskPO();
        BeanUtils.copyProperties(activityFlowTaskReqBO, selectActivityFlowTaskPO);
        int num = 0;
        List<ActivityFlowTaskPO> activityFlowTaskList = this.activityFlowTaskMapper.selectByCondition(selectActivityFlowTaskPO);
        if (activityFlowTaskList.size() == 1) {
            ActivityFlowTaskPO deleteActivityFlowTaskPO = new ActivityFlowTaskPO();
            BeanUtils.copyProperties(activityFlowTaskReqBO, deleteActivityFlowTaskPO);

            num = this.activityFlowTaskMapper.delete(deleteActivityFlowTaskPO);
        }
        return num;
    }

}
