package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.bo.DycActIaborDO;
import com.tydic.dyc.act.model.bo.DycActLaborUnionInfo;
import com.tydic.dyc.act.model.bo.DycActLaborUnionRelaOrgInfo;
import com.tydic.dyc.act.repository.api.DycActlaborRepository;
import com.tydic.dyc.act.repository.dao.ActLaborUnionInfoMapper;
import com.tydic.dyc.act.repository.dao.ActLaborUnionRelaOrgMapper;
import com.tydic.dyc.act.repository.po.ActLaborUnionInfoPO;
import com.tydic.dyc.act.repository.po.ActLaborUnionRelaOrgPO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 标题：DycActlaborRepositoryImpl
 * 说明：
 * 时间： 2024-03-26 15:47
 * 作者 @author LY
 */
@Service
public class DycActlaborRepositoryImpl implements DycActlaborRepository {

    @Autowired
    ActLaborUnionInfoMapper actLaborUnionInfoMapper;
    @Autowired
    ActLaborUnionRelaOrgMapper actLaborUnionRelaOrgMapper;

    @Override
    public Long addActLaborUnionInfo(DycActIaborDO reqBO) {
        ActLaborUnionInfoPO selectBO = new ActLaborUnionInfoPO();
        selectBO.setLaborUnionName(reqBO.getLaborUnionName());
        List<ActLaborUnionInfoPO> infoPOS = actLaborUnionInfoMapper.selectByCondition(selectBO);
        if (!CollectionUtils.isEmpty(infoPOS)) {
            throw new ZTBusinessException("工会名存在相同！");
        }

        ActLaborUnionInfoPO insertActLaborUnionInfoPO = new ActLaborUnionInfoPO();
        BeanUtils.copyProperties(reqBO, insertActLaborUnionInfoPO);
        long id = Sequence.getInstance().nextId();
        insertActLaborUnionInfoPO.setId(id);
        insertActLaborUnionInfoPO.setLaborUnionId(id);
        insertActLaborUnionInfoPO.setCreateTime(new Date());
        insertActLaborUnionInfoPO.setDelFlag(0);
        actLaborUnionInfoMapper.insert(insertActLaborUnionInfoPO);
        return id;
    }

    @Override
    public int addListActLaborUnionRelaOrg(DycActIaborDO reqBO) {
        List<ActLaborUnionRelaOrgPO> relaOrgPOS = JSON.parseArray(JSON.toJSONString(reqBO.getRelaOrgList()), ActLaborUnionRelaOrgPO.class);
        List<ActLaborUnionRelaOrgPO> collect = relaOrgPOS.stream().map(item -> {
            item.setId(Sequence.getInstance().nextId());
            item.setLaborUnionId(reqBO.getLaborUnionId());
            item.setCreateTime(new Date());
            item.setCreateUserId(reqBO.getCreateUserId());
            item.setCreateUserName(reqBO.getCreateUserName());
            item.setDelFlag(0);
            return item;
        }).collect(Collectors.toList());
        return actLaborUnionRelaOrgMapper.allInsert(collect);
    }

    @Override
    public int updateActLaborUnionInfo(DycActIaborDO reqBO) {
        ActLaborUnionInfoPO infoPO = new ActLaborUnionInfoPO();
        infoPO.setLaborUnionId(reqBO.getLaborUnionId());
        List<ActLaborUnionInfoPO> unionInfoPOS = actLaborUnionInfoMapper.selectByCondition(infoPO);
        //针对于修改了机构并没有修改工会名
        if (!unionInfoPOS.get(0).getLaborUnionName().equals(reqBO.getLaborUnionName())) {
            ActLaborUnionInfoPO selectBO = new ActLaborUnionInfoPO();
            selectBO.setLaborUnionName(reqBO.getLaborUnionName());
            List<ActLaborUnionInfoPO> infoPOS = actLaborUnionInfoMapper.selectByCondition(selectBO);
            if (!CollectionUtils.isEmpty(infoPOS)) {
                throw new ZTBusinessException("工会名存在相同！");
            }
        }
        ActLaborUnionInfoPO updateBO = new ActLaborUnionInfoPO();
        BeanUtils.copyProperties(reqBO, updateBO);
        updateBO.setUpdateTime(new Date());
        return actLaborUnionInfoMapper.update(updateBO);
    }

    @Override
    public int deleteListActLaborUnionRelaOrg(DycActIaborDO reqBO) {
        ActLaborUnionRelaOrgPO deleteBO = new ActLaborUnionRelaOrgPO();
        deleteBO.setLaborUnionId(reqBO.getLaborUnionId());
        deleteBO.setDelFlag(1);
        deleteBO.setUpdateTime(new Date());
        deleteBO.setUpdateUserId(reqBO.getUpdateUserId());
        deleteBO.setUpdateUserName(reqBO.getUpdateUserName());
        return actLaborUnionRelaOrgMapper.update(deleteBO);
    }

    @Override
    public int deleteActLaborUnionInfo(DycActIaborDO reqBO) {
        ActLaborUnionInfoPO unionInfoPO = new ActLaborUnionInfoPO();
        unionInfoPO.setLaborUnionId(reqBO.getLaborUnionId());
        unionInfoPO.setDelFlag(1);
        unionInfoPO.setUpdateTime(new Date());
        unionInfoPO.setUpdateUserId(reqBO.getUpdateUserId());
        unionInfoPO.setUpdateUserName(reqBO.getUpdateUserName());
        return actLaborUnionInfoMapper.update(unionInfoPO);
    }

    @Override
    public BasePageRspBo<DycActLaborUnionInfo> queryLaborUnionPageList(DycActIaborDO reqBO) {
        ActLaborUnionInfoPO unionInfoPO = new ActLaborUnionInfoPO();
        BasePageRspBo<DycActLaborUnionInfo> rspPage = new BasePageRspBo<>();
        BeanUtils.copyProperties(reqBO, unionInfoPO);

        Page<ActLaborUnionInfoPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.actLaborUnionInfoMapper.selectlaborAndOrg(unionInfoPO));

        if (ObjectUtils.isEmpty(page)) {
            rspPage.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
            rspPage.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
            return rspPage;
        }

        List<DycActLaborUnionInfo> laborUnionInfos = new ArrayList<>();
        for (ActLaborUnionInfoPO infoPO : page.getResult()) {
            DycActLaborUnionInfo actLaborUnionInfo = new DycActLaborUnionInfo();
            BeanUtils.copyProperties(infoPO, actLaborUnionInfo);
            laborUnionInfos.add(actLaborUnionInfo);
        }

        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(laborUnionInfos);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        rspPage.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspPage.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspPage;
    }

    @Override
    public DycActLaborUnionInfo queryActLaborUnionInfo(DycActIaborDO reqBO) {
        ActLaborUnionInfoPO unionInfoPO = new ActLaborUnionInfoPO();
        unionInfoPO.setLaborUnionId(reqBO.getLaborUnionId());
        List<ActLaborUnionInfoPO> actLaborUnionInfoPOS = actLaborUnionInfoMapper.selectByCondition(unionInfoPO);
        if (CollectionUtils.isEmpty(actLaborUnionInfoPOS) || actLaborUnionInfoPOS.size() > 1) {
            throw new ZTBusinessException("工会不存在或者存在多条！");
        }
        DycActLaborUnionInfo rspBO = new DycActLaborUnionInfo();
        BeanUtils.copyProperties(actLaborUnionInfoPOS.get(0), rspBO);
        return rspBO;
    }

    @Override
    public DycActLaborUnionInfo queryListActLaborUnionRelaOrg(DycActIaborDO reqBO) {
        ActLaborUnionRelaOrgPO relaOrgPO = new ActLaborUnionRelaOrgPO();
        relaOrgPO.setLaborUnionId(reqBO.getLaborUnionId());
        List<ActLaborUnionRelaOrgPO> relaOrgPOS = actLaborUnionRelaOrgMapper.selectByCondition(relaOrgPO);
        DycActLaborUnionInfo rspBO = new DycActLaborUnionInfo();
        List<DycActLaborUnionRelaOrgInfo> collect = relaOrgPOS.stream().map(item -> {
            DycActLaborUnionRelaOrgInfo info = new DycActLaborUnionRelaOrgInfo();
            BeanUtils.copyProperties(item, info);
            return info;
        }).collect(Collectors.toList());
        rspBO.setRelaOrgList(collect);
        return rspBO;
    }
}
