package com.tydic.dyc.act.repository.po;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @ClassName: ActivityChangeInfoPO
 * @Description: ActivityChangeInfoPO
 * @author: zhoulu
 * @date: 2023年12月11日16:43:59
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class ActivityChangeInfoTimePO extends ActivityChangeInfoPO implements Serializable {

	private static final long serialVersionUID = -3256596967059828465L;
	/**
	 * 变更开始时间
	 */
	private Date createStartTime;
	/**
	 * 变更结束时间
	 */
	private Date createEndTime;
	/**
	 * 当前登录人Id
	 */
	private Long userId;
	/**
	 * 页签Id：1：待审批；2：已审批；3：全部
	 */
	private String tabId;
	/**
	 * 活动变更人名称
	 */
	private String changeUserName;
	/**
	 * 活动编号
	 */
	private String activityCode;
	/**
	 * 活动开始开始时间
	 */
	private Date activityStartStartTime;
	/**
	 * 活动开始结束时间
	 */
	private Date activityStartEndTime;
	/**
	 * 活动更新开始时间
	 */
	private Date updateStartTime;
	/**
	 * 活动更新结束时间
	 */
	private Date updateEndTime;
	/**
	 * 当前节点状态1审批中2已审批
	 */
	private Integer CurrentNodeStatus;
}