package com.tydic.dyc.act.repository.dao;

import com.tydic.dyc.act.repository.po.ActFscOrderRelationPO;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

import java.math.BigDecimal;
import java.util.List;

/**
 * @ClassName: ActFscOrderRelationMapper
 * @Description: ActFscOrderRelationMapper
 * @author: liaoyang
 * @date: 2024年04月02日20:05:25
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Mapper
@Repository
public interface ActFscOrderRelationMapper {

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActFscOrderRelationPO>
     * @author: liaoyang
     * @date: 2024年04月02日20:05:25
     */
    List<ActFscOrderRelationPO> selectByCondition(ActFscOrderRelationPO record);

    /**
     * 描述: 根据条件删除
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年04月02日20:05:25
     */
    int delete(ActFscOrderRelationPO record);

    /**
     * 描述: 插入单条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年04月02日20:05:25
     */
    int insert(ActFscOrderRelationPO record);

    /**
     * 描述: 插入多条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年04月02日20:05:25
     */
    int allInsert(List<ActFscOrderRelationPO> record);

    /**
     * 描述: 更新单条数据（可选择的）
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年04月02日20:05:25
     */
    int update(ActFscOrderRelationPO record);

    /**
     * 统计结算单下的订单数量
     * @param record
     * @return
     */
    int getFscOrderNum(ActFscOrderRelationPO record);

    /**
     * 保存订单和结算单关系
     * @param record
     * @return
     */
    int insertSelectData(ActFscOrderRelationPO record);

    /**
     * 更新批次号
     * @param record
     * @return
     */
    int updateBatchId(ActFscOrderRelationPO record);

    /**
     * 统计指定订单的总金额
     * @param record
     * @return
     */
    BigDecimal getCurrentAmt(ActFscOrderRelationPO record);
}
