package com.tydic.dyc.act.repository.dao;

import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.po.ActOrderAfsUniInfo;
import com.tydic.dyc.act.repository.po.ActOrderUniInfo;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @ClassName: ActOrderInfoMapper
 * @Description: ActOrderInfoMapper
 * @author: liaoyang
 * @date: 2024年04月02日10:25:15
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Mapper
@Repository
public interface ActOrderInfoMapperUni {

    /**
     * 描述: 根据条件查询订单
     *
     * @throws
     * @param: po
     * @return: List<ActOrderInfoPO>
     * @author: liaoyang
     * @date: 2024年04月02日10:25:15
     */
    List<ActOrderUniInfo> selectOrdInfoPageByCond(DycActOrderQryDO record);

    /**
     * 描述: 根据条件查询服务单
     *
     * @throws
     * @param: po
     * @return: List<ActOrderInfoPO>
     * @author: liaoyang
     * @date: 2024年04月02日10:25:15
     */
    List<ActOrderAfsUniInfo> selectOrdAfsInfoPageByCond(DycActOrderAfsQryDO record);

    /**
     * 根据条件查询已存在未处理的预警订单数据
     * @param dycActDealAlertQryOrderDO
     * @return
     */
    List<ActAlertOrderInfo> qryExistAlertOrderList(DycActDealAlertQryOrderDO dycActDealAlertQryOrderDO);
    /**
     * 根据条件查询已存在未处理的预警服务单数据
     * @param dycActDealAlertQryOrderDO
     * @return
     */
    List<ActAlertAfsOrderInfo> qryExistAlertAfsOrderList(DycActDealAlertQryOrderDO dycActDealAlertQryOrderDO);
}
