package com.tydic.dyc.act.repository.dao;

import com.tydic.dyc.act.repository.po.ActSkuGuideExtPO;
import com.tydic.dyc.act.repository.po.ActSkuGuidePO;
import java.util.List;

/**
 * @ClassName: ActSkuGuideMapper
 * @Description: ActSkuGuideMapper
 * @author: zhouhaifeng
 * @date: 2024年04月02日14:48:30
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface ActSkuGuideMapper {

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActSkuGuidePO>
     * @author: zhouhaifeng
     * @date: 2024年04月02日14:48:30
     */
    List<ActSkuGuidePO> selectByCondition(ActSkuGuidePO record);

    /**
     * 描述: 根据条件删除
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhouhaifeng
     * @date: 2024年04月02日14:48:30
     */
    int delete(ActSkuGuidePO record);

    /**
     * 描述: 插入单条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhouhaifeng
     * @date: 2024年04月02日14:48:30
     */
    int insert(ActSkuGuidePO record);

    /**
     * 描述: 插入多条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhouhaifeng
     * @date: 2024年04月02日14:48:30
     */
    int allInsert(List<ActSkuGuidePO> record);

    int allInsertCopy(List<ActSkuGuidePO> record);

    /**
     * 描述: 更新单条数据（可选择的）
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhouhaifeng
     * @date: 2024年04月02日14:48:30
     */
    int update(ActSkuGuidePO record);

     List<ActSkuGuideExtPO> selectGuideTree(ActSkuGuideExtPO po);

    List<ActSkuGuideExtPO> getCatalogBOByCatalogIds(ActSkuGuideExtPO po);

    /**
     * 修改排序
     */
    int modifyOrder(ActSkuGuideExtPO uccCatalogDealPO);

    List<ActSkuGuideExtPO> selectByIds(ActSkuGuideExtPO record);
}
