package com.tydic.dyc.act.repository.dao;

import com.tydic.dyc.act.repository.po.ActivityBaseInfoPO;
import com.tydic.dyc.act.repository.po.ActivityBaseInfoTimePO;
import com.tydic.dyc.act.repository.po.DycActActivityApproveBaseInfoPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @ClassName: ActivityBaseInfoMapper
 * @Description: ActivityBaseInfoMapper
 * @author: zhoulu
 * @date: 2023年12月11日16:44:00
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Mapper
@Repository
public interface ActivityBaseInfoMapper {

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActivityBaseInfoPO>
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    List<ActivityBaseInfoPO> selectByCondition(ActivityBaseInfoPO record);

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActivityBaseInfoPO>
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    List<ActivityBaseInfoPO> selectByTabId(ActivityBaseInfoPO record);

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActivityBaseInfoPO>
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    List<ActivityBaseInfoPO> autoLoseEffectActivity();

    /**
     * 描述: 根据条件删除
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    int delete(ActivityBaseInfoPO record);

    /**
     * 描述: 插入单条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    int insert(ActivityBaseInfoPO record);

    /**
     * 描述: 插入多条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    int allInsert(List<ActivityBaseInfoPO> record);

    /**
     * 描述: 更新单条数据（可选择的）
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    int update(ActivityBaseInfoPO record);

    /**
     * 活动删除服务
     * @param activityBaseInfoPO
     * @return
     */
    int deleteActivity(ActivityBaseInfoPO activityBaseInfoPO);

    /**
     * 活动自动生效定时任务服务
     * @param activityBaseInfoPO
     * @return
     */
    List<ActivityBaseInfoPO> selectAutoEffectActivity(ActivityBaseInfoPO activityBaseInfoPO);

    /**
     * 批量修改（活动id）
     * @param record
     * @return
     */
    int batchUpdate(List<ActivityBaseInfoPO> record);

    /**
     * 活动审批列表查询（分页）服务
     * @param activityBaseInfoTimePO
     * @return
     */
    List<DycActActivityApproveBaseInfoPO> queryActivityApprovePageList(@Param("activityBaseInfoTimePO") ActivityBaseInfoTimePO activityBaseInfoTimePO,@Param("status") List<Integer> status);

    /**
     * 描述: 活动基本详情查询
     *
     * @param activityBaseInfoPo
     * @return com.tydic.dyc.act.model.bo.DycActivityFileInfo
     */
    ActivityBaseInfoPO qryActiveBaseInfo(ActivityBaseInfoPO activityBaseInfoPo);

    ActivityBaseInfoPO getActivityBaseInfoDetail(ActivityBaseInfoPO qryInfoPo);

    /**
     * 插入单条数据
     *
     * @param activityBaseInfoPo 参数对象
     * @return int 影响数量
     */
    int insertNew(ActivityBaseInfoPO activityBaseInfoPo);

    /**
     * 根据条件更新数据
     *
     * @param set set新值
     * @param where where条件（旧值）
     * @return int 影响数量
     */
    int updateBy(@Param("set") ActivityBaseInfoPO set, @Param("where") ActivityBaseInfoPO where);

    /**
     * 根据条件校验有多少条数据
     *
     * @param activityBaseInfoPo 参数对象
     * @return int 总数量
     */
    int getCheckBy(ActivityBaseInfoPO activityBaseInfoPo);

    /**
     * 根据条件查询单条数据
     *
     * @param activityBaseInfoPo 参数对象
     * @return ActActivityBaseInfoPO 结果对象
     */
    ActivityBaseInfoPO getModelBy(ActivityBaseInfoPO activityBaseInfoPo);

    /**
     * 根据条件查询列表数据
     *
     * @param activityBaseInfoPo 参数对象
     * @return List<ActActivityBaseInfoPO> 结果对象
     */
    List<ActivityBaseInfoPO> getList(ActivityBaseInfoPO activityBaseInfoPo);

    /**
     * 批量插入数据
     *
     * @param list 参数列表
     */
    void insertBatch(List<ActivityBaseInfoPO> list);
}
