package com.tydic.dyc.act.repository.dao;

import com.tydic.dyc.act.repository.po.ActActivityChangeCommodityInfoPO;
import com.tydic.dyc.act.repository.po.ActActivityChangeCommodityInfoQryPO;
import com.tydic.dyc.act.repository.po.ActivityChangeRelaCommodityPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @ClassName: ActivityChangeRelaCommodityMapper
 * @Description: ActivityChangeRelaCommodityMapper
 * @author: zhoulu
 * @date: 2023年12月11日16:43:59
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Mapper
@Repository
public interface ActivityChangeRelaCommodityMapper {

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActivityChangeRelaCommodityPO>
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    List<ActivityChangeRelaCommodityPO> selectByCondition(ActActivityChangeCommodityInfoQryPO record);

    /**
     * 描述: 根据条件删除
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    int delete(ActivityChangeRelaCommodityPO record);

    /**
     * 描述: 插入单条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    int insert(ActivityChangeRelaCommodityPO record);

    /**
     * 描述: 插入多条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    int allInsert(List<ActivityChangeRelaCommodityPO> record);

    /**
     * 描述: 更新单条数据（可选择的）
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    int update(ActivityChangeRelaCommodityPO record);

    /**
     * 活动变更商品移除（批量）服务
     * @param list
     * @return
     */
    int batchRemoveActivityChangeCommodity(List<ActivityChangeRelaCommodityPO> list);

    /**
     * 活动变更已选商品列表查询
     * @param qryPO
     * @return
     */
    List<ActActivityChangeCommodityInfoPO> getChangeRelaCommodityList(ActActivityChangeCommodityInfoQryPO qryPO);

    /**
     * 插入单条数据
     *
     * @param activityChangeRelaCommodityPo 参数对象
     * @return int 影响数量
     */
    int insertNew(ActivityChangeRelaCommodityPO activityChangeRelaCommodityPo);

    /**
     * 根据条件更新数据
     *
     * @param set set新值
     * @param where where条件（旧值）
     * @return int 影响数量
     */
    int updateBy(@Param("set") ActivityChangeRelaCommodityPO set, @Param("where") ActivityChangeRelaCommodityPO where);

    /**
     * 根据条件校验有多少条数据
     *
     * @param activityChangeRelaCommodityPo 参数对象
     * @return int 总数量
     */
    int getCheckBy(ActivityChangeRelaCommodityPO activityChangeRelaCommodityPo);

    /**
     * 根据条件查询单条数据
     *
     * @param activityChangeRelaCommodityPo 参数对象
     * @return ActActivityChangeRelaCommodityPO 结果对象
     */
    ActivityChangeRelaCommodityPO getModelBy(ActivityChangeRelaCommodityPO activityChangeRelaCommodityPo);

    /**
     * 根据条件查询列表数据
     *
     * @param activityChangeRelaCommodityPo 参数对象
     * @return List<ActActivityChangeRelaCommodityPO> 结果对象
     */
    List<ActivityChangeRelaCommodityPO> getList(ActivityChangeRelaCommodityPO activityChangeRelaCommodityPo);

    /**
     * 批量插入数据
     *
     * @param list 参数列表
     */
    void insertBatch(List<ActivityChangeRelaCommodityPO> list);
}
