package com.tydic.dyc.act.repository.dao;

import com.tydic.dyc.act.repository.po.ActivityRelaCommodityPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @ClassName: ActivityRelaCommodityMapper
 * @Description: ActivityRelaCommodityMapper
 * @author: zhoulu
 * @date: 2023年12月11日16:44:00
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Mapper
@Repository
public interface ActivityRelaCommodityMapper {

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActivityRelaCommodityPO>
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    List<ActivityRelaCommodityPO> selectByCondition(ActivityRelaCommodityPO record);

    /**
     * 描述: 根据条件删除
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    int delete(ActivityRelaCommodityPO record);

    /**
     * 描述: 插入单条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    int insert(ActivityRelaCommodityPO record);

    /**
     * 描述: 插入多条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    int allInsert(List<ActivityRelaCommodityPO> record);

    /**
     * 描述: 更新单条数据（可选择的）
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    int update(ActivityRelaCommodityPO record);

    /**
     * 批量删除数据（根据商品id和活动id）
     * @param record
     * @return
     */
    int batchRemoveActivityCommodity(List<ActivityRelaCommodityPO> record);

    int selectCountCommodity(ActivityRelaCommodityPO record);

    /**
     * 插入单条数据
     *
     * @param activityRelaCommodityPo 参数对象
     * @return int 影响数量
     */
    int insertNew(ActivityRelaCommodityPO activityRelaCommodityPo);

    /**
     * 根据条件更新数据
     *
     * @param set set新值
     * @param where where条件（旧值）
     * @return int 影响数量
     */
    int updateBy(@Param("set") ActivityRelaCommodityPO set, @Param("where") ActivityRelaCommodityPO where);

    /**
     * 根据条件校验有多少条数据
     *
     * @param activityRelaCommodityPo 参数对象
     * @return int 总数量
     */
    int getCheckBy(ActivityRelaCommodityPO activityRelaCommodityPo);

    /**
     * 根据条件查询单条数据
     *
     * @param activityRelaCommodityPo 参数对象
     * @return ActActivityRelaCommodityPO 结果对象
     */
    ActivityRelaCommodityPO getModelBy(ActivityRelaCommodityPO activityRelaCommodityPo);

    /**
     * 根据条件查询列表数据
     *
     * @param activityRelaCommodityPo 参数对象
     * @return List<ActActivityRelaCommodityPO> 结果对象
     */
    List<ActivityRelaCommodityPO> getList(ActivityRelaCommodityPO activityRelaCommodityPo);

    /**
     * 批量插入数据
     *
     * @param list 参数列表
     */
    void insertBatch(List<ActivityRelaCommodityPO> list);

    int updateCommodityState(ActivityRelaCommodityPO record);
}
