package com.tydic.dyc.act.repository.impl;

import cn.hutool.core.util.DesensitizedUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.ActConstants;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.bo.ActivityChangeUserInfo;
import com.tydic.dyc.act.model.bo.ActivityChangeUserInfoQryBO;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.model.bo.DycActivityChangeUserInfo;
import com.tydic.dyc.act.repository.api.DycActActivityChangeUserRepository;
import com.tydic.dyc.act.repository.dao.ActivityChangeUserInfoMapper;
import com.tydic.dyc.act.repository.po.ActivityChangeUserInfoPO;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.base.bo.BasePageRspBo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 说明：活动变更用户基建方法〉实现
 *
 * @author zhoulu
 * @date 2023年12月22日 14:25
 */
@Service
public class DycActActivityChangeUserRepositoryImpl implements DycActActivityChangeUserRepository {

    @Autowired
    private ActivityChangeUserInfoMapper activityChangeUserInfoMapper;

    @Value("${LIMIT_SCORES:50000}")
    private BigDecimal LIMIT_SCORES;

    @Override
    public void batchSelectActivityChangeUser(DycActivityChangeDO reqBo) {
        Map<Long, ActivityChangeUserInfoPO> collectMap = null;
        List<ActivityChangeUserInfoPO> changeUserInfoPoList = new ArrayList<>();
        //查询是否有已移除的数据，如果是移除直接制为有效即可
        ActivityChangeUserInfoPO activityChangeUserInfoPo = new ActivityChangeUserInfoPO();
        List<Long> collect = reqBo.getUserList().stream().map(DycActivityChangeUserInfo::getActUserId).collect(Collectors.toList());
        activityChangeUserInfoPo.setUserIdList(collect);
        activityChangeUserInfoPo.setChangeId(reqBo.getChangeId());
        List<ActivityChangeUserInfoPO> activityChangeUserInfoPoList = activityChangeUserInfoMapper.selectByConditionAll(activityChangeUserInfoPo);
        if (!CollectionUtils.isEmpty(activityChangeUserInfoPoList)){
            collectMap = activityChangeUserInfoPoList.stream().collect(Collectors.toMap(ActivityChangeUserInfoPO::getUserId, o -> o));
        }
        for (DycActivityChangeUserInfo item : reqBo.getUserList()) {
            if (collectMap != null && collectMap.get(item.getActUserId()) != null){
                ActivityChangeUserInfoPO activityChangeUserInfoPoUpdate = new ActivityChangeUserInfoPO();
                activityChangeUserInfoPoUpdate.setId(collectMap.get(item.getActUserId()).getId());
                activityChangeUserInfoPoUpdate.setDelFlag(ActConstants.DelFlag.NOT_DEL);
                activityChangeUserInfoMapper.update(activityChangeUserInfoPoUpdate);
            }else {
                ActivityChangeUserInfoPO changeUser = new ActivityChangeUserInfoPO();
                BeanUtils.copyProperties(item, changeUser);
                changeUser.setId(Sequence.getInstance().nextId());
                changeUser.setChangeId(reqBo.getChangeId());
                changeUser.setCreateUserId(reqBo.getCreateUserId());
                changeUser.setCreateUserName(reqBo.getCreateUserName());
                changeUser.setId(Sequence.getInstance().nextId());
                changeUser.setDelFlag(0);
                changeUser.setCreateTime(new Date());
                changeUser.setUserId(item.getActUserId());
                changeUser.setUserName(item.getActUserName());
                changeUser.setName(item.getActName());
                changeUser.setWorkNo(item.getActWorkNo());
                changeUser.setUserOrgId(item.getActUserOrgId());
                changeUser.setUserOrgName(item.getActUserOrgName());
                changeUser.setUpdateUserId(null);
                changeUser.setUpdateUserName(null);
                changeUser.setUpdateTime(null);
                changeUser.setUserCompanyId(item.getActUserCompanyId());
                changeUser.setUserCompanyName(item.getActUserCompanyName());
                changeUser.setUserOrgPath(item.getActUserOrgPath());
                changeUserInfoPoList.add(changeUser);
            }
        }
        if (!CollectionUtils.isEmpty(changeUserInfoPoList)){
            int i = activityChangeUserInfoMapper.allInsert(changeUserInfoPoList);
            if (i != changeUserInfoPoList.size()) {
                throw new ZTBusinessException("变更用户批量添加失败！");
            }
        }
    }

    @Override
    public BasePageRspBo<ActivityChangeUserInfo> queryActivityChangeUserPageList(ActivityChangeUserInfoQryBO reqBo) {
        ActivityChangeUserInfoPO selectActivityChangeUserInfoPo = new ActivityChangeUserInfoPO();
        BeanUtils.copyProperties(reqBo, selectActivityChangeUserInfoPo);
        List<ActivityChangeUserInfo> activityChangeUserInfoBoList = new ArrayList<>();
        BasePageRspBo<ActivityChangeUserInfo> rspPage = new BasePageRspBo<>();
        rspPage.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspPage.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        if(reqBo.getPageNo() == -1 && reqBo.getPageSize() == -1){
            rspPage.setPageNo(1);
            List<ActivityChangeUserInfoPO> list = activityChangeUserInfoMapper.selectByCondition(selectActivityChangeUserInfoPo);
            if(!CollectionUtils.isEmpty(list)){
                makeChangeUserData(list,activityChangeUserInfoBoList);
                rspPage.setRows(activityChangeUserInfoBoList);
                rspPage.setRecordsTotal(activityChangeUserInfoBoList.size());
                rspPage.setTotal(1);
            }else {
                rspPage.setTotal(0);
                rspPage.setRecordsTotal(0);
            }
            rspPage.setRows(activityChangeUserInfoBoList);
        }
        Page<ActivityChangeUserInfoPO> page = PageHelper.startPage(reqBo.getPageNo(), reqBo.getPageSize()).doSelectPage(() -> this.activityChangeUserInfoMapper.selectByCondition(selectActivityChangeUserInfoPo));
        //封装集合
        if(!CollectionUtils.isEmpty(page.getResult())){
            makeChangeUserData(page.getResult(),activityChangeUserInfoBoList);
        }
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(activityChangeUserInfoBoList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        return rspPage;
    }

    /**
     * 变更单用户数据封装
     */
    private void makeChangeUserData( List<ActivityChangeUserInfoPO> list,List<ActivityChangeUserInfo> activityChangeUserInfoBoList){
        for (ActivityChangeUserInfoPO activityChangeUserInfoPo : list) {
            ActivityChangeUserInfo activityChangeUserInfoBo = new ActivityChangeUserInfo();
            BeanUtils.copyProperties(activityChangeUserInfoPo, activityChangeUserInfoBo);
            activityChangeUserInfoBo.setPhone(DesensitizedUtil.mobilePhone(activityChangeUserInfoBo.getPhone()));
            activityChangeUserInfoBoList.add(activityChangeUserInfoBo);
        }
    }

    @Override
    public int batchRemoveActivityChangeUser(DycActivityChangeDO reqBo) {
        ActivityChangeUserInfoPO activityChangeUserInfoPo = new ActivityChangeUserInfoPO();
        BeanUtils.copyProperties(reqBo, activityChangeUserInfoPo);
        activityChangeUserInfoPo.setUpdateTime(new Date());
        int i = activityChangeUserInfoMapper.updateBatchByUserId(reqBo.getUserIdList(), activityChangeUserInfoPo);
        if (i != reqBo.getUserIdList().size()) {
            throw new ZTBusinessException("当前用户已有使用积分，不可进行移除！");
        }
        return i;
    }

    @Override
    public List<ActivityChangeUserInfo> queryChangeActivityUserList(DycActivityChangeDO dycActivityChangeDO) {
        ActivityChangeUserInfoPO activityChangeUserInfoPO = new ActivityChangeUserInfoPO();
        activityChangeUserInfoPO.setChangeId(dycActivityChangeDO.getChangeId());
        if (!CollectionUtils.isEmpty(dycActivityChangeDO.getUserIdList())){
            activityChangeUserInfoPO.setUserIdList(dycActivityChangeDO.getUserIdList());
        }
        List<ActivityChangeUserInfoPO> activityChangeUserInfoPOS = activityChangeUserInfoMapper.selectByCondition(activityChangeUserInfoPO);
        return JSON.parseArray(JSON.toJSONString(activityChangeUserInfoPOS), ActivityChangeUserInfo.class);
    }

    @Override
    public int addChangeUser(DycActivityChangeDO dycActivityUserInfo) {
        ActivityChangeUserInfoPO activityChangeUserInfoPO = JSON.parseObject(JSON.toJSONString(dycActivityUserInfo), ActivityChangeUserInfoPO.class);
        activityChangeUserInfoPO.setCreateTime(new Date());
        activityChangeUserInfoPO.setId(Sequence.getInstance().nextId());
        activityChangeUserInfoPO.setDelFlag(0);
        activityChangeUserInfoPO.setUserId(dycActivityUserInfo.getActUserId());
        activityChangeUserInfoPO.setUserName(dycActivityUserInfo.getActUserName());
        activityChangeUserInfoPO.setName(dycActivityUserInfo.getActName());
        activityChangeUserInfoPO.setWorkNo(dycActivityUserInfo.getActWorkNo());
        return activityChangeUserInfoMapper.insert(activityChangeUserInfoPO);
    }

    @Override
    public void batchModifyActivityChangeUserScores(DycActivityChangeDO dycActivityChangeDo) {
        ActivityChangeUserInfoPO activityChangeUserInfoPo = new ActivityChangeUserInfoPO();
        activityChangeUserInfoPo.setChangeId(dycActivityChangeDo.getChangeId());
        if (dycActivityChangeDo.getUserId() != null) {
            activityChangeUserInfoPo.setUserId(dycActivityChangeDo.getUserId());
        }
        ActivityChangeUserInfoPO activityChangeUserInfoPoModel = activityChangeUserInfoMapper.selectByConditionModel(activityChangeUserInfoPo);
        if (activityChangeUserInfoPoModel == null) {
            throw new ZTBusinessException("没有需要修改的用户");
        }
        //重新计算剩余积分
        BigDecimal balanceScores;
        if (activityChangeUserInfoPoModel.getOriginalScores() != null){
            balanceScores = activityChangeUserInfoPoModel.getOriginalScores().subtract(dycActivityChangeDo.getGiveScores());
            if (activityChangeUserInfoPoModel.getUsedScores() != null){
                balanceScores = balanceScores.subtract(activityChangeUserInfoPoModel.getUsedScores());
            }
        }else {
            balanceScores = dycActivityChangeDo.getGiveScores();
        }
        if (balanceScores.compareTo(BigDecimal.ZERO) < 0){
            throw new ZTBusinessException("积分分配失败，剩余金额小于0");
        }
        ActivityChangeUserInfoPO activityChangeUserInfoPoUpdate = new ActivityChangeUserInfoPO();
        activityChangeUserInfoPoUpdate.setId(activityChangeUserInfoPoModel.getId());
        activityChangeUserInfoPoUpdate.setBalanceScores(balanceScores);
        activityChangeUserInfoPoUpdate.setGiveScores(dycActivityChangeDo.getGiveScores());
        activityChangeUserInfoPoUpdate.setUpdateUserId(dycActivityChangeDo.getUpdateUserId());
        activityChangeUserInfoPoUpdate.setUpdateUserName(dycActivityChangeDo.getUpdateUserName());
        activityChangeUserInfoPoUpdate.setUpdateTime(new Date());
        activityChangeUserInfoMapper.update(activityChangeUserInfoPoUpdate);
    }

    @Override
    public void batchModifyIntegralZeroClearance(DycActivityChangeDO dycActivityChangeDo) {
        ActivityChangeUserInfoPO activityChangeUserInfoPo = JSONObject.parseObject(JSONObject.toJSONString(dycActivityChangeDo), ActivityChangeUserInfoPO.class);
        activityChangeUserInfoMapper.batchModifyIntegralZeroClearance(activityChangeUserInfoPo);
    }

    @Override
    public DycActivityChangeDO qryUserInfoLimitScore(DycActivityChangeDO dycActivityChangeDo) {
        //初始化返回参数
        DycActivityChangeDO dycActivityChangeDoModel = new DycActivityChangeDO();
        ActivityChangeUserInfoPO po = new ActivityChangeUserInfoPO();
        po.setChangeId(dycActivityChangeDo.getChangeId());
        po.setLimitScores(LIMIT_SCORES);
        ActivityChangeUserInfoPO activityChangeUserInfoPo = activityChangeUserInfoMapper.qryUserInfoLimitScore(po);
        if (activityChangeUserInfoPo == null) {
            dycActivityChangeDoModel.setLimitFlag(false);
            dycActivityChangeDoModel.setLimitFlagMessage(null);
        } else {
            dycActivityChangeDoModel.setLimitFlag(true);
            dycActivityChangeDoModel.setLimitFlagMessage("用户" + activityChangeUserInfoPo.getName() + "发放的积分数超" + LIMIT_SCORES + "了，请确认正确发放！");
        }
        return dycActivityChangeDoModel;
    }

    /**
     * 更新活动变更用户
     * @param dycActivityChangeUserInfo
     */
    @Override
    public void update(DycActivityChangeUserInfo dycActivityChangeUserInfo) {
        ActivityChangeUserInfoPO changeUser = ActRu.js(dycActivityChangeUserInfo,ActivityChangeUserInfoPO.class);
        changeUser.setUserId(dycActivityChangeUserInfo.getActUserId());
        changeUser.setUserName(dycActivityChangeUserInfo.getActUserName());
        changeUser.setName(dycActivityChangeUserInfo.getActName());
        changeUser.setWorkNo(dycActivityChangeUserInfo.getActWorkNo());
        changeUser.setUserOrgId(dycActivityChangeUserInfo.getActUserOrgId());
        changeUser.setUserOrgName(dycActivityChangeUserInfo.getActUserOrgName());
        changeUser.setUserCompanyId(dycActivityChangeUserInfo.getActUserCompanyId());
        changeUser.setUserCompanyName(dycActivityChangeUserInfo.getActUserCompanyName());
        changeUser.setUserOrgPath(dycActivityChangeUserInfo.getActUserOrgPath());
        activityChangeUserInfoMapper.update(changeUser);
    }

    @Override
    public List<ActivityChangeUserInfo> queryChangeActivityUserListAll(DycActivityChangeDO dycActivityChangeDO) {
        ActivityChangeUserInfoPO activityChangeUserInfoPo = new ActivityChangeUserInfoPO();
        activityChangeUserInfoPo.setChangeId(dycActivityChangeDO.getChangeId());
        if (!CollectionUtils.isEmpty(dycActivityChangeDO.getUserIdList())){
            activityChangeUserInfoPo.setUserIdList(dycActivityChangeDO.getUserIdList());
        }
        List<ActivityChangeUserInfoPO> changeUserInfoPoList = activityChangeUserInfoMapper.selectByConditionAll(activityChangeUserInfoPo);
        return JSON.parseArray(JSON.toJSONString(changeUserInfoPoList), ActivityChangeUserInfo.class);
    }

    @Override
    public int insertNew(DycActivityChangeUserInfo reqBo) {
        ActivityChangeUserInfoPO insert = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityChangeUserInfoPO.class);
        return activityChangeUserInfoMapper.insertNew(insert);
    }

    @Override
    public int updateByNew(DycActivityChangeUserInfo set, DycActivityChangeUserInfo where) {
        ActivityChangeUserInfoPO setPo = JSONObject.parseObject(JSONObject.toJSONString(set), ActivityChangeUserInfoPO.class);
        ActivityChangeUserInfoPO wherePo = JSONObject.parseObject(JSONObject.toJSONString(where), ActivityChangeUserInfoPO.class);
        return activityChangeUserInfoMapper.updateBy(setPo,wherePo);
    }

    @Override
    public int getCheckByNew(DycActivityChangeUserInfo reqBo) {
        ActivityChangeUserInfoPO insert = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityChangeUserInfoPO.class);
        return activityChangeUserInfoMapper.getCheckBy(insert);
    }

    @Override
    public DycActivityChangeUserInfo getModelByNew(DycActivityChangeUserInfo reqBo) {
        ActivityChangeUserInfoPO qryBo = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityChangeUserInfoPO.class);
        ActivityChangeUserInfoPO modelBy = activityChangeUserInfoMapper.getModelBy(qryBo);
        return JSONObject.parseObject(JSONObject.toJSONString(modelBy), DycActivityChangeUserInfo.class);
    }

    @Override
    public List<DycActivityChangeUserInfo> getListNew(DycActivityChangeUserInfo reqBo) {
        ActivityChangeUserInfoPO qryBo = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityChangeUserInfoPO.class);
        List<ActivityChangeUserInfoPO> list = activityChangeUserInfoMapper.getList(qryBo);
        return JSONObject.parseArray(JSONObject.toJSONString(list), DycActivityChangeUserInfo.class);
    }

    @Override
    public void insertBatchNew(List<DycActivityChangeUserInfo> list) {
        List<ActivityChangeUserInfoPO> listPo = JSONObject.parseArray(JSONObject.toJSONString(list), ActivityChangeUserInfoPO.class);
        activityChangeUserInfoMapper.insertBatch(listPo);
    }
}
