package com.tydic.dyc.act.repository.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.model.bo.ActUpdateAlertInfo;
import com.tydic.dyc.act.model.bo.DycActDealOrderAlertDO;
import com.tydic.dyc.act.repository.api.DycActAlertInfoRepository;
import com.tydic.dyc.act.repository.dao.ActAlertInfoMapper;
import com.tydic.dyc.act.repository.po.ActAlertInfoPO;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @ClassName DycActAlertInfoRepositoryImpl
 * @Author 14051
 * @Date 2024/4/16 17:40
 * @Version 1.0
 **/
@Service
public class DycActAlertInfoRepositoryImpl implements DycActAlertInfoRepository {

    @Autowired
    private ActAlertInfoMapper actAlertInfoMapper;

    @Override
    public int saveAlertInfo(DycActDealOrderAlertDO reqBO) {
        List<ActAlertInfoPO> actAlertInfoPOS = new ArrayList<>();
        if (StringUtils.isNotBlank(reqBO.getOrderId())){
            ActAlertInfoPO po = new ActAlertInfoPO();
            po.setId(Sequence.getInstance().nextId());
            po.setObjId(reqBO.getOrderId());
            po.setObjType(reqBO.getObjType());
            po.setAlertType(reqBO.getAlertType());
            po.setAlertState(reqBO.getAlertState());
            po.setCreateTime(new Date());
            actAlertInfoPOS.add(po);
        }
        if (!CollectionUtils.isEmpty(reqBO.getOrderIds())) {
            actAlertInfoPOS = reqBO.getOrderIds().stream().map(orderId -> {
                ActAlertInfoPO po = new ActAlertInfoPO();
                po.setId(Sequence.getInstance().nextId());
                po.setObjId(orderId);
                po.setObjType(reqBO.getObjType());
                po.setAlertType(reqBO.getAlertType());
                po.setAlertState(reqBO.getAlertState());
                po.setCreateTime(new Date());
                return po;
            }).collect(Collectors.toList());
        }
        return actAlertInfoMapper.allInsert(actAlertInfoPOS);
    }

    @Override
    public int updateAlertInfo(DycActDealOrderAlertDO reqBO) {
        ActAlertInfoPO record = new ActAlertInfoPO();
        record.setAlertState(reqBO.getAlertState());
        record.setIds(reqBO.getUpdAlertInfoList().stream().map(ActUpdateAlertInfo::getId).collect(Collectors.toList()));
        return actAlertInfoMapper.batchUpdate(record);
    }
}
