package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSONObject;import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.constant.BaseRspConstants;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.api.DycActSkuPoolRepository;
import com.tydic.dyc.act.repository.dao.ActRelSkuPoolMapper;
import com.tydic.dyc.act.repository.dao.ActSkuPoolMapper;
import com.tydic.dyc.act.repository.po.ActRelSkuPoolPO;
import com.tydic.dyc.act.repository.po.ActSkuPoolExtPO;
import com.tydic.dyc.act.repository.po.ActSkuPoolPO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPoolReqBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPoolRspBO;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.base.utils.JUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

@Service("actSkuPoolService")
public class DycActSkuPoolRepositoryImpl implements DycActSkuPoolRepository {

    @Autowired
    ActSkuPoolMapper actSkuPoolMapper;
    @Autowired
    private ActRelSkuPoolMapper actRelSkuPoolMapper;

    @Override
    public DycActQuerySkuPoolRspBO queryActSkuPoolSingle(DycActQuerySkuPoolReqBO actSkuPoolReqBO){
        DycActQuerySkuPoolRspBO rspBO = new DycActQuerySkuPoolRspBO();
        ActSkuPoolExtPO selectActSkuPoolPO = new ActSkuPoolExtPO();
        BeanUtils.copyProperties(actSkuPoolReqBO, selectActSkuPoolPO);
        List<ActSkuPoolPO> actSkuPoolList = this.actSkuPoolMapper.selectByCondition(selectActSkuPoolPO);
        if (actSkuPoolList.size() == 1) {
            rspBO = JUtil.js(actSkuPoolList.get(0),DycActQuerySkuPoolRspBO.class);
            if(DycActivityConstants.PoolType.SUPPLIER == actSkuPoolList.get(0).getPoolType()){
                rspBO.setPoolTypeDesc(DycActivityConstants.PoolType.SUPPLIERSTR);
            }
            if(DycActivityConstants.PoolType.COMMODITY == actSkuPoolList.get(0).getPoolType()){
                rspBO.setPoolTypeDesc(DycActivityConstants.PoolType.COMMODITYSTR);
            }
            if(DycActivityConstants.PoolType.CATALOG == actSkuPoolList.get(0).getPoolType()){
                rspBO.setPoolTypeDesc(DycActivityConstants.PoolType.CATALOGSTR);
            }
            ActRelSkuPoolPO relSkuPoolPO = new ActRelSkuPoolPO();
            relSkuPoolPO.setPoolId(actSkuPoolReqBO.getPoolId());
            List<ActRelSkuPoolPO> actRelSkuPoolPOS = actRelSkuPoolMapper.selectByCondition(relSkuPoolPO);
            if(CollectionUtils.isEmpty(actRelSkuPoolPOS)){
                rspBO.setSkuNum(0);
            }else {
                rspBO.setSkuNum(actRelSkuPoolPOS.size());
            }

        } else if (actSkuPoolList.size() > 1) {
            throw new ZTBusinessException("查询信息（单个）失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("查询信息（单个）失败：不存在对应的信息");
        }
        return rspBO;
    }

    @Override
    public ActSkuPoolListRspBO queryActSkuPoolList(ActSkuPoolReqBO actSkuPoolReqBO) {
        ActSkuPoolListRspBO rspBO = new ActSkuPoolListRspBO();
        ActSkuPoolExtPO selectActSkuPoolPO = new ActSkuPoolExtPO();
        BeanUtils.copyProperties(actSkuPoolReqBO, selectActSkuPoolPO);
        List<ActSkuPoolPO> actSkuPoolPOList = this.actSkuPoolMapper.selectByCondition(selectActSkuPoolPO);

        List<ActSkuPoolBO> actSkuPoolBOList = new ArrayList<>();
        for (ActSkuPoolPO actSkuPoolPO : actSkuPoolPOList) {
            ActSkuPoolBO actSkuPoolBO = new ActSkuPoolBO();
            BeanUtils.copyProperties(actSkuPoolPO, actSkuPoolBO);
            actSkuPoolBOList.add(actSkuPoolBO);
        }

        rspBO.setData(actSkuPoolBOList);
        rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
        rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        return rspBO;
    }

    @Override
    public RspPage<ActSkuPoolBO> queryActSkuPoolListPage(ActSkuPoolReqBO actSkuPoolReqBO) {
        if (actSkuPoolReqBO.getPageNo() < 1) {
            actSkuPoolReqBO.setPageNo(1);
        }
        if (actSkuPoolReqBO.getPageSize() < 1) {
            actSkuPoolReqBO.setPageSize(10);
        }

        ActSkuPoolExtPO selectActSkuPoolPO = new ActSkuPoolExtPO();
        BeanUtils.copyProperties(actSkuPoolReqBO, selectActSkuPoolPO);
        Page<ActSkuPoolPO> page = PageHelper.startPage(actSkuPoolReqBO.getPageNo(), actSkuPoolReqBO.getPageSize()).doSelectPage(() -> this.actSkuPoolMapper.selectByCondition(selectActSkuPoolPO));

        //封装集合
        List<ActSkuPoolBO> actSkuPoolBOList = new ArrayList<>();
        for (ActSkuPoolPO actSkuPoolPO : page.getResult()) {
            ActSkuPoolBO actSkuPoolBO = new ActSkuPoolBO();
            BeanUtils.copyProperties(actSkuPoolPO, actSkuPoolBO);
            actSkuPoolBOList.add(actSkuPoolBO);
        }

        RspPage<ActSkuPoolBO> rspPage = new RspPage<>();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(actSkuPoolBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        return rspPage;
    }

    @Override
    public ActSkuPoolRspBO addActSkuPool(ActSkuPoolReqBO actSkuPoolReqBO) {
        ActSkuPoolRspBO rspBO = new ActSkuPoolRspBO();
        //校验名称是否重复
        ActSkuPoolExtPO extPO = new ActSkuPoolExtPO();
        extPO.setPoolName(actSkuPoolReqBO.getPoolName());
        List<ActSkuPoolPO> actSkuPoolPOS = actSkuPoolMapper.selectByCondition(extPO);
        if(!CollectionUtils.isEmpty(actSkuPoolPOS)){
            throw new ZTBusinessException("新增信息失败：商品池名称重复");
        }
        ActSkuPoolPO insertActSkuPoolPO = new ActSkuPoolPO();
        long id = Sequence.getInstance().nextId();
        insertActSkuPoolPO.setPoolId(id);
        insertActSkuPoolPO.setPoolCode(actSkuPoolReqBO.getPoolCode());
        insertActSkuPoolPO.setPoolName(actSkuPoolReqBO.getPoolName());
        insertActSkuPoolPO.setPoolType(actSkuPoolReqBO.getPoolType());
        insertActSkuPoolPO.setRemark(actSkuPoolReqBO.getRemark());
        insertActSkuPoolPO.setCreateTime(new Date());
        insertActSkuPoolPO.setCreateOperName(actSkuPoolReqBO.getName());
        int num = this.actSkuPoolMapper.insert(insertActSkuPoolPO);
        if (num == 1) {
            ActSkuPoolBO ActSkuPoolBO = new ActSkuPoolBO();
            BeanUtils.copyProperties(insertActSkuPoolPO, ActSkuPoolBO);
            rspBO.setData(ActSkuPoolBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else {
            throw new ZTBusinessException("新增信息失败：新增信息失败");
        }
        return rspBO;
    }


    @Override
    public ActSkuPoolListRspBO addListActSkuPool(List<ActSkuPoolReqBO> actSkuPoolReqBO) {
        ActSkuPoolListRspBO rspBO = new ActSkuPoolListRspBO();
        for(int i = 0;i < actSkuPoolReqBO.size();i++){
                            long id = Sequence.getInstance().nextId();
                actSkuPoolReqBO.get(i).setPoolId(id);
                }

        List<ActSkuPoolPO> insertActSkuPoolPO = JSONObject.parseArray(JSONObject.toJSONString(actSkuPoolReqBO),ActSkuPoolPO.class);


        int num = this.actSkuPoolMapper.allInsert(insertActSkuPoolPO);
        if (num == actSkuPoolReqBO.size()) {
            List<ActSkuPoolBO> lActSkuPoolBO = JSONObject.parseArray(JSONObject.toJSONString(insertActSkuPoolPO),ActSkuPoolBO.class);
            rspBO.setData(lActSkuPoolBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else {
            throw new ZTBusinessException("新增信息失败：新增信息失败");
        }
        return rspBO;
    }

    @Override
    public ActSkuPoolRspBO updateActSkuPool(ActSkuPoolReqBO actSkuPoolReqBO) {
        ActSkuPoolRspBO rspBO = new ActSkuPoolRspBO();
        ActSkuPoolExtPO selectActSkuPoolPO = new ActSkuPoolExtPO();
        selectActSkuPoolPO.setPoolId(actSkuPoolReqBO.getPoolId());
        List<ActSkuPoolPO> actSkuPoolList = this.actSkuPoolMapper.selectByCondition(selectActSkuPoolPO);
        if (actSkuPoolList.size() == 1) {
            ActSkuPoolPO updateActSkuPoolPO = new ActSkuPoolPO();
            BeanUtils.copyProperties(actSkuPoolReqBO, updateActSkuPoolPO);

            int num = this.actSkuPoolMapper.update(updateActSkuPoolPO);
            if (num == 1) {
                ActSkuPoolBO actSkuPoolBO = new ActSkuPoolBO();
                BeanUtils.copyProperties(updateActSkuPoolPO, actSkuPoolBO);
                rspBO.setData(actSkuPoolBO);
                rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
                rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
            } else {
                throw new ZTBusinessException("修改信息失败：修改信息失败");
            }
        } else if (actSkuPoolList.size() > 1) {
            throw new ZTBusinessException("修改信息失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("修改信息失败：不存在对应的信息");
        }
        return rspBO;
    }

    @Override
    public ActSkuPoolRspBO saveActSkuPool(ActSkuPoolReqBO actSkuPoolReqBO) {
        //新增信息
        if (actSkuPoolReqBO.getPoolId() == null) {
            return this.addActSkuPool(actSkuPoolReqBO);
        }
        //修改信息
        else {
            return this.updateActSkuPool(actSkuPoolReqBO);
        }
    }

    @Override
    public ActSkuPoolRspBO deleteActSkuPool(ActSkuPoolReqBO actSkuPoolReqBO) {
        ActSkuPoolRspBO rspBO = new ActSkuPoolRspBO();
        ActSkuPoolExtPO selectActSkuPoolPO = new ActSkuPoolExtPO();
        selectActSkuPoolPO.setPoolId(actSkuPoolReqBO.getPoolId());
        List<ActSkuPoolPO> actSkuPoolList = this.actSkuPoolMapper.selectByCondition(selectActSkuPoolPO);
        if (actSkuPoolList.size() == 1) {
            ActSkuPoolPO deleteActSkuPoolPO = new ActSkuPoolPO();
            BeanUtils.copyProperties(actSkuPoolReqBO, deleteActSkuPoolPO);

            int num = this.actSkuPoolMapper.delete(deleteActSkuPoolPO);
            if (num == 1) {
                rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
                rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
            } else {
                throw new ZTBusinessException("删除信息失败：删除信息失败");
            }
        } else if (actSkuPoolList.size() > 1) {
            throw new ZTBusinessException("删除信息失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("删除信息失败：不存在对应的信息");
        }
        return rspBO;
    }

    @Override
    public RspPage<ActSkuPoolBO> querySkuPoolPageList(ActSkuPoolReqBO actSkuPoolReqBO) {
        if (actSkuPoolReqBO.getPageNo() < 1) {
            actSkuPoolReqBO.setPageNo(1);
        }
        if (actSkuPoolReqBO.getPageSize() < 1) {
            actSkuPoolReqBO.setPageSize(10);
        }
        ActSkuPoolExtPO qryPO = ActRu.js(actSkuPoolReqBO, ActSkuPoolExtPO.class);
        Page<ActSkuPoolExtPO> page = PageHelper.startPage(actSkuPoolReqBO.getPageNo(), actSkuPoolReqBO.getPageSize()).doSelectPage(() -> this.actSkuPoolMapper.getListPage(qryPO));
        RspPage<ActSkuPoolBO> rspPage = new RspPage<>();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        if (!CollectionUtils.isEmpty(page.getResult())) {
            Map<Integer, List<ActSkuPoolExtPO>> poolTypeMap =
                    page.getResult().stream().collect(Collectors.groupingBy(ActSkuPoolExtPO::getPoolType));
            Iterator<Map.Entry<Integer, List<ActSkuPoolExtPO>>> iterator = poolTypeMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Integer poolType = iterator.next().getKey();
                List<Long> poolIdList = poolTypeMap.get(poolType).stream().map(ActSkuPoolExtPO::getPoolId).collect(Collectors.toList());
                ActSkuPoolExtPO poolExtPO = new ActSkuPoolExtPO();
                poolExtPO.setPoolType(poolType);
                poolExtPO.setPoolIdList(poolIdList);
                List<ActSkuPoolExtPO> skuPoolExtPOS = actSkuPoolMapper.getSkuNum(poolExtPO);
                if (!CollectionUtils.isEmpty(skuPoolExtPOS)) {
                    Map<Long, Integer> poolToSkuNumMap = skuPoolExtPOS.stream()
                            .collect(Collectors.toMap(ActSkuPoolExtPO::getPoolId, ActSkuPoolExtPO::getSkuNum));
                    for (ActSkuPoolExtPO extPO : poolTypeMap.get(poolType)) {
                        if (poolToSkuNumMap.containsKey(extPO.getPoolId())) {
                            extPO.setSkuNum(poolToSkuNumMap.get(extPO.getPoolId()));
                        }
                    }
                }
            }
            rspPage.setRows(ActRu.jsl(page.getResult(), ActSkuPoolBO.class));
        }

        return rspPage;
    }

}
