package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.model.bo.DycActivityFlowInstanceInfo;
import com.tydic.dyc.act.model.bo.DycProcessDO;
import com.tydic.dyc.act.repository.api.DycActivityFlowInstanceRepository;
import com.tydic.dyc.act.repository.dao.ActivityFlowInstanceMapper;
import com.tydic.dyc.act.repository.po.ActivityFlowInstancePO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class DycActivityFlowInstanceRepositoryImpl implements DycActivityFlowInstanceRepository {

    @Autowired
    ActivityFlowInstanceMapper activityFlowInstanceMapper;

    @Override
    public DycActivityFlowInstanceInfo queryActivityFlowInstanceSingle(DycProcessDO activityFlowInstanceReqBO) {
        DycActivityFlowInstanceInfo rspBO = new DycActivityFlowInstanceInfo();
        ActivityFlowInstancePO selectActivityFlowInstancePO = new ActivityFlowInstancePO();
        BeanUtils.copyProperties(activityFlowInstanceReqBO, selectActivityFlowInstancePO);
        List<ActivityFlowInstancePO> activityFlowInstanceList = this.activityFlowInstanceMapper.selectByCondition(selectActivityFlowInstancePO);
        if (activityFlowInstanceList.size() == 1) {
            BeanUtils.copyProperties(activityFlowInstanceList.get(0), rspBO);
        } else if (activityFlowInstanceList.size() > 1) {
            throw new ZTBusinessException("查询信息（单个）失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("查询信息（单个）失败：不存在对应的信息");
        }
        return rspBO;
    }

    @Override
    public List<DycActivityFlowInstanceInfo> queryActivityFlowInstanceList(DycProcessDO activityFlowInstanceReqBO) {
        ActivityFlowInstancePO selectActivityFlowInstancePO = new ActivityFlowInstancePO();
        BeanUtils.copyProperties(activityFlowInstanceReqBO, selectActivityFlowInstancePO);
        List<ActivityFlowInstancePO> activityFlowInstancePOList = this.activityFlowInstanceMapper.selectByCondition(selectActivityFlowInstancePO);

        List<DycActivityFlowInstanceInfo> activityFlowInstanceBOList = new ArrayList<>();
        for (ActivityFlowInstancePO activityFlowInstancePO : activityFlowInstancePOList) {
            DycActivityFlowInstanceInfo activityFlowInstanceBO = new DycActivityFlowInstanceInfo();
            BeanUtils.copyProperties(activityFlowInstancePO, activityFlowInstanceBO);
            activityFlowInstanceBOList.add(activityFlowInstanceBO);
        }
        return activityFlowInstanceBOList;
    }

    @Override
    public Long addActivityFlowInstance(DycProcessDO activityFlowInstanceReqBO) {
        ActivityFlowInstancePO insertActivityFlowInstancePo = new ActivityFlowInstancePO();
        BeanUtils.copyProperties(activityFlowInstanceReqBO.getFlowInstanceInfoList().get(0), insertActivityFlowInstancePo);
        long id = Sequence.getInstance().nextId();
        insertActivityFlowInstancePo.setId(id);
        insertActivityFlowInstancePo.setDelFlag(0);
        int num = this.activityFlowInstanceMapper.insert(insertActivityFlowInstancePo);
        if (num != 1) {
            throw new ZTBusinessException("新增信息失败：新增信息失败");
        }
        return id;
    }


    @Override
    public int addListActivityFlowInstance(DycProcessDO activityFlowInstanceReqBO) {
        List<ActivityFlowInstancePO> insertActivityFlowInstancePO = JSONObject.parseArray(JSONObject.toJSONString(activityFlowInstanceReqBO.getFlowInstanceInfoList()), ActivityFlowInstancePO.class);
        //TODO 封装其它信息

        int num = this.activityFlowInstanceMapper.allInsert(insertActivityFlowInstancePO);
        if (num != activityFlowInstanceReqBO.getFlowInstanceInfoList().size()) {
            throw new ZTBusinessException("新增信息失败：新增信息失败");
        }
        return num;
    }

    @Override
    public int updateActivityFlowInstance(DycProcessDO activityFlowInstanceReqBO) {
        ActivityFlowInstancePO updateActivityFlowInstancePO = new ActivityFlowInstancePO();
        BeanUtils.copyProperties(activityFlowInstanceReqBO.getFlowInstanceInfoList().get(0), updateActivityFlowInstancePO);
        int num = this.activityFlowInstanceMapper.update(updateActivityFlowInstancePO);
        if (num != 1) {
            throw new ZTBusinessException("修改信息失败：修改信息失败");
        }
        return num;
    }


    @Override
    public int deleteActivityFlowInstance(DycProcessDO activityFlowInstanceReqBO) {
        ActivityFlowInstancePO deleteActivityFlowInstancePO = new ActivityFlowInstancePO();
        BeanUtils.copyProperties(activityFlowInstanceReqBO, deleteActivityFlowInstancePO);

        int num = this.activityFlowInstanceMapper.delete(deleteActivityFlowInstancePO);
        if (num != 1) {
            throw new ZTBusinessException("删除信息失败：删除信息失败");
        }
        return num;
    }

}
