package com.tydic.dyc.act.repository.po;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @ClassName: ActFscCheckResultPO
 * @Description: ActFscCheckResultPO
 * @author: liaoyang
 * @date: 2024年04月02日20:05:25
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class ActFscCheckResultPO implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 订单ID
	 */
    private String orderId;
	/**
	 * 供应商ID
	 */
    private Long supplierId;
	/**
	 * 操作流水
	 */
    private Long operSn;
	/**
	 * 对方编号
	 */
    private String otherNo;
	/**
	 * 供应商金额
	 */
    private BigDecimal otherAmount;
	/**
	 * 商城金额
	 */
    private BigDecimal amount;
	/**
	 * 订单金额
	 */
    private BigDecimal saleAmount;
	/**
	 * 个人支付金额
	 */
	private BigDecimal personAmount;
	/**
	 * 状态：0未对账，1对账一致，2对账不一致，3已确认
	 */
    private Integer status;
	/**
	 * 对账时间
	 */
    private Date checkTime;
	/**
	 * 对账人
	 */
    private Long operId;
	/**
	 * 对账人名称
	 */
    private String operName;
	/**
	 * 订单下单时间
	 */
    private Date orderTime;
	/**
	 * 最后付款日期
	 */
    private Date lastPayDate;
	/**
	 * 活动ID
	 */
	private Long activityId;
	/**
	 * 结算单ID
	 */
	private Long fscOrderId;
}