package com.tydic.dyc.act.repository.po;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @ClassName: ActFscInvoiceItemPO
 * @Description: ActFscInvoiceItemPO
 * @author: liaoyang
 * @date: 2024年04月02日20:05:25
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class ActFscInvoiceItemPO implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 主键ID
	 */
    private Long id;
	/**
	 * 结算单ID
	 */
    private Long fscOrderId;
	/**
	 * 订单ID
	 */
    private Long orderId;
	/**
	 * 订单明细ID
	 */
    private Long orderItemId;
	/**
	 * 商品ID
	 */
    private Long skuId;
	/**
	 * 商品名称
	 */
    private String skuName;
	/**
	 * 规格
	 */
    private String spec;
	/**
	 * 型号
	 */
    private String model;
	/**
	 * 税额
	 */
    private BigDecimal taxAmt;
	/**
	 * 单位
	 */
    private String unit;
	/**
	 * 税收分类编码
	 */
    private String taxCode;
	/**
	 * 数量
	 */
    private BigDecimal num;
	/**
	 * 单价
	 */
    private BigDecimal price;
	/**
	 * 总价
	 */
    private BigDecimal amt;
	/**
	 * 总价(不含税)
	 */
    private BigDecimal untaxAmt;
	/**
	 * 税率
	 */
    private BigDecimal taxRate;
	/**
	 * 发票ID
	 */
    private Long invoiceId;

}