package com.tydic.dyc.act.repository.po;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题 ActUserScoresBaseInfoPO
 * 说明
 * 时间 2024/4/16 14:44
 *
 * @author 唐富强
 */
@Data
public class ActUserScoresBaseInfoPO implements Serializable {


    private static final long serialVersionUID = 1654919363644725735L;
    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 活动场景id
     */
    private Long activitySceneId;

    /**
     * 活动场景名称
     */
    private String activitySceneName;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 活动类型
     */
    private Integer activityType;

    /**
     * 活动开始时间
     */
    private Date activityStartTime;

    /**
     * 活动结束时间
     */
    private Date activityEndTime;

    /**
     * 活动状态
     */
    private String activityState;

    /**
     * 活动状态集合
     */
    private List<String> activityStateList;

    /**
     * 发放积分
     */
    private BigDecimal giveScores;

    /**
     * 已使用积分
     */
    private BigDecimal usedScores;

    /**
     * 剩余可用积分
     */
    private BigDecimal balanceScores;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 活动适用组织id
     */
    private Long activityScopeOrgId;
    /**
     * 活动适用组织名称
     */
    private String activityScopeOrgName;
    /**
     * 活动PC端banner图url
     */
    private String pcBannerPicUrl;
    /**
     * 活动浮窗图url
     */
    private String emergePicUrl;
    /**
     * 活动app端banner图url
     */
    private String appBannerPicUrl;

    /**
     * 排序规则
     */
    private String orderBy;

    /**
     * 活动结束时间
     */
    private Date activityEndTimeStart;
    /**
     * 活动结束时间
     */
    private Date activityEndTimeEnd;

    /**
     * 剩余积分最小值
     */
    private BigDecimal balanceScoresMin;
    /**
     * 剩余积分最大值
     */
    private BigDecimal balanceScoresMax;

    /**
     * 用户名称
     */
    private Long userName;

    /**
     * 是否已经发送预警通知：1：发送 0或空:未发送
     */
    private Integer isNotify;


}
