package com.tydic.dyc.act.repository.po;

import lombok.Data;
import java.math.BigDecimal;
import java.io.Serializable;
import java.util.Date;

/**
 * @ClassName: ActivityTokenMoneyPO
 * @Description: ActivityTokenMoneyPO
 * @author: zhoulu
 * @date: 2023年12月11日16:43:59
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class ActivityTokenMoneyPO implements Serializable {


	private static final long serialVersionUID = 1895689785997370648L;
	/**
	 * 代币id
	 */
    private Long tokenId;
	/**
	 * 代币名称
	 */
    private String tokenName;
	/**
	 * 代币图标
	 */
    private String tokenIconUrl;
	/**
	 * 代币数量
	 */
    private BigDecimal tokenNumber;
	/**
	 * 货币金额
	 */
    private BigDecimal convertAmount;
	/**
	 * 货币单位
	 */
    private String convertUnit;
	/**
	 * 应用单位ID
	 */
    private Long useOrgId;
	/**
	 * 应用单位名称
	 */
    private String useOrgName;
	/**
	 * 创建时间
	 */
    private Date createTime;
	/**
	 * 创建人ID
	 */
    private Long createUserId;
	/**
	 * 创建人名称
	 */
    private String createUserName;
	/**
	 * 更新时间
	 */
    private Date updateTime;
	/**
	 * 更新人名称
	 */
    private String updateUserName;
	/**
	 * 更新人ID
	 */
    private Long updateUserId;

}