package com.tydic.dyc.act.repository.dao;

import com.tydic.dyc.act.repository.po.ActAlertInfoPO;

import java.util.List;

/**
 * @ClassName: ActAlertInfoMapper
 * @Description: ActAlertInfoMapper
 * @author: liaoyang
 * @date: 2024年04月16日17:42:19
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface ActAlertInfoMapper {

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActAlertInfoPO>
     * @author: liaoyang
     * @date: 2024年04月16日17:42:19
     */
    List<ActAlertInfoPO> selectByCondition(ActAlertInfoPO record);

    /**
     * 描述: 根据条件删除
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年04月16日17:42:19
     */
    int delete(ActAlertInfoPO record);

    /**
     * 描述: 插入单条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年04月16日17:42:19
     */
    int insert(ActAlertInfoPO record);

    /**
     * 描述: 插入多条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年04月16日17:42:19
     */
    int allInsert(List<ActAlertInfoPO> record);

    /**
     * 描述: 更新单条数据（可选择的）
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年04月16日17:42:19
     */
    int update(ActAlertInfoPO record);

    /**
     * 批量更新预警记录表
     * @param record
     * @return
     */
    int batchUpdate(ActAlertInfoPO record);
}
