package com.tydic.dyc.act.repository.dao;

import com.tydic.dyc.act.repository.po.ActFscOrderBatchInfoPO;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @ClassName: ActFscOrderBatchInfoMapper
 * @Description: ActFscOrderBatchInfoMapper
 * @author: liaoyang
 * @date: 2024年04月02日20:05:24
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Mapper
@Repository
public interface ActFscOrderBatchInfoMapper {

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActFscOrderBatchInfoPO>
     * @author: liaoyang
     * @date: 2024年04月02日20:05:24
     */
    List<ActFscOrderBatchInfoPO> selectByCondition(ActFscOrderBatchInfoPO record);

    /**
     * 描述: 根据条件删除
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年04月02日20:05:24
     */
    int delete(ActFscOrderBatchInfoPO record);

    /**
     * 描述: 插入单条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年04月02日20:05:24
     */
    int insert(ActFscOrderBatchInfoPO record);

    /**
     * 描述: 插入多条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年04月02日20:05:24
     */
    int allInsert(List<ActFscOrderBatchInfoPO> record);

    /**
     * 描述: 更新单条数据（可选择的）
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年04月02日20:05:24
     */
    int update(ActFscOrderBatchInfoPO record);

    /**
     * 查询推送失败的数量
     * @param reqBO
     * @return
     */
    int getFscPushFailNum(ActFscOrderBatchInfoPO reqBO);
}
