package com.tydic.dyc.act.repository.dao;

import com.tydic.dyc.act.repository.po.ActFscOrderInvoicePO;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @ClassName: ActFscOrderInvoiceMapper
 * @Description: ActFscOrderInvoiceMapper
 * @author: liaoyang
 * @date: 2024年04月02日20:05:25
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Mapper
@Repository
public interface ActFscOrderInvoiceMapper {

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActFscOrderInvoicePO>
     * @author: liaoyang
     * @date: 2024年04月02日20:05:25
     */
    List<ActFscOrderInvoicePO> selectByCondition(ActFscOrderInvoicePO record);

    /**
     * 描述: 根据条件删除
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年04月02日20:05:25
     */
    int delete(ActFscOrderInvoicePO record);

    /**
     * 描述: 插入单条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年04月02日20:05:25
     */
    int insert(ActFscOrderInvoicePO record);

    /**
     * 描述: 插入多条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年04月02日20:05:25
     */
    int allInsert(List<ActFscOrderInvoicePO> record);

    /**
     * 描述: 更新单条数据（可选择的）
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年04月02日20:05:25
     */
    int update(ActFscOrderInvoicePO record);
	
}
