package com.tydic.dyc.act.repository.dao;

import com.tydic.dyc.act.repository.po.ActLaborUnionInfoPO;
import java.util.List;

/**
 * @ClassName: ActLaborUnionInfoMapper
 * @Description: ActLaborUnionInfoMapper
 * @author: liaoyang
 * @date: 2024年03月26日15:51:47
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface ActLaborUnionInfoMapper {

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActLaborUnionInfoPO>
     * @author: liaoyang
     * @date: 2024年03月26日15:51:47
     */
    List<ActLaborUnionInfoPO> selectByCondition(ActLaborUnionInfoPO record);


    /**
     * 描述: 连表查询工会与机构关系
     *
     * @throws
     * @param: po
     * @return: List<ActLaborUnionInfoPO>
     * @author: liaoyang
     * @date: 2024年03月26日15:51:47
     */
    List<ActLaborUnionInfoPO> selectlaborAndOrg(ActLaborUnionInfoPO record);

    /**
     * 描述: 机构所属工会下拉框查询
     *
     * @throws
     * @param: po
     * @return: List<ActLaborUnionInfoPO>
     * @author: liaoyang
     * @date: 2024年03月26日15:51:47
     */
    List<ActLaborUnionInfoPO> queryOrgBelongLaborUnion(ActLaborUnionInfoPO record);

    /**
     * 描述: 根据条件删除
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年03月26日15:51:47
     */
    int delete(ActLaborUnionInfoPO record);

    /**
     * 描述: 插入单条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年03月26日15:51:47
     */
    int insert(ActLaborUnionInfoPO record);

    /**
     * 描述: 插入多条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年03月26日15:51:47
     */
    int allInsert(List<ActLaborUnionInfoPO> record);

    /**
     * 描述: 更新单条数据（可选择的）
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年03月26日15:51:47
     */
    int update(ActLaborUnionInfoPO record);
	
}
