package com.tydic.dyc.act.repository.dao;

import com.tydic.dyc.act.repository.po.ActOrderInfoPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.math.BigDecimal;
import java.util.List;

/**
 * @ClassName: ActOrderInfoMapper
 * @Description: ActOrderInfoMapper
 * @author: liaoyang
 * @date: 2024年04月02日10:25:15
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Mapper
@Repository
public interface ActOrderInfoMapper {

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActOrderInfoPO>
     * @author: liaoyang
     * @date: 2024年04月02日10:25:15
     */
    List<ActOrderInfoPO> selectByCondition(ActOrderInfoPO record);

    /**
     * 描述: 根据条件删除
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年04月02日10:25:15
     */
    int delete(ActOrderInfoPO record);

    /**
     * 描述: 插入单条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年04月02日10:25:15
     */
    int insert(ActOrderInfoPO record);

    /**
     * 描述: 插入多条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年04月02日10:25:15
     */
    int allInsert(List<ActOrderInfoPO> record);

    /**
     * 描述: 更新单条数据（可选择的）
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年04月02日10:25:15
     */
    int update(ActOrderInfoPO record);

    /**
     * 查询活动总积分
     * @param activityId
     * @return
     */
    BigDecimal getTotalScoreByActivityId(@Param("activityId") Long activityId);

    /**
     * 查询未发货订单列表
     * @param record
     * @return
     */
    List<String> qryUnSendOrderList(ActOrderInfoPO record);
    /**
     * 查询未收货订单列表
     * @param record
     * @return
     */
    List<String> qryUnReceiveOrderList(ActOrderInfoPO record);

    int updateAlertType(ActOrderInfoPO record);
}
