package com.tydic.dyc.act.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.act.repository.po.ActivityChangeInfoPO;
import com.tydic.dyc.act.repository.po.ActivityChangeInfoTimePO;
import com.tydic.dyc.act.repository.po.DycActActivityApproveBaseInfoPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @ClassName: ActivityChangeInfoMapper
 * @Description: ActivityChangeInfoMapper
 * @author: zhoulu
 * @date: 2023年12月11日16:43:59
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Mapper
@Repository
public interface ActivityChangeInfoMapper {

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActivityChangeInfoPO>
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    List<ActivityChangeInfoPO> selectByCondition(ActivityChangeInfoPO record);

    /**
     * 描述: 根据条件删除
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    int delete(ActivityChangeInfoPO record);

    /**
     * 描述: 插入单条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    int insert(ActivityChangeInfoPO record);

    /**
     * 描述: 插入多条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    int allInsert(List<ActivityChangeInfoPO> record);

    /**
     * 描述: 更新单条数据（可选择的）
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    int update(ActivityChangeInfoPO record);

    /**
     * 活动变更列表查询（分页）服务
     * @param activityChangeInfoTimePO
     * @return
     */
    List<ActivityChangeInfoPO> queryActivityChangePageList(ActivityChangeInfoTimePO activityChangeInfoTimePO);

    /**
     * 活动变更审批列表查询（分页）服务
     * @param activityBaseInfoTimePO
     */
    List<DycActActivityApproveBaseInfoPO> queryActivityChangeApprovePageList(ActivityChangeInfoTimePO activityBaseInfoTimePO);

    /**
     * 插入单条数据
     *
     * @param activityChangeInfoPo 参数对象
     * @return int 影响数量
     */
    int insertNew(ActivityChangeInfoPO activityChangeInfoPo);

    /**
     * 根据条件更新数据
     *
     * @param set set新值
     * @param where where条件（旧值）
     * @return int 影响数量
     */
    int updateBy(@Param("set") ActivityChangeInfoPO set, @Param("where") ActivityChangeInfoPO where);

    /**
     * 根据条件校验有多少条数据
     *
     * @param activityChangeInfoPo 参数对象
     * @return int 总数量
     */
    int getCheckBy(ActivityChangeInfoPO activityChangeInfoPo);

    /**
     * 根据条件查询单条数据
     *
     * @param activityChangeInfoPo 参数对象
     * @return DycActActivityApproveBaseInfoPO 结果对象
     */
    ActivityChangeInfoPO getModelBy(ActivityChangeInfoPO activityChangeInfoPo);

    /**
     * 根据条件查询列表数据
     *
     * @param activityChangeInfoPo 参数对象
     * @return List<DycActActivityApproveBaseInfoPO> 结果对象
     */
    List<ActivityChangeInfoPO> getList(ActivityChangeInfoPO activityChangeInfoPo);

    /**
     * 根据条件分页查询列表数据
     *
     * @param activityChangeInfoPo 参数对象
     * @param page 分页参数
     * @return List<DycActActivityApproveBaseInfoPO> 结果对象
     */
    List<ActivityChangeInfoPO> getListPage(ActivityChangeInfoPO activityChangeInfoPo, Page<ActivityChangeInfoPO> page);

    /**
     * 批量插入数据
     *
     * @param list 参数列表
     */
    void insertBatch(List<ActivityChangeInfoPO> list);
}
